/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.MenuClickHandler;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.PageTypeRegistry;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageQuickMoveHandler;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.util.SortType;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class EndlessInventoryMenu
extends AbstractContainerMenu
implements PageMetaDataManager,
PageQuickMoveHandler.PageQuickMoveOverride {
    private final SourceInventory sourceInventory;
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer craftResult = new ResultContainer();
    private static final int CRAFT_GRID_WIDTH = 3;
    private static final int CRAFT_GRID_HEIGHT = 3;
    private static final int RESULT_SLOT_INDEX = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_COUNT = 9;
    private static final int CRAFT_SLOT_END = 10;
    private static final int PLAYER_INV_SLOT_COUNT = 27;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INV_START = 10;
    private static final int PLAYER_INV_END = 46;
    public final Player player;
    int quickcraftStatus;
    int quickcraftType;
    Set<Slot> quickcraftSlots = new HashSet<Slot>();
    private final DataSlot rowsData = DataSlot.m_39401_();
    private final DataSlot itemSize = DataSlot.m_39401_();
    private final DataSlot maxStackSize = DataSlot.m_39401_();
    private static final int CRAFTING_ROWS = 3;
    private final DataSlot infinityMode = DataSlot.m_39401_();
    private int displayingPageIndex;
    private String displayingPageId;
    private PageType displayingPageType;
    private int baseRows = 1;
    private int visibleRows = 1;
    private boolean craftingVisible = false;
    public SortType sortType;
    public String searching;
    private boolean reverseSort;

    public static EndlessInventoryMenu createClient(int id, Inventory playerInv) {
        PageData layout = CachedConfig.resolveLayout(null, true);
        EndlessInventoryMenu ret = new EndlessInventoryMenu(id, playerInv, null);
        ret.init(layout);
        ret.switchPageWithId(layout.pageRegKey());
        ret.buildSlotLayout(playerInv);
        return ret;
    }

    public static MenuProvider provide(final int rows) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237119_();
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                return EndlessInventoryMenu.createServer(id, inventory, player, rows);
            }
        };
    }

    @Nullable
    public static AbstractContainerMenu createServer(int i, Inventory inventory, Player player, int rows) {
        EndlessInventory endlessInventory = ServerLevelEndInv.getEndInvForPlayer(player).orElse(null);
        if (endlessInventory == null) {
            return null;
        }
        EndlessInventoryMenu ret = new EndlessInventoryMenu(i, inventory, endlessInventory);
        ret.init(new PageData(rows, 9));
        ret.buildSlotLayout(inventory);
        return ret;
    }

    public static EndlessInventoryMenu createWithTemp(int i, Inventory inventory, Player player) {
        EndlessInventory endInv = ServerLevelEndInv.TEMP_ENDINV_REG.get((ServerPlayer)player);
        if (endInv == null) {
            throw new IllegalStateException("Try to create tmp menu without tmp EndInv.");
        }
        EndlessInventoryMenu ret = new EndlessInventoryMenu(i, inventory, endInv);
        ret.init(PageData.DEFAULT);
        ret.buildSlotLayout(inventory);
        return ret;
    }

    public EndlessInventoryMenu(int id, Inventory playerInv, @Nullable EndlessInventory endlessInventory) {
        super(ModRegistries.Menus.getEndInvMenuType(), id);
        this.player = playerInv.f_35978_;
        this.sourceInventory = endlessInventory != null ? endlessInventory : CachedSrcInv.INSTANCE;
        PageType initialType = PageTypeRegistry.byId("all_items");
        if (initialType == null && PageTypeRegistry.size() > 0) {
            initialType = PageTypeRegistry.byIndex(0);
        }
        if (initialType == null) {
            initialType = PageType.ALL_ITEMS;
        }
        this.displayingPageType = initialType;
        this.displayingPageId = initialType.registerName;
        this.displayingPageIndex = Math.max(0, PageTypeRegistry.getIndexOf(this.displayingPageId));
        this.itemSize.m_6422_(endlessInventory != null ? endlessInventory.getItemSize() : 0);
        this.maxStackSize.m_6422_(endlessInventory != null ? endlessInventory.getMaxItemStackSize() : Integer.MAX_VALUE);
        this.infinityMode.m_6422_(endlessInventory != null && endlessInventory.isInfinityMode() ? 1 : 0);
        this.m_38895_(this.rowsData);
        this.m_38895_(this.itemSize);
        this.m_38895_(this.maxStackSize);
        this.m_38895_(this.infinityMode);
    }

    public void applyPageData(PageData pageData) {
        this.init(pageData);
    }

    private void init(PageData pageData) {
        int rows;
        this.baseRows = rows = Math.max(1, pageData.rows());
        this.visibleRows = this.craftingVisible ? Math.max(1, rows - 3) : rows;
        this.rowsData.m_6422_(this.visibleRows);
        this.sortType = pageData.sortType();
        this.searching = pageData.search();
        this.reverseSort = pageData.reverseSort();
    }

    private void buildSlotLayout(Inventory playerInventory) {
        if (!this.f_38839_.isEmpty()) {
            return;
        }
        int craftX = 30;
        int craftRowsForPosition = Math.max(1, this.baseRows - 3);
        int craftY = 18 * craftRowsForPosition + 18 + 5;
        int resultX = craftX + 54 + 40;
        int resultY = craftY + 18;
        this.m_38897_((Slot)new CraftingResultSlot(this.player, this.craftMatrix, this.craftResult, 0, resultX, resultY));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.m_38897_(new CraftingGridSlot(this.craftMatrix, col + row * 3, craftX + col * 18, craftY + row * 18));
            }
        }
        int invY = 18 * this.baseRows + 31;
        this.addStandardInventorySlots(playerInventory, 8, invY);
    }

    public List<Slot> getCraftingSlots() {
        return this.f_38839_.subList(1, 10);
    }

    public List<Slot> getPlayerInvSlots() {
        return this.f_38839_.subList(10, 46);
    }

    @TestOnly
    public boolean validateSlotStatus() throws IllegalStateException {
        for (Slot slot : this.getCraftingSlots()) {
            if (slot instanceof CraftingGridSlot) continue;
            throw new IllegalStateException("getCraftingSlots do not correspond menu's crafter slots.");
        }
        for (Slot slot : this.getPlayerInvSlots()) {
            if (slot.f_40218_ instanceof Inventory) continue;
            throw new IllegalStateException("getPlayerInvSlots contains slots whose container is not inventory");
        }
        if (!(this.f_38839_.get(0) instanceof CraftingGridSlot)) {
            throw new IllegalStateException("the first slot is not Crafter's result slot, check ADD SLOT process");
        }
        return true;
    }

    public boolean isCrafterEnabled() {
        return true;
    }

    public void setCraftingVisible(boolean visible) {
        if (this.craftingVisible == visible) {
            return;
        }
        this.craftingVisible = visible;
        this.visibleRows = visible ? Math.max(1, this.baseRows - 3) : this.baseRows;
        this.rowsData.m_6422_(this.visibleRows);
        if (!visible) {
            this.returnCraftingToPlayer();
        }
    }

    private void returnCraftingToPlayer() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        Inventory inventory = this.player.m_150109_();
        for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
            ItemStack stack = this.craftMatrix.m_8016_(i);
            if (stack.m_41619_()) continue;
            inventory.m_150079_(stack);
        }
        ItemStack result = this.craftResult.m_8016_(0);
        if (!result.m_41619_()) {
            inventory.m_150079_(result);
        }
        this.craftMatrix.m_6596_();
        this.craftResult.m_6596_();
    }

    public void m_6199_(Container container) {
        if (container == this.craftMatrix) {
            this.updateCraftingResult();
        }
        super.m_6199_(container);
    }

    public boolean isCraftingVisible() {
        return this.craftingVisible;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public int getBaseRows() {
        return this.baseRows;
    }

    private void addStandardInventorySlots(Inventory playerInventory, int x, int y) {
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInventory, j1 + l * 9 + 9, x + j1 * 18, y + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInventory, i1, x + i1 * 18, y + 58));
        }
    }

    @Override
    public void switchPageWithIndex(int index) {
        if (index < 0 || index >= PageTypeRegistry.size()) {
            return;
        }
        PageType type = PageTypeRegistry.byIndex(index);
        if (type != null) {
            this.applySelectedPage(type);
        }
    }

    private void applySelectedPage(PageType type) {
        this.displayingPageType = type;
        this.displayingPageId = type.registerName;
        this.displayingPageIndex = Math.max(0, PageTypeRegistry.getIndexOf(this.displayingPageId));
    }

    @Override
    public int getItemSize() {
        return this.itemSize.m_6501_();
    }

    public void setItemSize(int i) {
        this.itemSize.m_6422_(i);
    }

    @Override
    public boolean enableInfinity() {
        return this.infinityMode.m_6501_() > 0;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStackSize.m_6501_();
    }

    @Override
    public AbstractContainerMenu getMenu() {
        return this;
    }

    @Override
    public SourceInventory getSourceInventory() {
        return this.sourceInventory;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int rows() {
        return this.visibleRows;
    }

    @Override
    public int columns() {
        return 9;
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        try {
            if (clickType == ClickType.QUICK_CRAFT) {
                MenuClickHandler.handleQuickCraft(this, slotId, button, player);
            } else if (this.quickcraftStatus != 0) {
                this.m_38951_();
            }
            switch (clickType) {
                case PICKUP: {
                    MenuClickHandler.handlePickup(this, slotId, button, player);
                    break;
                }
                case QUICK_MOVE: {
                    MenuClickHandler.handleQuickMove(this, slotId, button, player);
                    break;
                }
                case SWAP: {
                    MenuClickHandler.handleSwap(this, slotId, button, player);
                    break;
                }
                case THROW: {
                    MenuClickHandler.handleThrow(this, slotId, button, player);
                    break;
                }
                case CLONE: {
                    MenuClickHandler.handleClone(this, slotId, button, player);
                    break;
                }
                case PICKUP_ALL: {
                    this.handlePickupAll(slotId, button, player);
                    break;
                }
                default: {
                    return;
                }
            }
            SourceInventory sourceInventory = this.getSourceInventory();
            if (sourceInventory instanceof EndlessInventory) {
                EndlessInventory endinv = (EndlessInventory)sourceInventory;
                this.setItemSize(endinv.getItemSize());
            }
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)exception, (String)"Container click");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Click info");
            crashreportcategory.m_128159_("Menu Type", (Object)"endless_inventory");
            crashreportcategory.m_128165_("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportcategory.m_128159_("Slot Count", (Object)this.f_38839_.size());
            crashreportcategory.m_128159_("Slot", (Object)slotId);
            crashreportcategory.m_128159_("Button", (Object)button);
            crashreportcategory.m_128159_("Type", (Object)clickType);
            throw new ReportedException(crashreport);
        }
    }

    boolean m_246200_(Player player, ClickAction action, Slot slot, ItemStack clickedItem, ItemStack carriedItem) {
        if (ModInfo.platformContext.onItemStackedOn(clickedItem, carriedItem, slot, action, player, this.m_150446_())) {
            return true;
        }
        FeatureFlagSet featureflagset = player.m_9236_().m_246046_();
        return carriedItem.m_246617_(featureflagset) && carriedItem.m_150926_(slot, action, player) || clickedItem.m_246617_(featureflagset) && clickedItem.m_150932_(carriedItem, slot, action, player, this.m_150446_());
    }

    private SlotAccess m_150446_() {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return EndlessInventoryMenu.this.m_142621_();
            }

            public boolean m_142104_(ItemStack itemStack) {
                EndlessInventoryMenu.this.m_142503_(itemStack);
                return true;
            }
        };
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack slotStack = slot.m_7993_();
        if (slotStack.m_41720_() == ModRegistries.Items.getTestEndInv()) {
            return ItemStack.f_41583_;
        }
        ItemStack original = slotStack.m_41777_();
        boolean handled = index == 0 ? this.handleQuickMoveResult(slot, slotStack, original) : (this.isCrafterSlot(index) ? this.handleQuickMoveFromCrafterSlot(slot, slotStack) : (this.isPlayerInventorySlot(index) ? this.handleQuickMoveFromPlayerInventory(slotStack) : this.m_38903_(slotStack, 10, 46, false)));
        if (!handled) {
            return ItemStack.f_41583_;
        }
        if (slotStack.m_41619_()) {
            slot.m_269060_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (slotStack.m_41613_() == original.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, slotStack);
        if (index == 0) {
            player.m_36176_(slotStack, false);
        }
        return original;
    }

    private boolean isPlayerInventorySlot(int index) {
        return index >= 10 && index < 46;
    }

    private boolean isCrafterSlot(int index) {
        return index >= 1 && index < 10;
    }

    private boolean handleQuickMoveFromCrafterSlot(Slot slot, ItemStack stack) {
        boolean moved = this.m_38903_(stack, 10, 46, false);
        if (moved) {
            this.craftMatrix.m_6596_();
            this.updateCraftingResult();
        }
        return moved;
    }

    private boolean moveStackIntoCrafter(ItemStack stack) {
        int before = stack.m_41613_();
        boolean moved = this.m_38903_(stack, 1, 10, false);
        if (!moved || stack.m_41613_() == before) {
            return false;
        }
        this.craftMatrix.m_6596_();
        this.updateCraftingResult();
        return true;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        if (slot.f_40218_ == this.craftResult) {
            return false;
        }
        return super.m_5882_(stack, slot);
    }

    private ItemStack quickMoveIntoPage(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack remain = this.sourceInventory.addItem(stack);
        this.sourceInventory.setChanged();
        return remain;
    }

    private void handlePickupAll(int slotId, int button, Player player) {
        if (slotId < 0) {
            return;
        }
        Slot clickedSlot = (Slot)this.f_38839_.get(slotId);
        ItemStack carried = this.m_142621_();
        if (carried.m_41619_()) {
            return;
        }
        if (!clickedSlot.m_6657_() || !clickedSlot.m_8010_(player)) {
            int startIndex = button == 0 ? 0 : this.f_38839_.size() - 1;
            int step = button == 0 ? 1 : -1;
            for (int pass = 0; pass < 2; ++pass) {
                for (int index = startIndex; index >= 0 && index < this.f_38839_.size() && carried.m_41613_() < carried.m_41741_(); index += step) {
                    Slot scanningSlot = (Slot)this.f_38839_.get(index);
                    if (!AbstractContainerMenu.m_38899_((Slot)scanningSlot, (ItemStack)carried, (boolean)true) || !scanningSlot.m_8010_(player) || !this.m_5882_(carried, scanningSlot)) continue;
                    ItemStack scanningItem = scanningSlot.m_7993_();
                    if (pass == 0 && scanningItem.m_41613_() == scanningItem.m_41741_()) continue;
                    ItemStack taken = scanningSlot.m_150647_(scanningItem.m_41613_(), carried.m_41741_() - carried.m_41613_(), player);
                    carried.m_41769_(taken.m_41613_());
                }
                if (carried.m_41613_() >= carried.m_41741_()) continue;
                ItemStack extracted = this.tryExtractFromPage(carried, carried.m_41741_() - carried.m_41613_());
                carried.m_41769_(extracted.m_41613_());
                carried.m_41764_(Math.min(carried.m_41613_(), carried.m_41741_()));
            }
        }
    }

    public ItemStack tryExtractFromPage(ItemStack template, int count) {
        if (count <= 0 || template.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack request = template.m_41777_();
        return this.sourceInventory.takeItem(request, count);
    }

    @Override
    public ItemStack quickMoveFromPage(ItemStack stack) {
        boolean movedToMain;
        boolean crafterAccepted;
        if (stack.m_41619_()) {
            return stack;
        }
        boolean bl = crafterAccepted = this.craftingVisible && this.moveStackIntoCrafter(stack);
        if (!stack.m_41619_() && !(movedToMain = this.m_38903_(stack, 10, 37, false))) {
            this.m_38903_(stack, 37, 46, false);
        }
        return crafterAccepted && stack.m_41619_() ? ItemStack.f_41583_ : stack;
    }

    @Override
    public SortType sortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public boolean isSortReversed() {
        return this.reverseSort;
    }

    @Override
    public void switchSortReversed() {
        this.reverseSort = !this.reverseSort;
    }

    @Override
    public void setSortReversed(boolean reversed) {
        this.reverseSort = reversed;
    }

    @Override
    public String searching() {
        return this.searching;
    }

    @Override
    public void setSearching(String searching) {
        this.searching = searching;
    }

    @Override
    public PageData getPageData() {
        return new PageData(this.getDisplayingPageId(), this.baseRows, this.columns(), this.sortType(), this.isSortReversed(), this.searching());
    }

    @Override
    public void sendEndInvData() {
        SourceInventory sourceInventory = this.sourceInventory;
        if (sourceInventory instanceof EndlessInventory) {
            EndlessInventory endlessInventory = (EndlessInventory)sourceInventory;
            this.itemSize.m_6422_(endlessInventory.getItemSize());
            this.maxStackSize.m_6422_(endlessInventory.getMaxItemStackSize());
            this.infinityMode.m_6422_(endlessInventory.isInfinityMode() ? 1 : 0);
        }
    }

    @Override
    public String getDisplayingPageId() {
        return this.displayingPageId;
    }

    @Override
    public void switchPageWithId(String id) {
        PageType type = PageTypeRegistry.byId(id);
        if (type != null) {
            this.applySelectedPage(type);
        }
    }

    @Override
    public PageType getDisplayingPageType() {
        return this.displayingPageType;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.returnCraftingToPlayer();
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private int insertStackIntoPage(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        ItemStack attempt = stack.m_41777_();
        ItemStack remainder = this.quickMoveIntoPage(attempt);
        int inserted = stack.m_41613_() - remainder.m_41613_();
        if (inserted > 0) {
            stack.m_41774_(inserted);
        }
        return inserted;
    }

    private boolean handleQuickMoveResult(Slot slot, ItemStack stack, ItemStack original) {
        boolean moved;
        boolean bl = moved = this.m_38903_(stack, 10, 46, true) || this.m_38903_(stack, 10, 46, false);
        if (!moved) {
            this.insertStackIntoPage(stack);
        }
        slot.m_40234_(stack, original);
        this.updateCraftingResult();
        return true;
    }

    private boolean handleQuickMoveFromPlayerInventory(ItemStack stack) {
        if (this.craftingVisible) {
            return this.moveStackIntoCrafter(stack);
        }
        return this.insertStackIntoPage(stack) > 0;
    }

    private void updateCraftingResult() {
        ItemStack assembled;
        CraftingRecipe recipe;
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Level level = serverPlayer.m_9236_();
        ItemStack resultStack = ItemStack.f_41583_;
        Optional optional = serverPlayer.f_8924_.m_129894_().m_44015_(RecipeType.f_44107_, (Container)this.craftMatrix, level);
        if (optional.isPresent() && this.craftResult.m_40135_(level, serverPlayer, (Recipe)(recipe = (CraftingRecipe)optional.get())) && (assembled = recipe.m_5874_((Container)this.craftMatrix, level.m_9598_())).m_246617_(level.m_246046_())) {
            resultStack = assembled;
        }
        this.craftResult.m_6836_(0, resultStack);
        this.m_150404_(0, resultStack);
        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, resultStack));
    }

    private class CraftingResultSlot
    extends ResultSlot {
        CraftingResultSlot(Player player, CraftingContainer matrix, ResultContainer result, int slotIndex, int x, int y) {
            super(player, matrix, (Container)result, slotIndex, x, y);
        }

        public boolean m_6659_() {
            return EndlessInventoryMenu.this.craftingVisible;
        }
    }

    private class CraftingGridSlot
    extends Slot {
        CraftingGridSlot(CraftingContainer matrix, int slot, int x, int y) {
            super((Container)matrix, slot, x, y);
        }

        public boolean m_6659_() {
            return EndlessInventoryMenu.this.craftingVisible;
        }
    }

    public static interface ClientPageBinding {
        public String pageId();

        public PageType pageType();

        public void onPageSelected();

        public void scrollTo(float var1);

        public ItemStack quickMoveIntoPage(ItemStack var1);

        public void markPageChanged();

        public ItemStack extractItemFromPage(ItemStack var1, int var2);

        public void refreshAfterMenuInteraction(SourceInventory var1);
    }
}

