/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.integrates.clothconfig;

import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.option.IClientConfig;
import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.menu.page.PageTypeRegistry;
import com.kwwsyk.endinv.forge.client.config.ClientConfig;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

final class ClothConfigScreenBuilder {
    private ClothConfigScreenBuilder() {
    }

    static Screen create(Screen parent) {
        IClientConfig config = ClientModInfo.getClientConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.m_237115_((String)"title.endinv.settings"));
        builder.setSavingRunnable(config::save);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((Component)Component.m_237115_((String)"endinv.setting.category.general"));
        ClothConfigScreenBuilder.addGeneralEntries(entryBuilder, general, config);
        ClothConfigScreenBuilder.addPageEntries(entryBuilder, builder, config);
        return builder.build();
    }

    private static void addGeneralEntries(ConfigEntryBuilder entryBuilder, ConfigCategory category, IClientConfig config) {
        category.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"endinv.setting.attaching"), config.attaching().get().booleanValue()).setDefaultValue((Object)((Boolean)ClientConfig.CONFIG.ATTACHING.getDefault()))).setSaveConsumer(value -> config.attaching().set((Boolean)value)).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"endinv.setting.rows"), config.rows().get().intValue()).setDefaultValue(((Number)ClientConfig.CONFIG.ROWS.getDefault()).intValue()).setMin(0).setTooltip(new Component[]{Component.m_237115_((String)"config.endinv.comment.row1")}).setSaveConsumer(value -> config.rows().set((Integer)value)).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"endinv.setting.columns"), config.columns().get().intValue()).setDefaultValue(((Number)ClientConfig.CONFIG.COLUMNS.getDefault()).intValue()).setMin(0).setSaveConsumer(value -> config.columns().set((Integer)value)).build());
        category.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"endinv.setting.auto_suit"), config.autoSuitColumn().get().booleanValue()).setDefaultValue((Object)((Boolean)ClientConfig.CONFIG.AUTO_SUIT_COLUMN.getDefault()))).setSaveConsumer(value -> config.autoSuitColumn().set((Boolean)value)).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)Component.m_237115_((String)"endinv.setting.texture"), TextureMode.class, (Enum)config.textureMode().get()).setDefaultValue((Enum)((TextureMode)((Object)ClientConfig.CONFIG.TEXTURE.getDefault()))).setEnumNameProvider(mode -> Component.m_237115_((String)("endinv.setting.entry." + mode.name()))).setSaveConsumer(value -> config.textureMode().set((TextureMode)((Object)value))).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"endinv.setting.max_page_bar"), config.maxPageBarCount().get().intValue()).setDefaultValue(((Number)ClientConfig.CONFIG.MAX_PAGE_BARS.getDefault()).intValue()).setMin(1).setSaveConsumer(value -> config.maxPageBarCount().set((Integer)value)).build());
        category.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"endinv.setting.screen_debug"), config.screenDebugging().get().booleanValue()).setDefaultValue((Object)((Boolean)ClientConfig.CONFIG.ENABLE_DEBUG.getDefault()))).setSaveConsumer(value -> config.screenDebugging().set((Boolean)value)).build());
    }

    private static void addPageEntries(ConfigEntryBuilder entryBuilder, ConfigBuilder builder, IClientConfig config) {
        List<String> pageIds = PageTypeRegistry.getIdList();
        if (pageIds.isEmpty()) {
            return;
        }
        ConfigCategory pages = builder.getOrCreateCategory((Component)Component.m_237115_((String)"endinv.setting.category.pages"));
        for (String id : pageIds) {
            boolean hidden = config.isPageHidden(id);
            boolean defaultHidden = Optional.ofNullable(ClientConfig.CONFIG.PAGE2HIDING.get(id)).map(value -> (Boolean)value.getDefault()).orElse(false);
            pages.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237110_((String)"endinv.setting.hide_page", (Object[])new Object[]{id}), hidden).setDefaultValue(defaultHidden).setSaveConsumer(value -> config.setPageHiding(id, (boolean)value)).build());
        }
    }
}

