/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.network.payloads;

import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.forge.integrates.jei.experimental.AEIRecipeTransferHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fml.ModList;

public record JeiAttachedTransferPayload(AEIRecipeTransferHandler.TransferContext context) implements ModPacketPayload
{
    public static void encode(JeiAttachedTransferPayload payload, FriendlyByteBuf buffer) {
        buffer.m_130130_(payload.context.containerId());
        buffer.m_130085_(payload.context.recipeId());
        buffer.writeBoolean(payload.context.maxTransfer());
        buffer.writeBoolean(payload.context.requireCompleteSets());
        buffer.m_130130_(payload.context.craftingSlotIndexes().size());
        payload.context.craftingSlotIndexes().forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130130_(arg_0));
        buffer.m_130130_(payload.context.inventorySlotIndexes().size());
        payload.context.inventorySlotIndexes().forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130130_(arg_0));
    }

    public static JeiAttachedTransferPayload decode(FriendlyByteBuf buffer) {
        int containerId = buffer.m_130242_();
        ResourceLocation recipeId = buffer.m_130281_();
        boolean maxTransfer = buffer.readBoolean();
        boolean requireCompleteSets = buffer.readBoolean();
        int craftingSize = buffer.m_130242_();
        ArrayList<Integer> craftingIndexes = new ArrayList<Integer>(craftingSize);
        for (int i = 0; i < craftingSize; ++i) {
            craftingIndexes.add(buffer.m_130242_());
        }
        int inventorySize = buffer.m_130242_();
        ArrayList<Integer> inventoryIndexes = new ArrayList<Integer>(inventorySize);
        for (int i = 0; i < inventorySize; ++i) {
            inventoryIndexes.add(buffer.m_130242_());
        }
        AEIRecipeTransferHandler.TransferContext context = new AEIRecipeTransferHandler.TransferContext(containerId, recipeId, maxTransfer, requireCompleteSets, craftingIndexes, inventoryIndexes);
        return new JeiAttachedTransferPayload(context);
    }

    @Override
    public String id() {
        return "jei_attached_transfer";
    }

    @Override
    public void handle(ModPacketContext modContext) {
        Player player = modContext.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!ModList.get().isLoaded("jei")) {
            return;
        }
        AbstractContainerMenu container = player2.f_36096_;
        if (container == null || container.f_38840_ != this.context.containerId()) {
            return;
        }
        Optional optional = player2.m_284548_().m_7465_().m_44043_(this.context.recipeId());
        if (optional.isEmpty()) {
            return;
        }
        Recipe<?> recipe = JeiAttachedTransferPayload.resolve(optional.get());
        if (recipe == null) {
            return;
        }
        PageMetaDataManager manager = AEIRecipeTransferHandler.getServerManager(player2);
        List<Slot> craftingSlots = JeiAttachedTransferPayload.collectSlots(container, this.context.craftingSlotIndexes());
        List<Slot> inventorySlots = JeiAttachedTransferPayload.collectSlots(container, this.context.inventorySlotIndexes());
        if (craftingSlots.size() != this.context.craftingSlotIndexes().size() || inventorySlots.size() != this.context.inventorySlotIndexes().size()) {
            return;
        }
        AEIRecipeTransferHandler.performServerTransfer(container, recipe, craftingSlots, inventorySlots, player2, manager, this.context.maxTransfer(), this.context.requireCompleteSets());
    }

    private static Recipe<?> resolve(Object recipeObj) {
        if (recipeObj instanceof Recipe) {
            Recipe recipe = (Recipe)recipeObj;
            return recipe;
        }
        try {
            Object value = recipeObj.getClass().getMethod("value", new Class[0]).invoke(recipeObj, new Object[0]);
            if (value instanceof Recipe) {
                Recipe recipe = (Recipe)value;
                return recipe;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static List<Slot> collectSlots(AbstractContainerMenu container, List<Integer> indexes) {
        ArrayList<Slot> slots = new ArrayList<Slot>(indexes.size());
        for (int index : indexes) {
            if (index < 0 || index >= container.f_38839_.size()) continue;
            slots.add(container.m_38853_(index));
        }
        return slots;
    }
}

