/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.stamina999;

import com.yourname.stamina999.StaminaCommand;
import com.yourname.stamina999.StaminaListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Biome;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class Stamina999
extends JavaPlugin {
    private final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();
    public int defaultStamina;
    public int maxStaminaIncreaseAmount;
    public int staminaRegenDelay;
    public int staminaRegenAmount;
    public int staminaFoodRegen;
    public int miningStaminaPerBlock;
    public double walkingDrainRate;
    public double sprintingDrainRate;
    public double swimmingDrainRate;
    public double jumpingStamina;
    public double attackingStamina;
    public double drawingBowStamina;
    public int wellRestedDurationSeconds;
    public double wellRestedRegenMultiplier;
    public boolean enableStandingStillRegen;
    public boolean disableRegenSprinting;
    public boolean disableRegenSwimming;
    public boolean disableRegenJumping;
    public double swimmingThresholdPercentage;
    private Map<Biome, Map<String, Double>> biomeStaminaModifiers;
    private double lowStaminaThresholdPercentage;
    public boolean applyMiningFatigue;
    public boolean reduceAttackDamage;
    public boolean applyNausea;
    private String displayType;
    private String actionBarMessage;
    private String tooExhaustedToSprint;
    private String tooExhaustedToSwim;
    private String tooExhaustedToMine;
    private String tooExhaustedToJump;
    private String tooExhaustedToAttack;
    private String tooExhaustedToDrawBow;
    private String staminaCapacityIncreased;
    private String feelWellRested;
    private String commandUsage;
    private String commandUnknownSubcommand;
    private String commandNoPermission;
    private String commandPlayerNotFound;
    private String commandInvalidAmount;
    private String commandUsageCheck;
    private String commandUsageSet;
    private String commandUsageMax;
    private String commandConfigReloaded;
    private String commandStaminaSet;
    private String commandMaxStaminaSet;
    private String commandPlayerStaminaInfo;
    private String commandPlayerStaminaError;
    private String commandNoPermissionCheckOther;
    private String commandNoPermissionSet;
    private String commandNoPermissionSetMax;
    private String commandUsageCheckPlayer;
    private String defaultPrefix;
    public boolean debugEnabled;

    public void onEnable() {
        this.getLogger().info("Attempting to load or create config.yml...");
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        File configFile = new File(this.getDataFolder(), "config.yml");
        boolean configExisted = configFile.exists();
        this.saveDefaultConfig();
        if (!configExisted) {
            this.getLogger().info("config.yml not found, default config copied from JAR.");
        } else {
            this.getLogger().info("config.yml found, loading existing configuration.");
        }
        this.getLogger().info("Attempting to load or create messages.yml...");
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        boolean messagesExisted = messagesFile.exists();
        this.saveResource("messages.yml", false);
        if (!messagesExisted) {
            this.getLogger().info("messages.yml not found, default messages copied from JAR.");
        } else {
            this.getLogger().info("messages.yml found, loading existing messages configuration.");
        }
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)new StaminaListener(this), (Plugin)this);
        this.getCommand("stamina").setExecutor((CommandExecutor)new StaminaCommand(this));
        new BukkitRunnable(){

            public void run() {
                Stamina999.this.updateAllPlayers();
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new StaminaPlaceholder(this).register();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.addPlayer(player);
        }
    }

    public void onDisable() {
        for (BossBar bossBar : this.bossBars.values()) {
            bossBar.removeAll();
        }
        this.bossBars.clear();
    }

    public void reloadConfig() {
        this.getLogger().info("Reloading configuration from config.yml...");
        super.reloadConfig();
        this.loadConfig();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.removeBossBar(player);
            this.addBossBar(player);
        }
    }

    private void loadConfig() {
        this.getLogger().info("Loading configuration from config.yml...");
        this.defaultStamina = this.getConfig().getInt("default-stamina", 20);
        this.maxStaminaIncreaseAmount = this.getConfig().getInt("max-stamina-increase-amount", 5);
        this.staminaRegenDelay = this.getConfig().getInt("stamina-regen-delay", 2) * 20;
        this.staminaRegenAmount = this.getConfig().getInt("stamina-regen-amount", 2);
        this.staminaFoodRegen = this.getConfig().getInt("stamina-food-regen", 20);
        this.miningStaminaPerBlock = this.getConfig().getInt("mining-stamina-per-block", 1);
        this.walkingDrainRate = this.calculateDrainRate("stamina-consumption.walking", 1.0, 60.0);
        this.sprintingDrainRate = this.calculateDrainRate("stamina-consumption.sprinting", 3.0, 20.0);
        this.swimmingDrainRate = this.calculateDrainRate("stamina-consumption.swimming", 3.0, 1.0);
        this.jumpingStamina = this.getConfig().getDouble("stamina-consumption.jumping", 1.0);
        this.attackingStamina = this.getConfig().getDouble("stamina-consumption.attacking", 0.5);
        this.drawingBowStamina = this.getConfig().getDouble("stamina-consumption.drawing-bow", 2.0);
        this.debugLog("Configured walkingDrainRate: " + this.walkingDrainRate);
        this.biomeStaminaModifiers = new HashMap<Biome, Map<String, Double>>();
        ConfigurationSection biomeSection = this.getConfig().getConfigurationSection("stamina-consumption-per-biome");
        if (biomeSection != null) {
            for (String biomeName : biomeSection.getKeys(false)) {
                try {
                    Biome biome = Biome.valueOf((String)biomeName.toUpperCase());
                    ConfigurationSection actionSection = biomeSection.getConfigurationSection(biomeName);
                    if (actionSection == null) continue;
                    HashMap<String, Double> modifiers = new HashMap<String, Double>();
                    for (String action : actionSection.getKeys(false)) {
                        double amount = actionSection.getDouble(action + ".amount");
                        double interval = actionSection.getDouble(action + ".interval-seconds");
                        modifiers.put(action.toLowerCase(), amount / interval);
                    }
                    this.biomeStaminaModifiers.put(biome, modifiers);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid biome name in config: " + biomeName);
                }
            }
        }
        this.wellRestedDurationSeconds = this.getConfig().getInt("well-rested-buff.duration-seconds", 300);
        this.wellRestedRegenMultiplier = this.getConfig().getDouble("well-rested-buff.regen-multiplier", 2.0);
        this.lowStaminaThresholdPercentage = this.getConfig().getDouble("low-stamina-effects.threshold-percentage", 25.0) / 100.0;
        this.applyMiningFatigue = this.getConfig().getBoolean("low-stamina-effects.apply-mining-fatigue", true);
        this.reduceAttackDamage = this.getConfig().getBoolean("low-stamina-effects.reduce-attack-damage", true);
        this.applyNausea = this.getConfig().getBoolean("low-stamina-effects.apply-nausea", false);
        this.displayType = this.getConfig().getString("display.display-type", "EXP_BAR").toUpperCase();
        this.actionBarMessage = this.getConfig().getString("display.action-bar-message", "&eStamina: &f%current%/%max%");
        this.loadMessages();
        this.enableStandingStillRegen = this.getConfig().getBoolean("stamina-regeneration.enable-standing-still-regen", true);
        this.disableRegenSprinting = this.getConfig().getBoolean("stamina-regeneration.disable-regen-while-sprinting", true);
        this.disableRegenSwimming = this.getConfig().getBoolean("stamina-regeneration.disable-regen-while-swimming", true);
        this.disableRegenJumping = this.getConfig().getBoolean("stamina-regeneration.disable-regen-while-jumping", true);
        this.swimmingThresholdPercentage = this.getConfig().getDouble("swimming.threshold-percentage", 25.0) / 100.0;
        this.debugEnabled = this.getConfig().getBoolean("debug.enabled", false);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.removeBossBar(player);
            this.addBossBar(player);
        }
    }

    private void loadMessages() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (messagesFile.exists()) {
            YamlConfiguration yamlConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
            this.tooExhaustedToSprint = yamlConfig.getString("messages.too_exhausted_to_sprint", "&cYou're too exhausted to sprint!");
            this.tooExhaustedToSwim = yamlConfig.getString("messages.too_exhausted_to_swim", "&cYou're too exhausted to swim!");
            this.tooExhaustedToMine = yamlConfig.getString("messages.too_exhausted_to_mine", "&cYou are too exhausted to mine.");
            this.tooExhaustedToJump = yamlConfig.getString("messages.too_exhausted_to_jump", "&cYou are too exhausted to jump.");
            this.tooExhaustedToAttack = yamlConfig.getString("messages.too_exhausted_to_attack", "&cYou are too exhausted to attack.");
            this.tooExhaustedToDrawBow = yamlConfig.getString("messages.too_exhausted_to_draw_bow", "&cYou are too exhausted to draw your bow.");
            this.staminaCapacityIncreased = yamlConfig.getString("messages.stamina_capacity_increased", "&6Your stamina capacity increased to &e%max%&6!");
            this.feelWellRested = yamlConfig.getString("messages.feel_well_rested", "&aYou feel well rested.");
            this.commandUsage = yamlConfig.getString("messages.command_usage", "&cUsage: /stamina <check|reload|set|max>");
            this.commandUnknownSubcommand = yamlConfig.getString("messages.command_unknown_subcommand", "&cUnknown subcommand. Usage: /stamina <check|reload|set|max>");
            this.commandNoPermission = yamlConfig.getString("messages.command_no_permission", "&cYou don't have permission to %permission%.");
            this.commandPlayerNotFound = yamlConfig.getString("messages.command_player_not_found", "&cPlayer not found.");
            this.commandInvalidAmount = yamlConfig.getString("messages.command_invalid_amount", "&cInvalid amount.");
            this.commandUsageCheck = yamlConfig.getString("messages.command_usage_check", "&cUsage: /stamina check [player]");
            this.commandUsageSet = yamlConfig.getString("messages.command_usage_set", "&cUsage: /stamina set <player> <amount>");
            this.commandUsageMax = yamlConfig.getString("messages.command_usage_max", "&cUsage: /stamina max <player> <amount>");
            this.commandConfigReloaded = yamlConfig.getString("messages.command_config_reloaded", "&aStamina999 config reloaded.");
            this.commandStaminaSet = yamlConfig.getString("messages.command_stamina_set", "&aSet %player%'s stamina to %amount%");
            this.commandMaxStaminaSet = yamlConfig.getString("messages.command_max_stamina_set", "&aSet %player%'s max stamina to %amount%");
            this.commandPlayerStaminaInfo = yamlConfig.getString("messages.command_player_stamina_info", "&a%player%'s Stamina: %current%/%max%");
            this.commandPlayerStaminaError = yamlConfig.getString("messages.command_player_stamina_error", "&cCould not retrieve stamina data for %player%");
            this.commandNoPermissionCheckOther = yamlConfig.getString("messages.command_no_permission_check_other", "&cYou don't have permission to check other players' stamina.");
            this.commandNoPermissionSet = yamlConfig.getString("messages.command_no_permission_set", "&cYou don't have permission to set stamina.");
            this.commandNoPermissionSetMax = yamlConfig.getString("messages.command_no_permission_set_max", "&cYou don't have permission to set max stamina.");
            this.commandUsageCheckPlayer = yamlConfig.getString("messages.command_usage_check_player", "&cUsage: /stamina check <player>");
            this.defaultPrefix = yamlConfig.getString("messages.default_prefix", "&7[&6Stamina999&7] &r");
        }
    }

    private double calculateDrainRate(String path, double defaultAmount, double defaultInterval) {
        double interval = this.getConfig().getDouble(path + ".interval-seconds", defaultInterval);
        if (interval <= 0.0) {
            interval = 1.0;
        }
        double amount = this.getConfig().getDouble(path + ".amount", defaultAmount);
        return amount / interval;
    }

    private void updateAllPlayers() {
        long currentTime = System.currentTimeMillis();
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean isMoving;
            PlayerData data = this.getPlayerData(player);
            if (data == null) continue;
            boolean bl = isMoving = currentTime - data.lastMoveTime < 250L;
            if (player.isSwimming() && data.currentStamina <= (double)data.maxStamina * this.swimmingThresholdPercentage && currentTime - data.lastExhaustedMessage > 10000L) {
                player.sendMessage(this.formatMessage(this.getTooExhaustedToSwim()));
                data.lastExhaustedMessage = currentTime;
            }
            boolean canRegenerate = true;
            if (this.enableStandingStillRegen && isMoving) {
                canRegenerate = false;
            }
            if (this.disableRegenSprinting && player.isSprinting()) {
                canRegenerate = false;
            }
            if (this.disableRegenSwimming && player.isSwimming()) {
                canRegenerate = false;
            }
            if (this.disableRegenJumping && this.isPlayerJumping(player)) {
                canRegenerate = false;
            }
            if (canRegenerate && this.shouldRegenStamina(currentTime, data)) {
                this.regenerateStamina(data);
            } else if (isMoving) {
                this.consumeStamina(player, data);
            }
            if (player.isSprinting() && this.isBelowQuarterStamina(data)) {
                player.setSprinting(false);
                if (currentTime - data.lastExhaustedMessage > 10000L) {
                    player.sendMessage(this.formatMessage(this.getTooExhaustedToSprint()));
                    data.lastExhaustedMessage = currentTime;
                }
            }
            this.updatePlayerEffects(player, data);
            this.updateDisplay(player, data, currentTime);
        }
    }

    private void consumeStamina(Player player, PlayerData data) {
        double drainRate;
        String action;
        Biome biome = player.getLocation().getBlock().getBiome();
        String string = player.isSprinting() ? "sprinting" : (action = player.isSwimming() ? "swimming" : "walking");
        if (this.biomeStaminaModifiers.containsKey(biome) && this.biomeStaminaModifiers.get(biome).containsKey(action)) {
            drainRate = this.biomeStaminaModifiers.get(biome).get(action);
        } else if (player.isSwimming()) {
            drainRate = this.swimmingDrainRate;
            if (data.currentStamina <= (double)data.maxStamina * this.swimmingThresholdPercentage) {
                drainRate *= 2.0;
            }
        } else {
            drainRate = player.isSprinting() ? this.sprintingDrainRate : this.walkingDrainRate;
        }
        double staminaBefore = data.currentStamina;
        data.currentStamina -= drainRate;
        if (player.isSwimming()) {
            this.debugLog("Player %s is swimming. Drain Rate: %.2f. Stamina before: %.2f, after: %.2f", player.getName(), drainRate, staminaBefore, data.currentStamina);
        }
        if (data.currentStamina <= 0.0) {
            data.currentStamina = 0.0;
            if (!data.hasExhausted) {
                this.increaseMaxStamina(player, data);
            }
        }
    }

    public void increaseMaxStamina(Player player, PlayerData data) {
        data.maxStamina += this.maxStaminaIncreaseAmount;
        data.hasExhausted = true;
        String message = this.staminaCapacityIncreased.replace("%max%", String.valueOf(data.maxStamina));
        player.sendMessage(this.formatMessage(message));
    }

    public void replenishStamina(PlayerData data) {
        data.currentStamina = Math.min(data.currentStamina + (double)this.staminaFoodRegen, (double)data.maxStamina);
        if (data.currentStamina >= (double)data.maxStamina) {
            data.currentStamina = data.maxStamina;
            data.hasExhausted = false;
        }
    }

    private boolean shouldRegenStamina(long currentTime, PlayerData data) {
        return currentTime - data.lastMoveTime > (long)this.staminaRegenDelay;
    }

    private void regenerateStamina(PlayerData data) {
        double finalRegenAmount = this.staminaRegenAmount;
        if (System.currentTimeMillis() < data.wellRestedEndTime) {
            finalRegenAmount *= this.wellRestedRegenMultiplier;
        }
        data.currentStamina = Math.min(data.currentStamina + finalRegenAmount, (double)data.maxStamina);
    }

    public void updatePlayerEffects(Player player, PlayerData data) {
        this.manageSlownessEffect(player, data);
        this.manageLowStaminaEffects(player, data);
    }

    /*
     * Exception decompiling
     */
    private void updateDisplay(Player player, PlayerData data, long currentTime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl37 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl37 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void manageSlownessEffect(Player player, PlayerData data) {
        boolean shouldHaveSlowness = data.currentStamina <= (double)data.maxStamina * this.lowStaminaThresholdPercentage;
        boolean hasSlowness = player.hasPotionEffect(PotionEffectType.SLOWNESS);
        if (shouldHaveSlowness && !hasSlowness) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 0, true, false));
        } else if (!shouldHaveSlowness && hasSlowness) {
            player.removePotionEffect(PotionEffectType.SLOWNESS);
        }
    }

    private void manageLowStaminaEffects(Player player, PlayerData data) {
        boolean isLow = this.isStaminaLow(data);
        this.handleEffect(player, PotionEffectType.MINING_FATIGUE, this.applyMiningFatigue && isLow, 0);
        this.handleEffect(player, PotionEffectType.NAUSEA, this.applyNausea && isLow, 0);
    }

    private void handleEffect(Player player, PotionEffectType effectType, boolean shouldHave, int amplifier) {
        boolean hasEffect = player.hasPotionEffect(effectType);
        PlayerData data = this.getPlayerData(player);
        if (data == null) {
            return;
        }
        if (shouldHave && !hasEffect) {
            player.addPotionEffect(new PotionEffect(effectType, Integer.MAX_VALUE, amplifier, true, false));
        } else if (!shouldHave && hasEffect) {
            player.removePotionEffect(effectType);
        }
    }

    public boolean isStaminaLow(PlayerData data) {
        return data.currentStamina <= (double)data.maxStamina * this.lowStaminaThresholdPercentage;
    }

    public boolean isBelowQuarterStamina(PlayerData data) {
        return data.currentStamina < (double)data.maxStamina / 4.0;
    }

    private boolean isPlayerJumping(Player player) {
        return !player.isOnGround() && !player.isFlying() && !player.isSneaking();
    }

    private void updateStaminaBar(Player player, PlayerData data) {
        if (data.maxStamina > 0) {
            float staminaPercent = (float)(data.currentStamina / (double)data.maxStamina);
            player.setExp(Math.max(0.0f, Math.min(staminaPercent, 1.0f)));
        }
        player.setLevel((int)data.currentStamina);
    }

    private void updateActionBar(Player player, PlayerData data) {
        String message = this.actionBarMessage.replace("%current%", String.valueOf((int)data.currentStamina)).replace("%max%", String.valueOf(data.maxStamina));
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
    }

    private void updateBossBar(Player player, PlayerData data) {
        BossBar bossBar = this.bossBars.get(player.getUniqueId());
        if (bossBar != null) {
            String title = ChatColor.translateAlternateColorCodes((char)'&', (String)this.actionBarMessage.replace("%current%", String.valueOf((int)data.currentStamina)).replace("%max%", String.valueOf(data.maxStamina)));
            double progress = Math.max(0.0, Math.min(1.0, data.currentStamina / (double)data.maxStamina));
            bossBar.setTitle(title);
            bossBar.setProgress(progress);
            this.debugLog("Updating BossBar for player: %s, Title: %s, Progress: %.2f", player.getName(), title, progress);
        } else {
            this.getLogger().warning("Attempted to update BossBar for player " + player.getName() + " but no BossBar was found in the map.");
        }
    }

    public PlayerData getPlayerData(Player player) {
        return this.playerDataMap.get(player.getUniqueId());
    }

    public void addPlayer(Player player) {
        this.playerDataMap.put(player.getUniqueId(), new PlayerData(this.defaultStamina));
        this.addBossBar(player);
    }

    public void removePlayer(Player player) {
        this.playerDataMap.remove(player.getUniqueId());
        this.removeBossBar(player);
    }

    private void addBossBar(Player player) {
        if ("BOSS_BAR".equals(this.displayType)) {
            this.debugLog("Attempting to add BossBar for player: %s, displayType: %s", player.getName(), this.displayType);
            BossBar bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            bossBar.addPlayer(player);
            this.bossBars.put(player.getUniqueId(), bossBar);
        } else {
            this.debugLog("Not adding BossBar for player: %s, displayType is not BOSS_BAR: %s", player.getName(), this.displayType);
        }
    }

    private void removeBossBar(Player player) {
        BossBar bossBar = this.bossBars.remove(player.getUniqueId());
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    public String getTooExhaustedToSprint() {
        return this.tooExhaustedToSprint;
    }

    public String getTooExhaustedToSwim() {
        return this.tooExhaustedToSwim;
    }

    public String getTooExhaustedToMine() {
        return this.tooExhaustedToMine;
    }

    public String getTooExhaustedToJump() {
        return this.tooExhaustedToJump;
    }

    public String getTooExhaustedToAttack() {
        return this.tooExhaustedToAttack;
    }

    public String getTooExhaustedToDrawBow() {
        return this.tooExhaustedToDrawBow;
    }

    public String getStaminaCapacityIncreased() {
        return this.staminaCapacityIncreased;
    }

    public String getFeelWellRested() {
        return this.feelWellRested;
    }

    public String getCommandUsage() {
        return this.commandUsage;
    }

    public String getCommandUnknownSubcommand() {
        return this.commandUnknownSubcommand;
    }

    public String getCommandNoPermission() {
        return this.commandNoPermission;
    }

    public String getCommandPlayerNotFound() {
        return this.commandPlayerNotFound;
    }

    public String getCommandInvalidAmount() {
        return this.commandInvalidAmount;
    }

    public String getCommandUsageCheck() {
        return this.commandUsageCheck;
    }

    public String getCommandUsageSet() {
        return this.commandUsageSet;
    }

    public String getCommandUsageMax() {
        return this.commandUsageMax;
    }

    public String getCommandConfigReloaded() {
        return this.commandConfigReloaded;
    }

    public String getCommandStaminaSet() {
        return this.commandStaminaSet;
    }

    public String getCommandMaxStaminaSet() {
        return this.commandMaxStaminaSet;
    }

    public String getCommandPlayerStaminaInfo() {
        return this.commandPlayerStaminaInfo;
    }

    public String getCommandPlayerStaminaError() {
        return this.commandPlayerStaminaError;
    }

    public String getCommandNoPermissionCheckOther() {
        return this.commandNoPermissionCheckOther;
    }

    public String getCommandNoPermissionSet() {
        return this.commandNoPermissionSet;
    }

    public String getCommandNoPermissionSetMax() {
        return this.commandNoPermissionSetMax;
    }

    public String getCommandUsageCheckPlayer() {
        return this.commandUsageCheckPlayer;
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public String formatMessage(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void debugLog(String message) {
        if (this.debugEnabled) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    public void debugLog(String message, Object ... args) {
        if (this.debugEnabled) {
            this.getLogger().info("[DEBUG] " + String.format(message, args));
        }
    }

    public static class PlayerData {
        public int maxStamina;
        public double currentStamina;
        public long lastMoveTime = 0L;
        public boolean hasExhausted = false;
        public long wellRestedEndTime = 0L;
        public long lastExhaustedMessage = 0L;
        public long lastNauseaMessage = 0L;
        public long lastMiningFatigueMessage = 0L;
        public long lastLowStaminaMessage = 0L;
        public boolean wasSwimming = false;

        public PlayerData(int defaultStamina) {
            this.maxStamina = defaultStamina;
            this.currentStamina = defaultStamina;
            this.wasSwimming = false;
        }
    }

    public class StaminaPlaceholder
    extends PlaceholderExpansion {
        private final Stamina999 plugin;

        public StaminaPlaceholder(Stamina999 plugin) {
            this.plugin = plugin;
        }

        @NotNull
        public String getIdentifier() {
            return "stamina";
        }

        @NotNull
        public String getAuthor() {
            return "YourName";
        }

        @NotNull
        public String getVersion() {
            return "1.0.5";
        }

        public boolean persist() {
            return true;
        }

        public String onPlaceholderRequest(Player player, @NotNull String params) {
            if (player == null) {
                return "";
            }
            PlayerData data = this.plugin.getPlayerData(player);
            if (data == null) {
                return "";
            }
            if (params.equals("current")) {
                return String.valueOf((int)data.currentStamina);
            }
            if (params.equals("max")) {
                return String.valueOf(data.maxStamina);
            }
            return null;
        }
    }
}

