/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.stamina999;

import com.yourname.stamina999.Stamina999;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class StaminaCommand
implements CommandExecutor {
    private final Stamina999 plugin;

    public StaminaCommand(Stamina999 plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandUsage()));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "check": {
                this.handleCheck(sender, args);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "set": {
                this.handleSet(sender, args);
                break;
            }
            case "max": {
                this.handleMax(sender, args);
                break;
            }
            default: {
                sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandUnknownSubcommand()));
            }
        }
        return true;
    }

    private void handleCheck(CommandSender sender, String[] args) {
        Stamina999.PlayerData data;
        if (args.length > 2) {
            sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandUsageCheck()));
            return;
        }
        Player target = null;
        if (args.length == 2) {
            if (!sender.hasPermission("stamina999.admin")) {
                sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandNoPermissionCheckOther()));
                return;
            }
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandPlayerNotFound()));
                return;
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandUsageCheckPlayer()));
                return;
            }
            target = (Player)sender;
        }
        if ((data = this.plugin.getPlayerData(target)) != null) {
            String message = this.plugin.getCommandPlayerStaminaInfo().replace("%player%", target.getName()).replace("%current%", String.valueOf((int)data.currentStamina)).replace("%max%", String.valueOf(data.maxStamina));
            sender.sendMessage(this.plugin.formatMessage(message));
        } else {
            String message = this.plugin.getCommandPlayerStaminaError().replace("%player%", target.getName());
            sender.sendMessage(this.plugin.formatMessage(message));
        }
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("stamina999.admin")) {
            String message = this.plugin.getCommandNoPermission().replace("%permission%", "reload config");
            sender.sendMessage(this.plugin.formatMessage(message));
            return;
        }
        this.plugin.reloadConfig();
        sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandConfigReloaded()));
    }

    private void handleSet(CommandSender sender, String[] args) {
        if (!sender.hasPermission("stamina999.admin")) {
            String message = this.plugin.getCommandNoPermissionSet();
            sender.sendMessage(this.plugin.formatMessage(message));
            return;
        }
        if (args.length != 3) {
            sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandUsageSet()));
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandPlayerNotFound()));
            return;
        }
        try {
            int amount = Integer.parseInt(args[2]);
            Stamina999.PlayerData data = this.plugin.getPlayerData(target);
            if (data != null) {
                data.currentStamina = Math.max(0, Math.min(amount, data.maxStamina));
                String message = this.plugin.getCommandStaminaSet().replace("%player%", target.getName()).replace("%amount%", String.valueOf((int)data.currentStamina));
                sender.sendMessage(this.plugin.formatMessage(message));
            } else {
                String message = this.plugin.getCommandPlayerStaminaError().replace("%player%", target.getName());
                sender.sendMessage(this.plugin.formatMessage(message));
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandInvalidAmount()));
        }
    }

    private void handleMax(CommandSender sender, String[] args) {
        if (!sender.hasPermission("stamina999.admin")) {
            String message = this.plugin.getCommandNoPermissionSetMax();
            sender.sendMessage(this.plugin.formatMessage(message));
            return;
        }
        if (args.length != 3) {
            sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandUsageMax()));
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandPlayerNotFound()));
            return;
        }
        try {
            int amount = Integer.parseInt(args[2]);
            Stamina999.PlayerData data = this.plugin.getPlayerData(target);
            if (data != null) {
                data.maxStamina = Math.max(1, amount);
                data.currentStamina = Math.min(data.currentStamina, (double)data.maxStamina);
                String message = this.plugin.getCommandMaxStaminaSet().replace("%player%", target.getName()).replace("%amount%", String.valueOf(data.maxStamina));
                sender.sendMessage(this.plugin.formatMessage(message));
            } else {
                String message = this.plugin.getCommandPlayerStaminaError().replace("%player%", target.getName());
                sender.sendMessage(this.plugin.formatMessage(message));
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.formatMessage(this.plugin.getCommandInvalidAmount()));
        }
    }
}

