/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.stamina999;

import com.yourname.stamina999.Stamina999;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;

public class StaminaListener
implements Listener {
    private final Stamina999 plugin;

    public StaminaListener(Stamina999 plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.plugin.addPlayer(player);
        Stamina999.PlayerData data = this.plugin.getPlayerData(player);
        if (data != null) {
            data.wasSwimming = player.isSwimming();
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Stamina999.PlayerData data = this.plugin.getPlayerData(player);
        if (data != null) {
            data.wasSwimming = false;
        }
        this.plugin.removePlayer(player);
    }

    @EventHandler
    public void onPlayerLeaveBed(PlayerBedLeaveEvent event) {
        Stamina999.PlayerData data;
        Player player = event.getPlayer();
        long time = player.getWorld().getTime();
        if (time >= 0L && time < 1000L && (data = this.plugin.getPlayerData(player)) != null) {
            long durationMillis = (long)this.plugin.wellRestedDurationSeconds * 1000L;
            data.wellRestedEndTime = System.currentTimeMillis() + durationMillis;
            player.sendMessage(this.plugin.formatMessage(this.plugin.getFeelWellRested()));
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Stamina999.PlayerData data = this.plugin.getPlayerData(player);
        if (data != null) {
            long currentTime;
            if (event.getFrom().getX() != event.getTo().getX() || event.getFrom().getZ() != event.getTo().getZ()) {
                data.lastMoveTime = System.currentTimeMillis();
            }
            if (player.isSwimming() && data.currentStamina <= (double)data.maxStamina * this.plugin.swimmingThresholdPercentage && (currentTime = System.currentTimeMillis()) - data.lastExhaustedMessage > 10000L) {
                player.sendMessage(this.plugin.formatMessage(this.plugin.getTooExhaustedToSwim()));
                data.lastExhaustedMessage = currentTime;
            }
            data.wasSwimming = player.isSwimming();
        }
    }

    @EventHandler
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        Stamina999.PlayerData data = this.plugin.getPlayerData(player);
        if (data != null && event.isSprinting() && this.plugin.isBelowQuarterStamina(data)) {
            event.setCancelled(true);
            player.setSprinting(false);
            long currentTime = System.currentTimeMillis();
            if (currentTime - data.lastExhaustedMessage > 10000L) {
                player.sendMessage(this.plugin.formatMessage(this.plugin.getTooExhaustedToSprint()));
                data.lastExhaustedMessage = currentTime;
            }
        }
    }

    @EventHandler
    public void onPlayerEat(PlayerItemConsumeEvent event) {
        Stamina999.PlayerData data;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (item.getType().isEdible() && (data = this.plugin.getPlayerData(player)) != null) {
            this.plugin.replenishStamina(data);
            this.plugin.updatePlayerEffects(player, data);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Stamina999.PlayerData data = this.plugin.getPlayerData(player);
        if (data != null) {
            if (data.currentStamina < (double)this.plugin.miningStaminaPerBlock) {
                event.setCancelled(true);
                long currentTime = System.currentTimeMillis();
                if (currentTime - data.lastLowStaminaMessage > 10000L) {
                    player.sendMessage(this.plugin.formatMessage(this.plugin.getTooExhaustedToMine()));
                    data.lastLowStaminaMessage = currentTime;
                }
                return;
            }
            data.currentStamina -= (double)this.plugin.miningStaminaPerBlock;
            if (data.currentStamina <= 0.0) {
                data.currentStamina = 0.0;
                if (!data.hasExhausted) {
                    this.plugin.increaseMaxStamina(player, data);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerJump(PlayerMoveEvent event) {
        Stamina999.PlayerData data;
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (event.getFrom().getY() < event.getTo().getY() && !player.isFlying() && !player.isSneaking() && player.isOnGround() && Math.abs(event.getTo().getY() - event.getFrom().getY()) >= 0.1 && (data = this.plugin.getPlayerData(player)) != null) {
            if (data.currentStamina < this.plugin.jumpingStamina) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - data.lastLowStaminaMessage > 10000L) {
                    player.sendMessage(this.plugin.formatMessage(this.plugin.getTooExhaustedToJump()));
                    data.lastLowStaminaMessage = currentTime;
                }
                return;
            }
            data.currentStamina -= this.plugin.jumpingStamina;
            data.lastMoveTime = System.currentTimeMillis();
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
                return;
            }
            Stamina999.PlayerData data = this.plugin.getPlayerData(player);
            if (data != null) {
                if (data.currentStamina < this.plugin.attackingStamina) {
                    event.setCancelled(true);
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - data.lastLowStaminaMessage > 10000L) {
                        player.sendMessage(this.plugin.formatMessage(this.plugin.getTooExhaustedToAttack()));
                        data.lastLowStaminaMessage = currentTime;
                    }
                    return;
                }
                data.currentStamina -= this.plugin.attackingStamina;
                if (this.plugin.isStaminaLow(data) && this.plugin.reduceAttackDamage) {
                    event.setDamage(event.getDamage() * 0.5);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction().name().contains("RIGHT_CLICK")) {
            Stamina999.PlayerData data;
            Player player = event.getPlayer();
            if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
                return;
            }
            if (event.getItem() != null && event.getItem().getType().name().endsWith("_BOW") && (data = this.plugin.getPlayerData(player)) != null) {
                if (data.currentStamina < this.plugin.drawingBowStamina) {
                    event.setCancelled(true);
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - data.lastLowStaminaMessage > 10000L) {
                        player.sendMessage(this.plugin.formatMessage(this.plugin.getTooExhaustedToDrawBow()));
                        data.lastLowStaminaMessage = currentTime;
                    }
                    return;
                }
                data.currentStamina -= this.plugin.drawingBowStamina;
            }
        }
    }
}

