/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.stamina999;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class Stamina999
extends JavaPlugin
implements Listener {
    private final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private int defaultStamina;
    private int maxStaminaIncreaseAmount;
    private int staminaRegenDelay;
    private int staminaRegenAmount;
    private int staminaFoodRegen;
    private double walkingDrainRate;
    private double sprintingDrainRate;
    private double swimmingDrainRate;
    private int wellRestedDurationSeconds;
    private double wellRestedRegenMultiplier;
    private boolean showInExpBar;
    private boolean showInActionBar;
    private String actionBarMessage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                Stamina999.this.updateAllPlayers();
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new StaminaPlaceholder(this).register();
        }
    }

    private void loadConfig() {
        this.reloadConfig();
        this.defaultStamina = this.getConfig().getInt("default-stamina", 20);
        this.maxStaminaIncreaseAmount = this.getConfig().getInt("max-stamina-increase-amount", 5);
        this.staminaRegenDelay = this.getConfig().getInt("stamina-regen-delay", 2) * 20;
        this.staminaRegenAmount = this.getConfig().getInt("stamina-regen-amount", 2);
        this.staminaFoodRegen = this.getConfig().getInt("stamina-food-regen", 20);
        this.walkingDrainRate = this.calculateDrainRate("stamina-consumption.walking", 1.0, 60.0);
        this.sprintingDrainRate = this.calculateDrainRate("stamina-consumption.sprinting", 3.0, 20.0);
        this.swimmingDrainRate = this.calculateDrainRate("stamina-consumption.swimming", 2.0, 10.0);
        this.wellRestedDurationSeconds = this.getConfig().getInt("well-rested-buff.duration-seconds", 300);
        this.wellRestedRegenMultiplier = this.getConfig().getDouble("well-rested-buff.regen-multiplier", 2.0);
        this.showInExpBar = this.getConfig().getBoolean("display.show-in-exp-bar", true);
        this.showInActionBar = this.getConfig().getBoolean("display.show-in-action-bar", false);
        this.actionBarMessage = this.getConfig().getString("display.action-bar-message", "&eStamina: &f%current%/%max%");
    }

    private double calculateDrainRate(String path, double defaultAmount, double defaultInterval) {
        double interval = this.getConfig().getDouble(path + ".interval-seconds", defaultInterval);
        if (interval <= 0.0) {
            interval = 1.0;
        }
        double amount = this.getConfig().getDouble(path + ".amount", defaultAmount);
        return amount / interval;
    }

    @EventHandler
    public void onPlayerLeaveBed(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        long time = player.getWorld().getTime();
        if (time >= 0L && time < 1000L) {
            PlayerData data = this.playerDataMap.computeIfAbsent(player.getUniqueId(), k -> new PlayerData(this.defaultStamina));
            long durationMillis = (long)this.wellRestedDurationSeconds * 1000L;
            data.wellRestedEndTime = System.currentTimeMillis() + durationMillis;
            player.sendMessage("\u00a7aYou feel well rested.");
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getX() != event.getTo().getX() || event.getFrom().getZ() != event.getTo().getZ()) {
            Player player = event.getPlayer();
            PlayerData data = this.playerDataMap.computeIfAbsent(player.getUniqueId(), k -> new PlayerData(this.defaultStamina));
            data.lastMoveTime = System.currentTimeMillis();
        }
    }

    @EventHandler
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data != null && event.isSprinting() && this.isBelowQuarterStamina(data)) {
            event.setCancelled(true);
            player.setSprinting(false);
            player.sendMessage("\u00a7cYou're too exhausted to sprint!");
        }
    }

    @EventHandler
    public void onPlayerEat(PlayerItemConsumeEvent event) {
        PlayerData data;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item.getType().isEdible() && (data = this.playerDataMap.get(player.getUniqueId())) != null) {
            this.replenishStamina(data);
            this.updatePlayerEffects(player, data);
        }
    }

    private void updateAllPlayers() {
        long currentTime = System.currentTimeMillis();
        for (Player player : Bukkit.getOnlinePlayers()) {
            boolean isMoving;
            PlayerData data = this.playerDataMap.computeIfAbsent(player.getUniqueId(), k -> new PlayerData(this.defaultStamina));
            boolean bl = isMoving = currentTime - data.lastMoveTime < 250L;
            if (!isMoving && this.shouldRegenStamina(currentTime, data)) {
                this.regenerateStamina(data);
            } else if (isMoving) {
                this.consumeStamina(player, data);
            }
            if (player.isSprinting() && this.isBelowQuarterStamina(data)) {
                player.setSprinting(false);
                player.sendMessage("\u00a7cYou're too exhausted to sprint!");
            }
            this.updatePlayerEffects(player, data);
            this.updateActionBar(player, data, currentTime);
        }
    }

    private void consumeStamina(Player player, PlayerData data) {
        double drainRate = player.isSwimming() ? this.swimmingDrainRate : (player.isSprinting() ? this.sprintingDrainRate : this.walkingDrainRate);
        data.currentStamina -= drainRate;
        if (data.currentStamina <= 0.0) {
            data.currentStamina = 0.0;
            if (!data.hasExhausted) {
                this.increaseMaxStamina(player, data);
            }
        }
    }

    private void increaseMaxStamina(Player player, PlayerData data) {
        data.maxStamina += this.maxStaminaIncreaseAmount;
        data.hasExhausted = true;
        player.sendMessage("\u00a76Your stamina capacity increased to \u00a7e" + data.maxStamina + "\u00a76!");
    }

    private void replenishStamina(PlayerData data) {
        data.currentStamina = Math.min(data.currentStamina + (double)this.staminaFoodRegen, (double)data.maxStamina);
        if (data.currentStamina >= (double)data.maxStamina) {
            data.currentStamina = data.maxStamina;
            data.hasExhausted = false;
        }
    }

    private boolean shouldRegenStamina(long currentTime, PlayerData data) {
        return currentTime - data.lastMoveTime > (long)this.staminaRegenDelay;
    }

    private void regenerateStamina(PlayerData data) {
        double finalRegenAmount = this.staminaRegenAmount;
        if (System.currentTimeMillis() < data.wellRestedEndTime) {
            finalRegenAmount *= this.wellRestedRegenMultiplier;
        }
        data.currentStamina = Math.min(data.currentStamina + finalRegenAmount, (double)data.maxStamina);
        if (data.currentStamina > (double)data.maxStamina) {
            data.currentStamina = data.maxStamina;
        }
    }

    private void updatePlayerEffects(Player player, PlayerData data) {
        this.manageSlownessEffect(player, data);
        if (this.showInExpBar) {
            this.updateStaminaBar(player, data);
        }
    }

    private void updateActionBar(Player player, PlayerData data, long currentTime) {
        if (this.showInActionBar) {
            String message = this.actionBarMessage.replace("%current%", String.valueOf((int)data.currentStamina)).replace("%max%", String.valueOf(data.maxStamina));
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
        } else if (currentTime < data.wellRestedEndTime) {
            long timeLeftSeconds = (data.wellRestedEndTime - currentTime) / 1000L;
            String actionBarMsg = String.format("\u00a7aYou are well rested! (%ds)", timeLeftSeconds);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(actionBarMsg));
        }
    }

    private void manageSlownessEffect(Player player, PlayerData data) {
        boolean shouldHaveSlowness = data.currentStamina <= (double)data.maxStamina / 2.0;
        boolean hasSlowness = player.hasPotionEffect(PotionEffectType.SLOWNESS);
        if (shouldHaveSlowness && !hasSlowness) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 0, true, false));
        } else if (!shouldHaveSlowness && hasSlowness) {
            player.removePotionEffect(PotionEffectType.SLOWNESS);
        }
    }

    private boolean isBelowQuarterStamina(PlayerData data) {
        return data.currentStamina < (double)data.maxStamina / 4.0;
    }

    private void updateStaminaBar(Player player, PlayerData data) {
        if (data.maxStamina > 0) {
            float staminaPercent = (float)(data.currentStamina / (double)data.maxStamina);
            player.setExp(Math.max(0.0f, Math.min(staminaPercent, 1.0f)));
        }
        player.setLevel((int)Math.min(data.currentStamina, 20.0));
    }

    public PlayerData getPlayerData(Player player) {
        return this.playerDataMap.get(player.getUniqueId());
    }

    public class StaminaPlaceholder
    extends PlaceholderExpansion {
        private final Stamina999 plugin;

        public StaminaPlaceholder(Stamina999 plugin) {
            this.plugin = plugin;
        }

        @NotNull
        public String getIdentifier() {
            return "stamina";
        }

        @NotNull
        public String getAuthor() {
            return "YourName";
        }

        @NotNull
        public String getVersion() {
            return "1.0.0";
        }

        public boolean persist() {
            return true;
        }

        public String onPlaceholderRequest(Player player, @NotNull String params) {
            if (player == null) {
                return "";
            }
            PlayerData data = this.plugin.getPlayerData(player);
            if (data == null) {
                return "";
            }
            if (params.equals("current")) {
                return String.valueOf((int)data.currentStamina);
            }
            if (params.equals("max")) {
                return String.valueOf(data.maxStamina);
            }
            return null;
        }
    }

    private static class PlayerData {
        int maxStamina;
        double currentStamina;
        long lastMoveTime = 0L;
        boolean hasExhausted = false;
        long wellRestedEndTime = 0L;

        public PlayerData(int defaultStamina) {
            this.maxStamina = defaultStamina;
            this.currentStamina = defaultStamina;
        }
    }
}

