/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.stamina999;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Stamina999
extends JavaPlugin
implements Listener {
    private final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private int staminaRegenDelay;
    private int staminaRegenAmount;
    private int staminaUsageBlocks;
    private int staminaUsageAmount;
    private int staminaFoodRegen;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                Stamina999.this.updateStaminaBars();
                Stamina999.this.checkSprintStatus();
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.staminaRegenDelay = config.getInt("stamina-regen-delay", 2) * 20;
        this.staminaRegenAmount = config.getInt("stamina-regen-amount", 2);
        this.staminaUsageBlocks = config.getInt("stamina-usage-blocks", 5);
        this.staminaUsageAmount = config.getInt("stamina-usage-amount", 3);
        this.staminaFoodRegen = config.getInt("stamina-food-regen", 20);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.hasMovedBlock(event)) {
            return;
        }
        PlayerData data = this.playerDataMap.computeIfAbsent(uuid, k -> new PlayerData());
        data.lastMoveTime = System.currentTimeMillis();
        if (++data.blocksMoved >= this.staminaUsageBlocks) {
            data.blocksMoved = 0;
            this.consumeStamina(player, data);
            this.updatePlayerEffects(player, data);
        }
    }

    @EventHandler
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data != null && event.isSprinting() && this.isBelowQuarterStamina(data)) {
            event.setCancelled(true);
            player.setSprinting(false);
            player.sendMessage("\u00a7cYou're too exhausted to sprint!");
        }
    }

    @EventHandler
    public void onPlayerEat(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data != null) {
            this.replenishStamina(data);
            this.updatePlayerEffects(player, data);
        }
    }

    private boolean hasMovedBlock(PlayerMoveEvent event) {
        return event.getFrom().getBlockX() != event.getTo().getBlockX() || event.getFrom().getBlockY() != event.getTo().getBlockY() || event.getFrom().getBlockZ() != event.getTo().getBlockZ();
    }

    private void consumeStamina(Player player, PlayerData data) {
        data.currentStamina -= this.staminaUsageAmount;
        if (data.currentStamina < 0) {
            data.currentStamina = 0;
            if (!data.hasExhausted) {
                this.increaseMaxStamina(player, data);
            }
        }
    }

    private void increaseMaxStamina(Player player, PlayerData data) {
        data.maxStamina += 5;
        data.hasExhausted = true;
        player.sendMessage("\u00a76Your stamina capacity increased to \u00a7e" + data.maxStamina + "\u00a76!");
    }

    private void replenishStamina(PlayerData data) {
        data.currentStamina = Math.min(data.currentStamina + this.staminaFoodRegen, data.maxStamina);
        if (data.currentStamina == data.maxStamina) {
            data.hasExhausted = false;
        }
    }

    private void updateStaminaBars() {
        long currentTime = System.currentTimeMillis();
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerData data = this.playerDataMap.get(player.getUniqueId());
            if (data == null || !this.shouldRegenStamina(currentTime, data)) continue;
            this.regenerateStamina(data);
            this.updatePlayerEffects(player, data);
        }
    }

    private boolean shouldRegenStamina(long currentTime, PlayerData data) {
        return currentTime - data.lastMoveTime > (long)this.staminaRegenDelay;
    }

    private void regenerateStamina(PlayerData data) {
        data.currentStamina = Math.min(data.currentStamina + this.staminaRegenAmount, data.maxStamina);
    }

    private void checkSprintStatus() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerData data = this.playerDataMap.get(player.getUniqueId());
            if (data == null || !player.isSprinting() || !this.isBelowQuarterStamina(data)) continue;
            player.setSprinting(false);
            player.sendMessage("\u00a7cYou're too exhausted to sprint!");
        }
    }

    private void updatePlayerEffects(Player player, PlayerData data) {
        this.manageSlownessEffect(player, data);
        this.updateStaminaBar(player, data);
    }

    private void manageSlownessEffect(Player player, PlayerData data) {
        boolean shouldHaveSlowness = data.currentStamina <= data.maxStamina / 2;
        boolean hasSlowness = player.hasPotionEffect(PotionEffectType.SLOWNESS);
        if (shouldHaveSlowness && !hasSlowness) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, 0, true, false));
        } else if (!shouldHaveSlowness && hasSlowness) {
            player.removePotionEffect(PotionEffectType.SLOWNESS);
        }
    }

    private boolean isBelowQuarterStamina(PlayerData data) {
        return data.currentStamina < data.maxStamina / 4;
    }

    private void updateStaminaBar(Player player, PlayerData data) {
        float staminaPercent = (float)data.currentStamina / (float)data.maxStamina;
        player.setExp(staminaPercent);
        player.setLevel(data.currentStamina);
    }

    private static class PlayerData {
        int maxStamina = 20;
        int currentStamina = 20;
        int blocksMoved = 0;
        long lastMoveTime = System.currentTimeMillis();
        boolean hasExhausted = false;

        private PlayerData() {
        }
    }
}

