/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchools;
import net.wizards.content.WizardsSounds;
import net.wizards.item.Group;
import net.wizards.item.WizardArmor;

public class WizardArmors {
    private static final Supplier<Ingredient> WOOL_INGREDIENTS = () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_WOOL, Items.ORANGE_WOOL, Items.MAGENTA_WOOL, Items.LIGHT_BLUE_WOOL, Items.YELLOW_WOOL, Items.LIME_WOOL, Items.PINK_WOOL, Items.GRAY_WOOL, Items.LIGHT_GRAY_WOOL, Items.CYAN_WOOL, Items.PURPLE_WOOL, Items.BLUE_WOOL, Items.BROWN_WOOL, Items.GREEN_WOOL, Items.RED_WOOL, Items.BLACK_WOOL});
    public static Holder<ArmorMaterial> material_wizard = WizardArmors.material("wizard_robe", 1, 3, 2, 1, 9, WizardsSounds.WIZARD_ROBES_EQUIP.entry(), WOOL_INGREDIENTS);
    public static Holder<ArmorMaterial> material_arcane = WizardArmors.material("arcane_robe", 1, 3, 2, 1, 10, WizardsSounds.WIZARD_ROBES_EQUIP.entry(), WOOL_INGREDIENTS);
    public static Holder<ArmorMaterial> material_fire = WizardArmors.material("fire_robe", 1, 3, 2, 1, 10, WizardsSounds.WIZARD_ROBES_EQUIP.entry(), WOOL_INGREDIENTS);
    public static Holder<ArmorMaterial> material_frost = WizardArmors.material("frost_robe", 1, 3, 2, 1, 10, WizardsSounds.WIZARD_ROBES_EQUIP.entry(), WOOL_INGREDIENTS);
    public static Holder<ArmorMaterial> material_netherite_arcane = WizardArmors.material("netherite_arcane_robe", 1, 3, 2, 1, 15, WizardsSounds.WIZARD_ROBES_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> material_netherite_fire = WizardArmors.material("netherite_fire_robe", 1, 3, 2, 1, 15, WizardsSounds.WIZARD_ROBES_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> material_netherite_frost = WizardArmors.material("netherite_frost_robe", 1, 3, 2, 1, 15, WizardsSounds.WIZARD_ROBES_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static final ArrayList<Armor.Entry> entries = new ArrayList();
    private static final float spell_power_t1 = 0.2f;
    private static final float spell_power_t2 = 0.25f;
    private static final float spell_power_t3 = 0.3f;
    private static final float haste_t2 = 0.02f;
    private static final float haste_t3 = 0.03f;
    private static final float crit_damage_t2 = 0.05f;
    private static final float crit_chance_t3 = 0.03f;
    private static final float crit_chance_t2 = 0.02f;
    private static final float crit_damage_t3 = 0.06f;
    public static final Armor.Set wizardRobeSet = WizardArmors.create(material_wizard, ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"wizard_robe"), 10, WizardArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.2f)).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.2f)).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.2f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.2f)).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.2f)).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.2f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.2f)).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.2f)).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.2f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.2f)).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.2f)).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.2f))), 1).armorSet();
    public static final Armor.Set arcaneRobeSet = WizardArmors.create(material_arcane, ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"arcane_robe"), 20, WizardArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.02f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.02f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.02f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.02f)))), 2).armorSet();
    public static final Armor.Set fireRobeSet = WizardArmors.create(material_fire, ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"fire_robe"), 20, WizardArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.02f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.02f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.02f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.02f)))), 2).armorSet();
    public static final Armor.Set frostRobeSet = WizardArmors.create(material_frost, ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"frost_robe"), 20, WizardArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.05f)))), 2).armorSet();
    public static final Armor.Set netherite_arcane = WizardArmors.create(material_netherite_arcane, ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"netherite_arcane_robe"), 30, WizardArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f)))), 3).armorSet();
    public static final Armor.Set netherite_fire = WizardArmors.create(material_netherite_fire, ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"netherite_fire_robe"), 30, WizardArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.03f)))), 3).armorSet();
    public static final Armor.Set netherite_frost = WizardArmors.create(material_netherite_frost, ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"netherite_frost_robe"), 30, WizardArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.06f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.06f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.06f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.06f)))), 3).armorSet();

    public static Holder<ArmorMaterial> material(String name, int protectionHead, int protectionChest, int protectionLegs, int protectionFeet, int enchantability, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient) {
        ArmorMaterial material = new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, protectionHead, ArmorItem.Type.CHESTPLATE, protectionChest, ArmorItem.Type.LEGGINGS, protectionLegs, ArmorItem.Type.BOOTS, protectionFeet), enchantability, equipSound, repairIngredient, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)name))), 0.0f, 0.0f);
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)name), (Object)material);
    }

    private static Armor.Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, Armor.Set.ItemFactory factory, ArmorSetConfig defaults, int tier) {
        Armor.Entry entry = Armor.Entry.create(material, (ResourceLocation)id, (int)durability, (Armor.Set.ItemFactory)factory, (ArmorSetConfig)defaults, (Equipment.LootProperties)Equipment.LootProperties.of((int)tier));
        entries.add(entry);
        return entry;
    }

    public static void register(Map<String, ArmorSetConfig> configs) {
        Armor.register(configs, entries, Group.KEY);
    }
}

