/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.mixin.effect;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.wizards.effect.FrostShielded;
import net.wizards.effect.WizardsEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityFrostShield
implements FrostShielded {
    private boolean hasFrostShield = false;

    @Inject(method={"isBlocking()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isBlocking_HEAD_FrostShield(CallbackInfoReturnable<Boolean> cir) {
        if (this.hasFrostShield) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void blockedByShield_HEAD_FrostShield(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        if (this.hasFrostShield && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void damage_HEAD_FrostShieldFireImmunity(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.hasFrostShield && source.is(DamageTypeTags.IS_FIRE)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"baseTick()V"}, at={@At(value="TAIL")})
    private void baseTick_TAIL_FrostShield(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        this.hasFrostShield = entity.hasEffect(WizardsEffects.frostShield.entry);
        if (this.hasFrostShield && entity.isOnFire()) {
            entity.clearFire();
        }
    }

    @Override
    public boolean hasFrostShield() {
        return this.hasFrostShield;
    }
}

