/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.content;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.spell_engine.api.datagen.SpellBuilder;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellSchools;
import net.wizards.content.WizardsSounds;
import org.jetbrains.annotations.Nullable;

public class WizardSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    private static final String PRIMARY_GROUP = "primary";
    private static final float BASIC_PROJECTILE_RANGE = 48.0f;
    private static final Color ARCANE_COLOR = Color.from((int)SpellSchools.ARCANE.color);
    public static Entry arcane_bolt = WizardSpells.add(WizardSpells.arcane_bolt());
    public static Entry fire_wall = WizardSpells.add(WizardSpells.fire_wall());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.cast = new Spell.Active.Cast();
        return spell;
    }

    private static ParticleBatch arcaneCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f).color(ARCANE_COLOR.toRGBA());
    }

    private static Spell.Impact damage(float coefficient, float knockback) {
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = Spell.Impact.Action.Type.DAMAGE;
        impact.action.damage = new Spell.Impact.Action.Damage();
        impact.action.damage.spell_power_coefficient = coefficient;
        impact.action.damage.knockback = knockback;
        return impact;
    }

    private static void configureArcaneRuneCost(Spell spell) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.item = new Spell.Cost.Item();
        spell.cost.item.id = "runes:arcane_stone";
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.cooldown = new Spell.Cost.Cooldown();
        spell.cost.cooldown.duration = duration;
    }

    private static Entry arcane_bolt() {
        class_2960 id = class_2960.method_60655((String)"wizards", (String)"arcane_bolt");
        Spell spell = WizardSpells.activeSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.group = PRIMARY_GROUP;
        spell.tier = 0;
        spell.range = 48.0f;
        spell.active.cast.duration = 1.0f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_ARCANE_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.arcaneCastingParticles()};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_projectile_release";
        spell.release.sound = new Sound(WizardsSounds.ARCANE_MISSILE_RELEASE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 1.0f;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.light_level = 10;
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.05f, 0.1f, 0.0f, 0.0f).color(ARCANE_COLOR.toRGBA())};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "wizards:projectile/arcane_bolt";
        projectile.client_data.model.scale = 0.5f;
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = WizardSpells.damage(0.7f, 0.6f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.2f, 0.7f, 0.0f, 0.0f).color(ARCANE_COLOR.toRGBA())};
        damage.sound = new Sound(WizardsSounds.ARCANE_MISSILE_IMPACT.id());
        spell.impacts = List.of(damage);
        WizardSpells.configureArcaneRuneCost(spell);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry fire_wall() {
        class_2960 id = class_2960.method_60655((String)"wizards", (String)"fire_wall");
        String name = "Wall of Flames";
        String description = "Creates a wall of fire, lasting {cloud_duration} seconds, dealing up to {damage} fire spell damage continuously to enemies passing thru.";
        Spell spell = SpellBuilder.createSpellActive();
        spell.range = 0.0f;
        spell.tier = 4;
        spell.school = SpellSchools.FIRE;
        spell.learn = new Spell.Learn();
        SpellBuilder.Casting.instant((Spell)spell);
        SpellBuilder.Release.visuals((Spell)spell, (String)"spell_engine:one_handed_area_release_ground_left_to_right", null, null);
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = 0.9f;
        cloud.volume.area.vertical_range_multiplier = 4.0f;
        cloud.volume.sound = new Sound(WizardsSounds.FIRE_SCORCH_IMPACT.id());
        cloud.delay_ticks = 0;
        cloud.impact_tick_interval = 8;
        cloud.time_to_live_seconds = 8.0f;
        cloud.spawn = new Spell.Delivery.Cloud.Spawn();
        cloud.spawn.sound = new Sound(WizardsSounds.FIRE_WALL_IGNITE.id());
        cloud.spawn.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 15.0f, 0.1f, 0.5f)};
        cloud.client_data = new Spell.Delivery.Cloud.ClientData();
        cloud.client_data.light_level = 15;
        cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame_ground.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 2.0f, 0.0f, 0.0f), new ParticleBatch(SpellEngineParticles.flame_medium_a.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 3.0f, 0.02f, 0.3f), new ParticleBatch(SpellEngineParticles.flame_medium_b.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 3.0f, 0.01f, 0.35f), new ParticleBatch(SpellEngineParticles.flame_spark.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 4.0f, 0.05f, 0.3f), new ParticleBatch("campfire_cosy_smoke", ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 0.1f, 0.05f, 0.1f)};
        cloud.placement = SpellBuilder.Deliver.placementByLook((float)4.4f, (float)-64.0f, (int)0);
        cloud.additional_placements = List.of(SpellBuilder.Deliver.placementByLook((float)2.8f, (float)-45.0f, (int)4), SpellBuilder.Deliver.placementByLook((float)2.0f, (float)0.0f, (int)4), SpellBuilder.Deliver.placementByLook((float)2.8f, (float)45.0f, (int)4), SpellBuilder.Deliver.placementByLook((float)4.4f, (float)64.0f, (int)4));
        spell.deliver.clouds = List.of(cloud);
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.8f, (float)0.4f);
        damage.particles = new ParticleBatch[]{new ParticleBatch("smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.01f, 0.1f), new ParticleBatch("flame", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.01f, 0.1f)};
        damage.sound = new Sound(WizardsSounds.FIRE_SCORCH_IMPACT.id());
        Spell.Impact fire = SpellBuilder.Impacts.fire((float)2.0f);
        spell.impacts = List.of(damage, fire);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)24.0f);
        SpellBuilder.Cost.item((Spell)spell, (String)"runes:fire_stone", (int)1);
        SpellBuilder.Cost.exhaust((Spell)spell, (float)0.4f);
        return new Entry(id, spell, name, description, null);
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

