/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest;

import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedmekanism.part.PartTypesMekanism;
import org.cyclops.integratedmekanism.part.aspect.MekanismAspects;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;

@GameTestHolder(value="integratedmekanism")
@PrefixGameTestTemplate(value=false)
public class GameTestsAspectsReadChemical {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    public static TileEntityChemicalTank setTank(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)MekanismBlocks.BASIC_CHEMICAL_TANK.get());
        TileEntityChemicalTank chemicalTank = (TileEntityChemicalTank)helper.getBlockEntity(POS.west());
        chemicalTank.getConfig().getConfig(TransmissionType.CHEMICAL).setDataType(DataType.INPUT_OUTPUT, RelativeSide.LEFT);
        return chemicalTank;
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalFullTrue(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        chemicalTank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 64000L));
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.BOOLEAN_FULL, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalFullFalse(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        chemicalTank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 10L));
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.BOOLEAN_FULL, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalEmptyTrue(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.BOOLEAN_EMPTY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalEmptyFalse(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        chemicalTank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 10L));
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.BOOLEAN_EMPTY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalNonEmptyTrue(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        chemicalTank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 10L));
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.BOOLEAN_NONEMPTY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalNonEmptyFalse(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.BOOLEAN_NONEMPTY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalApplicableTrue(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.BOOLEAN_APPLICABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalApplicableFalse(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.BOOLEAN_APPLICABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalAmount(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        chemicalTank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 10L));
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.LONG_AMOUNT, (IValue)ValueTypeLong.ValueLong.of((long)10L));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalAmountTotal(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        chemicalTank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 10L));
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.LONG_AMOUNTTOTAL, (IValue)ValueTypeLong.ValueLong.of((long)10L));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalCapacityValid(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.LONG_CAPACITY, (IValue)ValueTypeLong.ValueLong.of((long)64000L));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalCapacityInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.LONG_CAPACITY, (IValue)ValueTypeLong.ValueLong.of((long)0L));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalCapacityTotalValid(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.LONG_CAPACITYTOTAL, (IValue)ValueTypeLong.ValueLong.of((long)64000L));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalCapacityTotalInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.LONG_CAPACITYTOTAL, (IValue)ValueTypeLong.ValueLong.of((long)0L));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalTanksValid(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.INTEGER_TANKS, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalTanksInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.INTEGER_TANKS, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalFillRatio(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        chemicalTank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 500L));
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.DOUBLE_FILLRATIO, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0078125));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalTankChemicals(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        chemicalTank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 500L));
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.LIST_TANKCHEMICALS, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeChemicalStack.ValueChemicalStack[]{ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 500L))}));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalTankCapacities(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        chemicalTank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 500L));
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.LIST_TANKCAPACITIES, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueTypeLong.ValueLong[]{ValueTypeLong.ValueLong.of((long)64000L)}));
    }

    @GameTest(template="empty10")
    public void testAspectsReadChemicalChemicalStack(GameTestHelper helper) {
        TileEntityChemicalTank chemicalTank = GameTestsAspectsReadChemical.setTank(helper);
        chemicalTank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 500L));
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypesMekanism.CHEMICAL_READER, MekanismAspects.Read.Chemical.CHEMICALSTACK, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 500L)));
    }
}

