/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest;

import mekanism.generators.common.registries.GeneratorsBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.integratedmekanism.gametest.GameTestsAspectsReadMachineFission;

@GameTestHolder(value="integratedmekanism")
@PrefixGameTestTemplate(value=false)
public class GameTestsCapabilitiesWorker {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="empty10")
    public void testBlockWorkerCapFissionReactorInvalid(GameTestHelper helper) {
        helper.setBlock(POS, (Block)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER.get());
        helper.succeedIf(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)false, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)false, "Worker can work does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockWorkerCapFissionReactorValid(GameTestHelper helper) {
        BlockPos ioPos = GameTestsAspectsReadMachineFission.build(helper, POS);
        helper.succeedIf(() -> {
            IWorker worker = (IWorker)helper.getLevel().getCapability(Capabilities.Worker.BLOCK, helper.absolutePos(ioPos), (Object)Direction.NORTH);
            helper.assertTrue(worker != null, "Worker does not exist");
            helper.assertValueEqual((Object)worker.hasWork(), (Object)false, "Worker has work does not match");
            helper.assertValueEqual((Object)worker.canWork(), (Object)false, "Worker can work does not match");
        });
    }
}

