/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest;

import com.google.common.collect.Sets;
import java.util.Set;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.FactoryTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;

@GameTestHolder(value="integratedmekanism")
@PrefixGameTestTemplate(value=false)
public class GameTestsChemicalRecipeHandler {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    protected static void testMachine(GameTestHelper helper, Block block, Set<IngredientComponent<?, ?>> inputComponents, Set<IngredientComponent<?, ?>> outputComponents, int minRecipes) {
        helper.setBlock(POS, block);
        helper.succeedIf(() -> {
            IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(recipeHandler != null, "Recipe handler does not exist");
            helper.assertValueEqual((Object)recipeHandler.getRecipeInputComponents(), (Object)inputComponents, "Input components are incorrect");
            helper.assertValueEqual((Object)recipeHandler.getRecipeOutputComponents(), (Object)outputComponents, "Output components are incorrect");
            helper.assertTrue(recipeHandler.getRecipes().size() >= minRecipes, "Recipe count " + recipeHandler.getRecipes().size() + " is less than " + minRecipes);
            for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                helper.assertTrue(recipeHandler.simulate((IMixedIngredients)MixedIngredients.fromRecipeInput((IRecipeDefinition)recipe)) != null, "Recipe simulation failed for " + String.valueOf(recipe));
            }
        });
    }

    protected static void testMachineFactories(GameTestHelper helper, FactoryType factoryType, Set<IngredientComponent<?, ?>> inputComponents, Set<IngredientComponent<?, ?>> outputComponents, int minRecipes) {
        for (FactoryTier factoryTier : FactoryTier.values()) {
            helper.setBlock(POS.offset(0, factoryTier.ordinal(), 0), (Block)MekanismBlocks.getFactory((FactoryTier)factoryTier, (FactoryType)factoryType).get());
        }
        helper.succeedIf(() -> {
            for (FactoryTier factoryTier : FactoryTier.values()) {
                IRecipeHandler recipeHandler = (IRecipeHandler)helper.getLevel().getCapability(Capabilities.RecipeHandler.BLOCK, helper.absolutePos(POS.offset(0, factoryTier.ordinal(), 0)), (Object)Direction.NORTH);
                helper.assertTrue(recipeHandler != null, "Recipe handler does not exist");
                helper.assertValueEqual((Object)recipeHandler.getRecipeInputComponents(), (Object)inputComponents, "Input components are incorrect");
                helper.assertValueEqual((Object)recipeHandler.getRecipeOutputComponents(), (Object)outputComponents, "Output components are incorrect");
                helper.assertTrue(recipeHandler.getRecipes().size() >= minRecipes, "Recipe count " + recipeHandler.getRecipes().size() + " is less than " + minRecipes);
                for (IRecipeDefinition recipe : recipeHandler.getRecipes()) {
                    helper.assertTrue(recipeHandler.simulate((IMixedIngredients)MixedIngredients.fromRecipeInput((IRecipeDefinition)recipe)) != null, "Recipe simulation failed for " + String.valueOf(recipe));
                }
            }
        });
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCrusher(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.CRUSHER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 200);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCrusherFactories(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachineFactories(helper, FactoryType.CRUSHING, Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 200);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerEnrichmentChamber(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.ENRICHMENT_CHAMBER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 187);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerEnrichmentChamberFactories(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachineFactories(helper, FactoryType.ENRICHING, Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 187);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerEnergizedSmelter(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.ENERGIZED_SMELTER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 97);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerEnergizedSmelterFactories(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachineFactories(helper, FactoryType.SMELTING, Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 97);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerChemicalInfuser(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.CHEMICAL_INFUSER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), 5);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCombiner(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.COMBINER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 82);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerCombinerFactories(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachineFactories(helper, FactoryType.COMBINING, Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 82);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerElectrolyticSeparator(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.ELECTROLYTIC_SEPARATOR.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.FLUIDSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), 3);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerWasher(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.CHEMICAL_WASHER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, IngredientComponents.FLUIDSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), 7);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerThermalEvaporationController(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.FLUIDSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.FLUIDSTACK}), 2);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerThermalEvaporationValve(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.THERMAL_EVAPORATION_VALVE.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.FLUIDSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.FLUIDSTACK}), 2);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerSolarNeutronActivator(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR.get(), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), 2);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerIsotopicCentrifige(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.ISOTOPIC_CENTRIFUGE.get(), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), 2);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerChemicalCrystalizer(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.CHEMICAL_CRYSTALLIZER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 10);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerChemicalDissolutionChamber(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), 23);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerOsmiumCompressor(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.OSMIUM_COMPRESSOR.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 2);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerOsmiumCompressorFactories(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachineFactories(helper, FactoryType.COMPRESSING, Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 2);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerPurificationChamber(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.PURIFICATION_CHAMBER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 28);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerPurificationChamberFactories(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachineFactories(helper, FactoryType.PURIFYING, Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 28);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerChemicalInjectionChamber(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.CHEMICAL_INJECTION_CHAMBER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 91);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerChemicalInjectionChamberFactories(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachineFactories(helper, FactoryType.INJECTING, Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 91);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerAntiprotonic(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.ANTIPROTONIC_NUCLEOSYNTHESIZER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 21);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerChemicalOxidizer(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.CHEMICAL_OXIDIZER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), 25);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerPigmentExtractor(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.PIGMENT_EXTRACTOR.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), 394);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerPigmentMixer(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.PIGMENT_MIXER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), 16);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerMetallurgicInfuser(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.METALLURGIC_INFUSER.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 31);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerMetallurgicInfuserFactories(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachineFactories(helper, FactoryType.INFUSING, Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 31);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerPaining(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.PAINTING_MACHINE.get(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponents.ITEMSTACK}), 464);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerReaction(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.PRESSURIZED_REACTION_CHAMBER.get(), Set.of(IngredientComponents.ITEMSTACK, IngredientComponents.FLUIDSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK), Set.of(IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK), 14);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerRotary(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.ROTARY_CONDENSENTRATOR.get(), Set.of(IngredientComponents.FLUIDSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK), Set.of(IngredientComponents.FLUIDSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK), 40);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerSawmill(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachine(helper, (Block)MekanismBlocks.PRECISION_SAWMILL.get(), Set.of(IngredientComponents.ITEMSTACK), Set.of(IngredientComponents.ITEMSTACK), 124);
    }

    @GameTest(template="empty10")
    public void testBlockRecipeHandlerSawmillFactories(GameTestHelper helper) {
        GameTestsChemicalRecipeHandler.testMachineFactories(helper, FactoryType.SAWING, Set.of(IngredientComponents.ITEMSTACK), Set.of(IngredientComponents.ITEMSTACK), 124);
    }
}

