/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.machine.TileEntityRotaryCondensentrator;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedcrafting.gametest.GameTestHelpersIntegratedCrafting;
import org.cyclops.integratedcrafting.part.PartTypeInterfaceCrafting;
import org.cyclops.integratedcrafting.part.aspect.CraftingAspectWriteBuilders;
import org.cyclops.integratedcrafting.part.aspect.CraftingAspects;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.modcompat.integratedtunnels.part.PartTypesMekanismTunnels;
import org.cyclops.integratedtunnels.part.PartTypes;

@GameTestHolder(value="integratedmekanism")
@PrefixGameTestTemplate(value=false)
public class GameTestsCrafting {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    public static TileEntityChemicalTank setChemicalTank(GameTestHelper helper, BlockPos pos) {
        helper.setBlock(pos, (Block)MekanismBlocks.BASIC_CHEMICAL_TANK.get());
        TileEntityChemicalTank chemicalTank = (TileEntityChemicalTank)helper.getBlockEntity(pos);
        GameTestsCrafting.enableIo((TileEntityConfigurableMachine)chemicalTank);
        return chemicalTank;
    }

    public static TileEntityFluidTank setFluidTank(GameTestHelper helper, BlockPos pos) {
        helper.setBlock(pos, (Block)MekanismBlocks.BASIC_FLUID_TANK.get());
        TileEntityFluidTank fluidTank = (TileEntityFluidTank)helper.getBlockEntity(pos);
        return fluidTank;
    }

    public static void enableIo(TileEntityConfigurableMachine blockEntity) {
        for (RelativeSide relativeSide : RelativeSide.values()) {
            blockEntity.getConfig().getConfig(TransmissionType.CHEMICAL).setDataType(DataType.INPUT_OUTPUT, relativeSide);
            blockEntity.getConfig().getConfig(TransmissionType.ITEM).setDataType(DataType.INPUT_OUTPUT, relativeSide);
        }
        blockEntity.getConfig().getConfig(TransmissionType.ITEM).setCanEject(true);
    }

    public static TileEntityConfigurableMachine getMachine(GameTestHelper helper, GameTestHelpersIntegratedCrafting.INetworkPositions<PartTypeInterfaceCrafting.State> positions) {
        PartPos iface = (PartPos)positions.interfaces().get(0);
        return (TileEntityConfigurableMachine)helper.getLevel().getBlockEntity(iface.getPos().getBlockPos().relative(iface.getSide()));
    }

    public static void enableChemicalRecipeInWriter(GameTestHelper helper, PartPos writerPos, IRecipeDefinition recipe) {
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)writerPos, (IAspectWrite)CraftingAspects.Write.RECIPE_CRAFT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_RECIPE, (IValue)ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)recipe)));
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testCraftingCrystalizeBrineToSalt(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.INetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork((GameTestHelper)helper, (BlockPos)POS, (Block[])new Block[]{(Block)MekanismBlocks.CHEMICAL_CRYSTALLIZER.get()});
        TileEntityConfigurableMachine machine = GameTestsCrafting.getMachine(helper, (GameTestHelpersIntegratedCrafting.INetworkPositions<PartTypeInterfaceCrafting.State>)positions);
        machine.insertEnergy(100000L, Action.EXECUTE);
        machine.getConfig().getConfig(TransmissionType.CHEMICAL).setDataType(DataType.INPUT, RelativeSide.TOP);
        machine.getConfig().getConfig(TransmissionType.ITEM).setDataType(DataType.OUTPUT, RelativeSide.TOP);
        machine.getConfig().getConfig(TransmissionType.ITEM).setEjecting(true);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.east());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.SOUTH, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        TileEntityChemicalTank tank = GameTestsCrafting.setChemicalTank(helper, POS.south());
        tank.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.BRINE, 15L));
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        inputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, List.of(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, (Object)new ChemicalStack((Holder)MekanismChemicals.BRINE, 15L), (Object)3)}))));
        MixedIngredients output = MixedIngredients.ofInstance((IngredientComponent)IngredientComponent.ITEMSTACK, (Object)new ItemStack((ItemLike)MekanismItems.SALT.asItem()));
        ItemStack variableRecipe = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_RECIPE, (IValue)ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition((Map)inputs, (IMixedIngredients)output)));
        ((PartTypeInterfaceCrafting.State)positions.interfaceStates().get(0)).getInventoryVariables().setItem(0, variableRecipe);
        GameTestHelpersIntegratedCrafting.enableRecipeInWriter((GameTestHelper)helper, (PartPos)positions.writer(), (ItemStack)new ItemStack((ItemLike)MekanismItems.SALT.asItem()));
        helper.succeedWhen(() -> {
            helper.assertTrue(((PartTypeInterfaceCrafting.State)positions.interfaceStates().get(0)).isRecipeSlotValid(0), "Recipe in crafting interface is not valid");
            helper.assertValueEqual((Object)chestIn.getItem(0).getItem(), (Object)MekanismItems.SALT.asItem(), "Slot 0 item is incorrect");
            helper.assertValueEqual((Object)chestIn.getItem(0).getCount(), (Object)1, "Slot 0 amount is incorrect");
        });
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testCraftingRotaryWaterVapor(GameTestHelper helper) {
        GameTestHelpersIntegratedCrafting.INetworkPositions positions = GameTestHelpersIntegratedCrafting.createBasicNetwork((GameTestHelper)helper, (BlockPos)POS, (Block[])new Block[]{(Block)MekanismBlocks.ROTARY_CONDENSENTRATOR.get()});
        TileEntityConfigurableMachine machine = GameTestsCrafting.getMachine(helper, (GameTestHelpersIntegratedCrafting.INetworkPositions<PartTypeInterfaceCrafting.State>)positions);
        machine.insertEnergy(100000L, Action.EXECUTE);
        machine.getConfig().getConfig(TransmissionType.FLUID).setDataType(DataType.INPUT, RelativeSide.TOP);
        machine.getConfig().getConfig(TransmissionType.CHEMICAL).setDataType(DataType.OUTPUT, RelativeSide.TOP);
        machine.getConfig().getConfig(TransmissionType.CHEMICAL).setEjecting(true);
        ((TileEntityRotaryCondensentrator)machine).nextMode();
        PartHelpers.removePart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.EAST, null, (boolean)true, (boolean)false, (boolean)false);
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        TileEntityFluidTank fluidTank = GameTestsCrafting.setFluidTank(helper, POS.east());
        fluidTank.setFluidInTank(0, new FluidStack((Fluid)Fluids.WATER, 10));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.SOUTH, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        TileEntityChemicalTank tank = GameTestsCrafting.setChemicalTank(helper, POS.south());
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        inputs.put(IngredientComponents.FLUIDSTACK, List.of(new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponents.FLUIDSTACK, (Object)new FluidStack((Fluid)Fluids.WATER, 1), (Object)3)}))));
        MixedIngredients output = MixedIngredients.ofInstance(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, (Object)new ChemicalStack((Holder)MekanismChemicals.WATER_VAPOR, 1L));
        RecipeDefinition recipe = new RecipeDefinition((Map)inputs, (IMixedIngredients)output);
        ItemStack variableRecipe = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_RECIPE, (IValue)ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)recipe));
        ((PartTypeInterfaceCrafting.State)positions.interfaceStates().get(0)).getInventoryVariables().setItem(0, variableRecipe);
        GameTestsCrafting.enableChemicalRecipeInWriter(helper, positions.writer(), (IRecipeDefinition)recipe);
        PartPos posCraftingWriter = positions.writer();
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)posCraftingWriter);
        IAspectProperties properties = CraftingAspects.Write.RECIPE_CRAFT.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)posCraftingWriter), partStateHolder.getState());
        properties.setValue(CraftingAspectWriteBuilders.PROP_CRAFT_AMOUNT, (IValue)ValueTypeInteger.ValueInteger.of((int)10));
        partStateHolder.getState().setAspectProperties((IAspect)CraftingAspects.Write.RECIPE_CRAFT, properties);
        helper.succeedWhen(() -> {
            helper.assertTrue(((PartTypeInterfaceCrafting.State)positions.interfaceStates().get(0)).isRecipeSlotValid(0), "Recipe in crafting interface is not valid");
            ChemicalStack stack = tank.getChemicalTank().getStack();
            helper.assertValueEqual((Object)stack.getChemical(), (Object)((Chemical)MekanismChemicals.WATER_VAPOR.get()), "Slot 0 item is incorrect");
            helper.assertValueEqual((Object)stack.getAmount(), (Object)10L, "Slot 0 amount is incorrect");
        });
    }
}

