/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiBox;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integratedmekanism.IntegratedMekanism;
import org.cyclops.integratedmekanism.logicprogrammer.ValueTypeRecipeChemicalLPElement;
import org.cyclops.integratedmekanism.network.packet.LogicProgrammerValueTypeRecipeChemicalValueChangedPacket;

@OnlyIn(value=Dist.CLIENT)
class ValueTypeRecipeChemicalLPElementRecipeSubGui
extends RenderPattern<ValueTypeRecipeChemicalLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
implements IRenderPatternValueTypeTooltip {
    private boolean renderTooltip = true;
    private List<WidgetTextFieldExtended> inputFluidAmounts = null;
    private List<WidgetTextFieldExtended> inputChemicalAmounts = null;
    private List<WidgetTextFieldExtended> outputFluidAmounts = null;
    private List<WidgetTextFieldExtended> outputChemicalAmounts = null;

    public ValueTypeRecipeChemicalLPElementRecipeSubGui(ValueTypeRecipeChemicalLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        super((IGuiInputElement)element, baseX, baseY, maxWidth, maxHeight, (Screen)gui, (AbstractContainerMenu)container);
    }

    public List<WidgetTextFieldExtended> getInputFluidAmounts() {
        return this.inputFluidAmounts;
    }

    public List<WidgetTextFieldExtended> getInputChemicalAmounts() {
        return this.inputChemicalAmounts;
    }

    public List<WidgetTextFieldExtended> getOutputFluidAmounts() {
        return this.outputFluidAmounts;
    }

    public List<WidgetTextFieldExtended> getOutputChemicalAmounts() {
        return this.outputChemicalAmounts;
    }

    public void setRenderTooltip(boolean renderTooltip) {
        this.renderTooltip = renderTooltip;
    }

    public boolean isRenderTooltip() {
        return this.renderTooltip;
    }

    protected static WidgetTextFieldExtended makeTextBox(int componentId, int x, int y, String text) {
        Font fontRenderer = Minecraft.getInstance().font;
        int searchWidth = 32;
        Objects.requireNonNull(fontRenderer);
        WidgetTextFieldExtended box = new WidgetTextFieldExtended(fontRenderer, x, y, searchWidth, 9 + 3, (Component)Component.translatable((String)"gui.cyclopscore.search"), true);
        box.setMaxLength(10);
        box.setBordered(false);
        box.setVisible(true);
        box.setTextColor(0xFFFFFF);
        box.setCanLoseFocus(true);
        box.setValue(text);
        box.setWidth(searchWidth);
        return box;
    }

    public void init(int guiLeft, int guiTop) {
        super.init(guiLeft, guiTop);
        int slotSpacing = 20;
        this.inputFluidAmounts = IntStream.range(0, 2).mapToObj(i -> ValueTypeRecipeChemicalLPElementRecipeSubGui.makeTextBox(i, guiLeft + this.getX() + 39, guiTop + this.getY() + 19 + slotSpacing * i, (String)((ValueTypeRecipeChemicalLPElement)this.element).getInputFluids().get(i).getRight())).toList();
        this.inputChemicalAmounts = IntStream.range(0, 2).mapToObj(i -> ValueTypeRecipeChemicalLPElementRecipeSubGui.makeTextBox(2 + i, guiLeft + this.getX() + 39, guiTop + this.getY() + 55 + slotSpacing * i, (String)((ValueTypeRecipeChemicalLPElement)this.element).getInputChemicals().get(i).getRight())).toList();
        this.outputFluidAmounts = IntStream.range(0, 2).mapToObj(i -> ValueTypeRecipeChemicalLPElementRecipeSubGui.makeTextBox(4 + i, guiLeft + this.getX() + 117, guiTop + this.getY() + 19 + slotSpacing * i, (String)((ValueTypeRecipeChemicalLPElement)this.element).getOutputFluids().get(i).getRight())).toList();
        this.outputChemicalAmounts = IntStream.range(0, 2).mapToObj(i -> ValueTypeRecipeChemicalLPElementRecipeSubGui.makeTextBox(6 + i, guiLeft + this.getX() + 117, guiTop + this.getY() + 55 + slotSpacing * i, (String)((ValueTypeRecipeChemicalLPElement)this.element).getOutputChemicals().get(i).getRight())).toList();
    }

    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
        if (((ContainerScreenLogicProgrammerBase)this.gui).isHovering(this.getX() + 0, this.getY() + 0, 22, 18, (double)mouseX, (double)mouseY)) {
            ((ContainerScreenLogicProgrammerBase)this.gui).drawTooltip((List)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"gui.integratedmekanism.logicprogrammer.element.recipechemical.tooltip.item")}), guiGraphics.pose(), mouseX - guiLeft, mouseY - guiTop);
        }
        if (((ContainerScreenLogicProgrammerBase)this.gui).isHovering(this.getX() + 0, this.getY() + 18, 22, 36, (double)mouseX, (double)mouseY)) {
            ((ContainerScreenLogicProgrammerBase)this.gui).drawTooltip((List)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"gui.integratedmekanism.logicprogrammer.element.recipechemical.tooltip.fluid")}), guiGraphics.pose(), mouseX - guiLeft, mouseY - guiTop);
        }
        if (((ContainerScreenLogicProgrammerBase)this.gui).isHovering(this.getX() + 0, this.getY() + 54, 22, 36, (double)mouseX, (double)mouseY)) {
            ((ContainerScreenLogicProgrammerBase)this.gui).drawTooltip((List)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"gui.integratedmekanism.logicprogrammer.element.recipechemical.tooltip.chemical")}), guiGraphics.pose(), mouseX - guiLeft, mouseY - guiTop);
        }
        this.drawTooltipForeground((ContainerScreenLogicProgrammerBase)this.gui, guiGraphics, (ContainerLogicProgrammerBase)this.container, guiLeft, guiTop, mouseX, mouseY, ((ValueTypeRecipeChemicalLPElement)this.element).getValueType());
        for (int slotId = 0; slotId < ((ContainerLogicProgrammerBase)this.container).slots.size(); ++slotId) {
            int slotY;
            int slotX;
            Slot slot = (Slot)((ContainerLogicProgrammerBase)this.container).slots.get(slotId);
            if (slotId < 4 || slotId >= 6 || !((ContainerScreenLogicProgrammerBase)this.gui).isHovering(slotX = slot.x, slotY = slot.y, 16, 16, (double)mouseX, (double)mouseY)) continue;
            ((ContainerScreenLogicProgrammerBase)this.gui).drawTooltip((List)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"valuetype.integrateddynamics.ingredients.slot.info").withStyle(ChatFormatting.ITALIC)}), guiGraphics.pose(), mouseX - guiLeft, mouseY - guiTop - (slot.getItem().isEmpty() ? 0 : 15));
        }
    }

    public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        guiGraphics.renderItem(new ItemStack((ItemLike)Items.CHEST), guiLeft + this.getX() + 2, guiTop + this.getY());
        guiGraphics.renderItem(new ItemStack((ItemLike)Items.BUCKET), guiLeft + this.getX() + 2, guiTop + this.getY() + 18);
        guiGraphics.renderItem(new ItemStack((ItemLike)Items.BUCKET), guiLeft + this.getX() + 2, guiTop + this.getY() + 36);
        guiGraphics.renderItem(new ItemStack((ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK), guiLeft + this.getX() + 2, guiTop + this.getY() + 54);
        guiGraphics.renderItem(new ItemStack((ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK), guiLeft + this.getX() + 2, guiTop + this.getY() + 72);
        guiGraphics.blit(SubGuiBox.TEXTURE, guiLeft + this.getX() + 74, guiTop + this.getY() + 38, 0, 38, 22, 15);
        this.inputFluidAmounts.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.inputChemicalAmounts.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.outputFluidAmounts.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.outputChemicalAmounts.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTicks));
    }

    public boolean charTyped(char typedChar, int keyCode) {
        for (int i = 0; i < 2; ++i) {
            if (this.inputFluidAmounts.get(i).charTyped(typedChar, keyCode)) {
                String amount = this.inputFluidAmounts.get(i).getValue();
                ((ValueTypeRecipeChemicalLPElement)this.element).getInputFluids().set(i, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)((ValueTypeRecipeChemicalLPElement)this.element).getInputFluids().get(i).getLeft()), (Object)amount));
                ((ContainerLogicProgrammerBase)this.container).onDirty();
                IntegratedMekanism._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeChemicalValueChangedPacket(amount, LogicProgrammerValueTypeRecipeChemicalValueChangedPacket.Type.INPUT_FLUID, i));
                return true;
            }
            if (this.inputChemicalAmounts.get(i).charTyped(typedChar, keyCode)) {
                String amount = this.inputChemicalAmounts.get(i).getValue();
                ((ValueTypeRecipeChemicalLPElement)this.element).getInputChemicals().set(i, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)((ValueTypeRecipeChemicalLPElement)this.element).getInputChemicals().get(i).getLeft()), (Object)amount));
                ((ContainerLogicProgrammerBase)this.container).onDirty();
                IntegratedMekanism._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeChemicalValueChangedPacket(amount, LogicProgrammerValueTypeRecipeChemicalValueChangedPacket.Type.INPUT_CHEMICAL, i));
                return true;
            }
            if (this.outputFluidAmounts.get(i).charTyped(typedChar, keyCode)) {
                String amount = this.outputFluidAmounts.get(i).getValue();
                ((ValueTypeRecipeChemicalLPElement)this.element).getInputFluids().set(i, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)((ValueTypeRecipeChemicalLPElement)this.element).getInputFluids().get(i).getLeft()), (Object)amount));
                ((ContainerLogicProgrammerBase)this.container).onDirty();
                IntegratedMekanism._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeChemicalValueChangedPacket(amount, LogicProgrammerValueTypeRecipeChemicalValueChangedPacket.Type.OUTPUT_FLUID, i));
                return true;
            }
            if (!this.outputChemicalAmounts.get(i).charTyped(typedChar, keyCode)) continue;
            String amount = this.outputChemicalAmounts.get(i).getValue();
            ((ValueTypeRecipeChemicalLPElement)this.element).getInputChemicals().set(i, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)((ValueTypeRecipeChemicalLPElement)this.element).getInputChemicals().get(i).getLeft()), (Object)amount));
            ((ContainerLogicProgrammerBase)this.container).onDirty();
            IntegratedMekanism._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeChemicalValueChangedPacket(amount, LogicProgrammerValueTypeRecipeChemicalValueChangedPacket.Type.OUTPUT_CHEMICAL, i));
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        for (int i = 0; i < 2; ++i) {
            if (this.inputFluidAmounts.get(i).keyPressed(typedChar, keyCode, modifiers)) {
                String amount = this.inputFluidAmounts.get(i).getValue();
                ((ValueTypeRecipeChemicalLPElement)this.element).getInputFluids().set(i, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)((ValueTypeRecipeChemicalLPElement)this.element).getInputFluids().get(i).getLeft()), (Object)amount));
                ((ContainerLogicProgrammerBase)this.container).onDirty();
                IntegratedMekanism._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeChemicalValueChangedPacket(amount, LogicProgrammerValueTypeRecipeChemicalValueChangedPacket.Type.INPUT_FLUID, i));
                return true;
            }
            if (this.inputChemicalAmounts.get(i).keyPressed(typedChar, keyCode, modifiers)) {
                String amount = this.inputChemicalAmounts.get(i).getValue();
                ((ValueTypeRecipeChemicalLPElement)this.element).getInputChemicals().set(i, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)((ValueTypeRecipeChemicalLPElement)this.element).getInputChemicals().get(i).getLeft()), (Object)amount));
                ((ContainerLogicProgrammerBase)this.container).onDirty();
                IntegratedMekanism._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeChemicalValueChangedPacket(amount, LogicProgrammerValueTypeRecipeChemicalValueChangedPacket.Type.INPUT_CHEMICAL, i));
                return true;
            }
            if (this.outputFluidAmounts.get(i).keyPressed(typedChar, keyCode, modifiers)) {
                String amount = this.outputFluidAmounts.get(i).getValue();
                ((ValueTypeRecipeChemicalLPElement)this.element).getInputFluids().set(i, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)((ValueTypeRecipeChemicalLPElement)this.element).getInputFluids().get(i).getLeft()), (Object)amount));
                ((ContainerLogicProgrammerBase)this.container).onDirty();
                IntegratedMekanism._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeChemicalValueChangedPacket(amount, LogicProgrammerValueTypeRecipeChemicalValueChangedPacket.Type.OUTPUT_FLUID, i));
                return true;
            }
            if (!this.outputChemicalAmounts.get(i).keyPressed(typedChar, keyCode, modifiers)) continue;
            String amount = this.outputChemicalAmounts.get(i).getValue();
            ((ValueTypeRecipeChemicalLPElement)this.element).getInputChemicals().set(i, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)((ValueTypeRecipeChemicalLPElement)this.element).getInputChemicals().get(i).getLeft()), (Object)amount));
            ((ContainerLogicProgrammerBase)this.container).onDirty();
            IntegratedMekanism._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeChemicalValueChangedPacket(amount, LogicProgrammerValueTypeRecipeChemicalValueChangedPacket.Type.OUTPUT_CHEMICAL, i));
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return Streams.concat((Stream[])new Stream[]{this.inputFluidAmounts.stream(), this.inputChemicalAmounts.stream(), this.outputFluidAmounts.stream(), this.outputChemicalAmounts.stream()}).anyMatch(widget -> widget.mouseClicked(mouseX, mouseY, mouseButton)) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

