/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.modcompat.integratedtunnels.part;

import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.network.IChemicalNetwork;
import org.cyclops.integratedtunnels.core.part.IPartTypeInterfacePositionedAddon;

public class ChemicalHandlerPartState
implements IChemicalHandler {
    private final IPartTypeInterfacePositionedAddon.IState<IChemicalNetwork, IChemicalHandler, ?, ?> state;

    public ChemicalHandlerPartState(IPartTypeInterfacePositionedAddon.IState<IChemicalNetwork, IChemicalHandler, ?, ?> state) {
        this.state = state;
    }

    protected IChemicalHandler getChemicalHandler() {
        return (IChemicalHandler)((IChemicalNetwork)this.state.getPositionedAddonsNetwork()).getChannelExternal(Capabilities.CHEMICAL.block(), this.state.getChannel());
    }

    public int getChemicalTanks() {
        if (!this.state.isNetworkAndPositionValid()) {
            return 0;
        }
        this.state.disablePosition();
        int ret = this.getChemicalHandler().getChemicalTanks();
        this.state.enablePosition();
        return ret;
    }

    public ChemicalStack getChemicalInTank(int tank) {
        if (!this.state.isNetworkAndPositionValid()) {
            return ChemicalHandlerPartState.getEmptyStack();
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().getChemicalInTank(tank);
        this.state.enablePosition();
        return ret;
    }

    public long getChemicalTankCapacity(int tank) {
        if (!this.state.isNetworkAndPositionValid()) {
            return 0L;
        }
        this.state.disablePosition();
        long ret = this.getChemicalHandler().getChemicalTankCapacity(tank);
        this.state.enablePosition();
        return ret;
    }

    public ChemicalStack extractChemical(int tank, long l, Action action) {
        if (!this.state.isNetworkAndPositionValid()) {
            return ChemicalHandlerPartState.getEmptyStack();
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().extractChemical(tank, l, action);
        this.state.enablePosition();
        return ret;
    }

    public ChemicalStack insertChemical(int tank, ChemicalStack stack, Action action) {
        if (!this.state.isNetworkAndPositionValid()) {
            return stack;
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().insertChemical(tank, stack, action);
        this.state.enablePosition();
        return ret;
    }

    public boolean isValid(int tank, ChemicalStack stack) {
        if (!this.state.isNetworkAndPositionValid()) {
            return false;
        }
        this.state.disablePosition();
        boolean ret = this.getChemicalHandler().isValid(tank, stack);
        this.state.enablePosition();
        return ret;
    }

    public void setChemicalInTank(int tank, ChemicalStack stack) {
        if (this.state.isNetworkAndPositionValid()) {
            this.state.disablePosition();
            this.getChemicalHandler().setChemicalInTank(tank, stack);
            this.state.enablePosition();
        }
    }

    public ChemicalStack insertChemical(ChemicalStack stack, Action action) {
        if (!this.state.isNetworkAndPositionValid()) {
            return stack;
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().insertChemical(stack, action);
        this.state.enablePosition();
        return ret;
    }

    public ChemicalStack extractChemical(long amount, Action action) {
        if (!this.state.isNetworkAndPositionValid()) {
            return ChemicalHandlerPartState.getEmptyStack();
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().extractChemical(amount, action);
        this.state.enablePosition();
        return ret;
    }

    public ChemicalStack extractChemical(ChemicalStack stack, Action action) {
        if (!this.state.isNetworkAndPositionValid()) {
            return ChemicalHandlerPartState.getEmptyStack();
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().extractChemical(stack, action);
        this.state.enablePosition();
        return ret;
    }

    public static ChemicalStack getEmptyStack() {
        return (ChemicalStack)MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK.getMatcher().getEmptyInstance();
    }
}

