/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.modcompat.integratedtunnels.part;

import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.part.write.PartStateWriterBase;
import org.cyclops.integratedmekanism.Capabilities;
import org.cyclops.integratedmekanism.GeneralConfig;
import org.cyclops.integratedmekanism.network.IChemicalNetwork;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;

public class PartStateChemical<P extends IPartTypeWriter>
extends PartStatePositionedAddon<P, IChemicalNetwork, ChemicalStack> {
    public PartStateChemical(int inventorySize, boolean canReceive, boolean canExtract) {
        super(inventorySize, canReceive, canExtract);
    }

    public <T> Optional<T> getCapability(P partType, PartCapability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        if (capability == Capabilities.ChemicalHandler.PART) {
            return Optional.of(new Handler(this));
        }
        return super.getCapability(partType, capability, network, partNetwork, target);
    }

    public static class Handler
    implements IChemicalHandler {
        private final PartStateChemical partState;

        public Handler(PartStateChemical partState) {
            this.partState = partState;
        }

        protected IChemicalHandler getChemicalHandler() {
            return (IChemicalHandler)((IChemicalNetwork)this.partState.getPositionedAddonsNetwork()).getChannelExternal(Capabilities.CHEMICAL.block(), TunnelHelpers.getPassiveInteractionChannel((PartStateWriterBase)this.partState));
        }

        public int getChemicalTanks() {
            return this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null ? this.getChemicalHandler().getChemicalTanks() : 0;
        }

        public ChemicalStack getChemicalInTank(int tank) {
            if (this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null) {
                ChemicalStack chemicalStack = this.getChemicalHandler().getChemicalInTank(tank);
                if (this.partState.getStorageFilter().testView((Object)chemicalStack)) {
                    return chemicalStack;
                }
            }
            return Handler.getEmptyStack();
        }

        public void setChemicalInTank(int tank, ChemicalStack chemicalStack) {
            if (this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null && this.partState.getStorageFilter().testView((Object)chemicalStack)) {
                this.getChemicalHandler().setChemicalInTank(tank, chemicalStack);
            }
        }

        public long getChemicalTankCapacity(int tank) {
            return this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null ? this.getChemicalHandler().getChemicalTankCapacity(tank) : 0L;
        }

        public boolean isValid(int tank, ChemicalStack chemicalStack) {
            return this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null && this.partState.getStorageFilter().testInsertion((Object)chemicalStack) && this.getChemicalHandler().isValid(tank, chemicalStack);
        }

        protected ChemicalStack rateLimitFluid(ChemicalStack chemicalStack) {
            if (chemicalStack != null && chemicalStack.getAmount() > GeneralConfig.chemicalRateLimit) {
                chemicalStack = chemicalStack.copy();
                chemicalStack.setAmount(GeneralConfig.chemicalRateLimit);
                return chemicalStack;
            }
            return chemicalStack;
        }

        public ChemicalStack insertChemical(int tank, ChemicalStack chemicalStack, Action action) {
            return this.partState.canReceive() && this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null && this.partState.getStorageFilter().testInsertion((Object)chemicalStack) ? this.getChemicalHandler().insertChemical(this.rateLimitFluid(chemicalStack), action) : chemicalStack;
        }

        public ChemicalStack extractChemical(int tank, long maxDrain, Action action) {
            if (this.partState.canExtract() && this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null) {
                ChemicalStack drainedSimulated;
                PositionedAddonsNetworkIngredientsFilter filter = this.partState.getStorageFilter();
                if (action.execute() && !filter.testExtraction((Object)(drainedSimulated = this.getChemicalHandler().extractChemical(Math.min(maxDrain, GeneralConfig.chemicalRateLimit), Action.SIMULATE)))) {
                    return Handler.getEmptyStack();
                }
                ChemicalStack drained = this.getChemicalHandler().extractChemical(Math.min(maxDrain, GeneralConfig.chemicalRateLimit), action);
                if (action.simulate() && !filter.testExtraction((Object)drained)) {
                    return Handler.getEmptyStack();
                }
                return drained;
            }
            return Handler.getEmptyStack();
        }

        public static ChemicalStack getEmptyStack() {
            return ChemicalStack.EMPTY;
        }
    }
}

