/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.modcompat.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer.LogicProgrammerTransferHandler;
import org.cyclops.integratedmekanism.IntegratedMekanism;
import org.cyclops.integratedmekanism.logicprogrammer.ValueTypeRecipeChemicalLPElement;
import org.cyclops.integratedmekanism.network.packet.CPacketValueTypeRecipeChemicalLPElementSetRecipe;

public class LogicProgrammerTransferHandlerRecipeChemical<T extends ContainerLogicProgrammerBase>
extends LogicProgrammerTransferHandler<T> {
    public LogicProgrammerTransferHandlerRecipeChemical(Class<T> clazz) {
        super(clazz);
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, Object recipe, IRecipeSlotsView recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        ILogicProgrammerElement element = container.getActiveElement();
        if (element instanceof ValueTypeRecipeChemicalLPElement) {
            return this.handleRecipeChemicalElement((ValueTypeRecipeChemicalLPElement)element, container, recipeLayout, doTransfer);
        }
        return super.transferRecipe(container, recipe, recipeLayout, player, maxTransfer, doTransfer);
    }

    protected IRecipeTransferError handleRecipeChemicalElement(ValueTypeRecipeChemicalLPElement element, T container, IRecipeSlotsView recipeLayout, boolean doTransfer) {
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList fluidInputs = Lists.newArrayList();
        ArrayList chemicalInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        ArrayList fluidOutputs = Lists.newArrayList();
        ArrayList chemicalOutputs = Lists.newArrayList();
        for (IRecipeSlotView slotView : recipeLayout.getSlotViews()) {
            if (slotView.isEmpty()) {
                itemInputs.add(new ItemMatchProperties(ItemStack.EMPTY));
                continue;
            }
            ITypedIngredient typedIngredient = (ITypedIngredient)slotView.getAllIngredients().findFirst().get();
            if (typedIngredient.getType() == VanillaTypes.ITEM_STACK) {
                if (slotView.getRole() == RecipeIngredientRole.INPUT) {
                    ResourceLocation heuristicTag = this.getHeuristicItemsTag(slotView);
                    if (heuristicTag != null) {
                        itemInputs.add(new ItemMatchProperties(ItemStack.EMPTY, false, heuristicTag.toString(), ((ItemStack)typedIngredient.getIngredient()).getCount()));
                        continue;
                    }
                    itemInputs.add(new ItemMatchProperties(((ItemStack)typedIngredient.getIngredient()).copy()));
                    continue;
                }
                if (slotView.getRole() != RecipeIngredientRole.OUTPUT) continue;
                itemOutputs.add(((ItemStack)typedIngredient.getIngredient()).copy());
                continue;
            }
            if (typedIngredient.getType() == NeoForgeTypes.FLUID_STACK) {
                if (slotView.getRole() == RecipeIngredientRole.INPUT) {
                    fluidInputs.add(((FluidStack)typedIngredient.getIngredient()).copy());
                    continue;
                }
                if (slotView.getRole() != RecipeIngredientRole.OUTPUT) continue;
                fluidOutputs.add(((FluidStack)typedIngredient.getIngredient()).copy());
                continue;
            }
            if (typedIngredient.getType() != MekanismJEI.TYPE_CHEMICAL) continue;
            if (slotView.getRole() == RecipeIngredientRole.INPUT) {
                chemicalInputs.add(((ChemicalStack)typedIngredient.getIngredient()).copy());
                continue;
            }
            if (slotView.getRole() != RecipeIngredientRole.OUTPUT) continue;
            chemicalOutputs.add(((ChemicalStack)typedIngredient.getIngredient()).copy());
        }
        if (!element.isValidForRecipeGrid(itemInputs, fluidInputs, chemicalInputs, itemOutputs, fluidOutputs, chemicalOutputs)) {
            return new IRecipeTransferError(this){

                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.USER_FACING;
                }

                public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, IRecipeSlotsView recipeLayout, int recipeX, int recipeY) {
                    guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, Collections.singletonList(Component.translatable((String)"error.jei.integrateddynamics.recipetransfer.recipe.toobig.desc")), mouseX, mouseY);
                }
            };
        }
        if (doTransfer) {
            element.setRecipeGrid((ContainerLogicProgrammerBase)container, itemInputs, fluidInputs, chemicalInputs, itemOutputs, fluidOutputs, chemicalOutputs);
            IntegratedMekanism._instance.getPacketHandler().sendToServer((PacketBase)new CPacketValueTypeRecipeChemicalLPElementSetRecipe(((ContainerLogicProgrammerBase)container).containerId, itemInputs, fluidInputs, chemicalInputs, itemOutputs, fluidOutputs, chemicalOutputs));
        }
        return null;
    }
}

