/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.network;

import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datamaps.chemical.attribute.ChemicalRadioactivity;
import mekanism.api.radiation.IRadiationManager;
import mekanism.common.registries.MekanismDataMapTypes;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.PositionedAddonsNetworkIngredients;
import org.cyclops.integratedmekanism.GeneralConfig;
import org.cyclops.integratedmekanism.network.IChemicalNetwork;
import org.jetbrains.annotations.Nullable;

public class ChemicalNetwork
extends PositionedAddonsNetworkIngredients<ChemicalStack, Integer>
implements IChemicalNetwork {
    public ChemicalNetwork(IngredientComponent<ChemicalStack, Integer> component) {
        super(component);
    }

    public long getRateLimit() {
        return GeneralConfig.chemicalRateLimit;
    }

    @Nullable
    public PositionedAddonsNetworkIngredientsFilter<ChemicalStack> getPositionedStorageFilter(PartPos pos) {
        PositionedAddonsNetworkIngredientsFilter superFilter = super.getPositionedStorageFilter(pos);
        if (GeneralConfig.transferRadioactiveChemicals || !IRadiationManager.INSTANCE.isRadiationEnabled()) {
            return superFilter;
        }
        return new PositionedAddonsNetworkIngredientsFilter(chemicalStack -> {
            @Nullable ChemicalRadioactivity attribute = (ChemicalRadioactivity)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.chemicalRadioactivity());
            return !(attribute != null && attribute.radioactivity() != 0.0 || superFilter != null && !superFilter.getFilter().test(chemicalStack));
        }, true, true, superFilter == null || superFilter.isAllowAllIfFilterNotApplied());
    }
}

