/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.network.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integratedmekanism.logicprogrammer.ValueTypeRecipeChemicalLPElement;

public class LogicProgrammerValueTypeRecipeChemicalValueChangedPacket
extends PacketCodec<LogicProgrammerValueTypeRecipeChemicalValueChangedPacket> {
    public static final CustomPacketPayload.Type<LogicProgrammerValueTypeRecipeChemicalValueChangedPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedmekanism", (String)"lp_valuetype_recipe_chemical_value_changed"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LogicProgrammerValueTypeRecipeChemicalValueChangedPacket> CODEC = LogicProgrammerValueTypeRecipeChemicalValueChangedPacket.getCodec(LogicProgrammerValueTypeRecipeChemicalValueChangedPacket::new);
    @CodecField
    private String value;
    @CodecField
    private int type;
    @CodecField
    private int slot;

    public LogicProgrammerValueTypeRecipeChemicalValueChangedPacket() {
        super(ID);
    }

    public LogicProgrammerValueTypeRecipeChemicalValueChangedPacket(String value, Type type, int slot) {
        super(ID);
        this.value = value;
        this.type = type.ordinal();
        this.slot = slot;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ILogicProgrammerElement element;
        if (player.containerMenu instanceof ContainerLogicProgrammerBase && (element = ((ContainerLogicProgrammerBase)player.containerMenu).getActiveElement()) instanceof ValueTypeRecipeChemicalLPElement) {
            ValueTypeRecipeChemicalLPElement elementCast = (ValueTypeRecipeChemicalLPElement)element;
            Type type = Type.values()[this.type];
            switch (type.ordinal()) {
                case 0: {
                    elementCast.getInputFluids().set(this.slot, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)elementCast.getInputFluids().get(this.slot).getLeft()), (Object)this.value));
                    break;
                }
                case 1: {
                    elementCast.getInputChemicals().set(this.slot, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)elementCast.getInputChemicals().get(this.slot).getLeft()), (Object)this.value));
                    break;
                }
                case 2: {
                    elementCast.getOutputFluids().set(this.slot, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)elementCast.getOutputFluids().get(this.slot).getLeft()), (Object)this.value));
                    break;
                }
                case 3: {
                    elementCast.getOutputChemicals().set(this.slot, (Pair<ItemStack, String>)Pair.of((Object)((ItemStack)elementCast.getOutputChemicals().get(this.slot).getLeft()), (Object)this.value));
                }
            }
            ((ContainerLogicProgrammerBase)player.containerMenu).onDirty();
        }
    }

    public static enum Type {
        INPUT_FLUID,
        INPUT_CHEMICAL,
        OUTPUT_FLUID,
        OUTPUT_CHEMICAL;

    }
}

