/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.capability.recipehandler;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaRecipeTypeRecipeHandler;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.jetbrains.annotations.Nullable;

public abstract class MekanismRecipeHandler<R extends MekanismRecipe<?>>
implements IRecipeHandler {
    private final IMekanismRecipeTypeProvider<?, ? extends R, ?> recipeType;
    private final Supplier<Level> levelSupplier;
    private final Set<IngredientComponent<?, ?>> inputComponents;
    private final Set<IngredientComponent<?, ?>> outputComponents;
    public static Map<IMekanismRecipeTypeProvider<?, ?, ?>, Collection<IRecipeDefinition>> CACHED_RECIPES = Maps.newHashMap();

    protected MekanismRecipeHandler(IMekanismRecipeTypeProvider<?, ? extends R, ?> recipeType, Supplier<Level> levelSupplier, Set<IngredientComponent<?, ?>> inputComponents, Set<IngredientComponent<?, ?>> outputComponents) {
        this.recipeType = recipeType;
        this.levelSupplier = levelSupplier;
        this.inputComponents = inputComponents;
        this.outputComponents = outputComponents;
    }

    public IMekanismRecipeTypeProvider<?, ? extends R, ?> getRecipeType() {
        return this.recipeType;
    }

    public Level getLevel() {
        return this.levelSupplier.get();
    }

    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return this.inputComponents;
    }

    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return this.outputComponents;
    }

    public final Collection<IRecipeDefinition> getRecipes() {
        Collection<IRecipeDefinition> cached = CACHED_RECIPES.get(this.getRecipeType());
        if (cached == null) {
            cached = this.getRecipesUncached();
            CACHED_RECIPES.put(this.getRecipeType(), cached);
        }
        return cached;
    }

    public Collection<IRecipeDefinition> getRecipesUncached() {
        return this.recipeType.getRecipes(this.getLevel()).stream().filter(this::isValid).map(recipeHolder -> {
            IdentityHashMap inputs = Maps.newIdentityHashMap();
            this.recipeToInputs((MekanismRecipe)recipeHolder.value(), inputs);
            IdentityHashMap outputs = Maps.newIdentityHashMap();
            this.recipeToOutputs((MekanismRecipe)recipeHolder.value(), outputs);
            return new RecipeDefinition((Map)inputs, (IMixedIngredients)new MixedIngredients((Map)outputs));
        }).toList();
    }

    protected boolean isValid(RecipeHolder<? extends R> recipe) {
        return true;
    }

    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        for (IngredientComponent<?, ?> recipeInputComponent : this.getRecipeInputComponents()) {
            if (this.isValidSizeInput(recipeInputComponent, input.getInstances(recipeInputComponent).size())) continue;
            return null;
        }
        @Nullable MekanismRecipe recipe = this.recipeType.findFirst(this.getLevel(), pRecipe -> this.doesRecipeMatchInput(pRecipe, input));
        if (recipe != null) {
            IdentityHashMap outputs = Maps.newIdentityHashMap();
            this.recipeToOutputsSimulated(recipe, input, outputs);
            return new MixedIngredients((Map)outputs);
        }
        return null;
    }

    protected abstract void recipeToInputs(R var1, Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> var2);

    protected abstract void recipeToOutputs(R var1, Map<IngredientComponent<?, ?>, List<?>> var2);

    protected abstract void recipeToOutputsSimulated(R var1, IMixedIngredients var2, Map<IngredientComponent<?, ?>, List<?>> var3);

    protected abstract boolean doesRecipeMatchInput(R var1, IMixedIngredients var2);

    public static List<IPrototypedIngredient<ChemicalStack, Integer>> getPrototypesFromChemicalIngredient(ChemicalStackIngredient ingredient) {
        return ingredient.getRepresentations().stream().map(stack -> new PrototypedIngredient(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, stack, (Object)1)).collect(Collectors.toList());
    }

    public static List<IPrototypedIngredient<ItemStack, Integer>> getPrototypesFromItemIngredient(InputIngredient<ItemStack> ingredient) {
        if (ingredient instanceof ItemStackIngredient) {
            ItemStackIngredient ingredientCast = (ItemStackIngredient)ingredient;
            return VanillaRecipeTypeRecipeHandler.getPrototypesFromIngredient((SizedIngredient)ingredientCast.ingredient());
        }
        return ingredient.getRepresentations().stream().map(stack -> new PrototypedIngredient(IngredientComponents.ITEMSTACK, stack, (Object)1)).collect(Collectors.toList());
    }

    public static List<IPrototypedIngredient<FluidStack, Integer>> getPrototypesFromFluidIngredient(InputIngredient<FluidStack> ingredient) {
        return ingredient.getRepresentations().stream().map(stack -> new PrototypedIngredient(IngredientComponents.FLUIDSTACK, stack, (Object)1)).collect(Collectors.toList());
    }
}

