/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.core;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.registries.MekanismChemicals;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedmekanism.core.predicate.IngredientPredicateChemicalStackList;
import org.cyclops.integratedmekanism.core.predicate.IngredientPredicateChemicalStackOperator;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;

public class ChemicalHelpers {
    public static final long BUCKET_VOLUME = 1000L;
    public static final IngredientPredicate<ChemicalStack, Integer> MATCH_NONE = new IngredientPredicate<ChemicalStack, Integer>(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, ChemicalStack.EMPTY, Integer.valueOf(3), false, true, 0, false){

        public boolean test(ChemicalStack input) {
            return false;
        }

        public boolean equals(Object obj) {
            return obj == MATCH_NONE;
        }

        public int hashCode() {
            return 9991029;
        }
    };

    public static DefaultedRegistry<Chemical> getStackRegistry() {
        return MekanismAPI.CHEMICAL_REGISTRY;
    }

    public static IngredientPredicate<ChemicalStack, Integer> matchAll(long amount, boolean exactAmount) {
        return new IngredientPredicate<ChemicalStack, Integer>(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, amount), Integer.valueOf(exactAmount ? 2 : 0), false, false, (int)amount, exactAmount){

            public boolean test(ChemicalStack input) {
                return true;
            }
        };
    }

    protected static int getChemicalStackMatchFlags(boolean checkChemical, boolean checkAmount) {
        int matchFlags = 0;
        if (checkChemical) {
            matchFlags |= 1;
        }
        if (checkAmount) {
            matchFlags |= 2;
        }
        return matchFlags;
    }

    public static IngredientPredicate<ChemicalStack, Integer> matchChemicalStack(final ChemicalStack chemicalStack, final boolean checkChemical, final boolean checkAmount, final boolean blacklist, boolean exactAmount) {
        return new IngredientPredicate<ChemicalStack, Integer>(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, chemicalStack != null ? chemicalStack.copy() : null, Integer.valueOf(ChemicalHelpers.getChemicalStackMatchFlags(checkChemical, checkAmount)), blacklist, chemicalStack == null && !blacklist, chemicalStack == null ? 0 : (int)chemicalStack.getAmount(), exactAmount){

            public boolean test(@Nullable ChemicalStack input) {
                boolean result = ChemicalHelpers.areChemicalStackEqual(input, chemicalStack, checkChemical, checkAmount);
                if (blacklist) {
                    result = !result;
                }
                return result;
            }
        };
    }

    public static IngredientPredicate<ChemicalStack, Integer> matchChemicalStacks(IValueTypeListProxy<ValueObjectTypeChemicalStack, ValueObjectTypeChemicalStack.ValueChemicalStack> chemicalStacks, boolean checkChemical, boolean checkAmount, boolean blacklist, long amount, boolean exactAmount) {
        return new IngredientPredicateChemicalStackList(blacklist, amount, exactAmount, chemicalStacks, ChemicalHelpers.getChemicalStackMatchFlags(checkChemical, checkAmount), checkChemical, checkAmount);
    }

    public static IngredientPredicate<ChemicalStack, Integer> matchPredicate(PartTarget partTarget, IOperator predicate, long amount, boolean exactAmount) {
        return new IngredientPredicateChemicalStackOperator(amount, exactAmount, predicate, partTarget);
    }

    public static boolean areChemicalStackEqual(ChemicalStack stackA, ChemicalStack stackB, boolean checkChemical, boolean checkAmount) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            if (checkAmount && stackA.getAmount() != stackB.getAmount()) {
                return false;
            }
            return !checkChemical || stackA.getChemical() == stackB.getChemical();
        }
        return false;
    }

    public static ChemicalStack prototypeWithCount(ChemicalStack prototype, long count) {
        if (prototype == null || prototype.getAmount() != count) {
            if (prototype == null || prototype.isEmpty()) {
                return count == 0L ? null : new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, count);
            }
            prototype = prototype.copy();
            prototype.setAmount(count);
        }
        return prototype;
    }

    public static Stream<ChemicalStack> getChemicalTagValues(String name) throws ResourceLocationException {
        return MekanismAPI.CHEMICAL_REGISTRY.getTag(TagKey.create((ResourceKey)MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)ResourceLocation.parse((String)name))).stream().flatMap(chemicals -> chemicals.stream().map(chemical -> new ChemicalStack(chemical, 1000L)));
    }
}

