/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest;

import mekanism.api.RelativeSide;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedmekanism.modcompat.integratedtunnels.aspect.MekanismTunnelsAspects;
import org.cyclops.integratedmekanism.modcompat.integratedtunnels.part.PartTypesMekanismTunnels;
import org.cyclops.integratedmekanism.value.MekanismValueTypes;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders;

@GameTestHolder(value="integratedmekanism")
@PrefixGameTestTemplate(value=false)
public class GameTestsTunnelChemical {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final int TIMEOUT = 3000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    public static TileEntityChemicalTank setTank(GameTestHelper helper, BlockPos pos) {
        helper.setBlock(pos, (Block)MekanismBlocks.BASIC_CHEMICAL_TANK.get());
        TileEntityChemicalTank chemicalTank = (TileEntityChemicalTank)helper.getBlockEntity(pos);
        for (RelativeSide relativeSide : RelativeSide.values()) {
            chemicalTank.getConfig().getConfig(TransmissionType.CHEMICAL).setDataType(DataType.INPUT_OUTPUT, relativeSide);
        }
        return chemicalTank;
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalImporterToInterfaceBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank out does not contain chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank in was not drained");
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), "Importer is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status is incorrect");
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT, "Active aspect is incorrect");
            helper.assertTrue(partStateWriter.getErrors(MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT).isEmpty(), "Active aspect has errors");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.EXPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.EXPORTER_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank out does not contain chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank in was not drained");
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), "Exporter is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypesMekanismTunnels.EXPORTER_CHEMICAL.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status is incorrect");
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_EXPORT, "Active aspect is incorrect");
            helper.assertTrue(partStateWriter.getErrors(MekanismTunnelsAspects.Write.Chemical.BOOLEAN_EXPORT).isEmpty(), "Active aspect has errors");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalImporterToInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypesMekanismTunnels.EXPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.EXPORTER_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankInterface = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().north());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectExporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_EXPORT, (ItemStack)variableAspectExporter);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankInterface.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank interface was not drained");
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank out does not contain chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank in was not drained");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalsImporterToInterfaceChemicalCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 100L)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.CHEMICALSTACK_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank out does not contain chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank in was not drained");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalsImporterToInterfaceChemicalIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.GOLD, 100L)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.CHEMICALSTACK_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank out was filled");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank in was drained");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalsImporterToFilteredInterfaceBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_FILTERING_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_FILTERING_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectInterface = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), MekanismTunnelsAspects.Write.ChemicalFilter.BOOLEAN_SET_FILTER, (ItemStack)variableAspectInterface);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank out does not contain chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank in was not drained");
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), "Importer is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status importer is incorrect");
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT, "Active aspect importer is incorrect");
            helper.assertTrue(partStateWriter.getErrors(MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT).isEmpty(), "Active aspect importer has errors");
            IPartStateWriter partStateInterface = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateInterface.isDeactivated(), "Filtering interface is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypesMekanismTunnels.INTERFACE_FILTERING_CHEMICAL.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status filtering interface is incorrect");
            helper.assertValueEqual((Object)partStateInterface.getActiveAspect(), MekanismTunnelsAspects.Write.ChemicalFilter.BOOLEAN_SET_FILTER, "Active aspect filtering interface is incorrect");
            helper.assertTrue(partStateInterface.getErrors(MekanismTunnelsAspects.Write.ChemicalFilter.BOOLEAN_SET_FILTER).isEmpty(), "Active aspect filtering interface has errors");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalsImporterToFilteredInterfaceChemicalCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_FILTERING_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_FILTERING_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectInterface = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 100L)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), MekanismTunnelsAspects.Write.ChemicalFilter.CHEMICALSTACK_SET_FILTER, (ItemStack)variableAspectInterface);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank out does not contain chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank in was not drained");
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), "Importer is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status importer is incorrect");
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT, "Active aspect importer is incorrect");
            helper.assertTrue(partStateWriter.getErrors(MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT).isEmpty(), "Active aspect importer has errors");
            IPartStateWriter partStateInterface = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateInterface.isDeactivated(), "Filtering interface is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypesMekanismTunnels.INTERFACE_FILTERING_CHEMICAL.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status filtering interface is incorrect");
            helper.assertValueEqual((Object)partStateInterface.getActiveAspect(), MekanismTunnelsAspects.Write.ChemicalFilter.CHEMICALSTACK_SET_FILTER, "Active aspect filtering interface is incorrect");
            helper.assertTrue(partStateInterface.getErrors(MekanismTunnelsAspects.Write.ChemicalFilter.CHEMICALSTACK_SET_FILTER).isEmpty(), "Active aspect filtering interface has errors");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalsImporterToFilteredInterfaceChemicalIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_FILTERING_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_FILTERING_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectInterface = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.GOLD, 100L)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), MekanismTunnelsAspects.Write.ChemicalFilter.CHEMICALSTACK_SET_FILTER, (ItemStack)variableAspectInterface);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank out contains chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank in was drained");
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), "Importer is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status importer is incorrect");
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT, "Active aspect importer is incorrect");
            helper.assertTrue(partStateWriter.getErrors(MekanismTunnelsAspects.Write.Chemical.BOOLEAN_IMPORT).isEmpty(), "Active aspect importer has errors");
            IPartStateWriter partStateInterface = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateInterface.isDeactivated(), "Filtering interface is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypesMekanismTunnels.INTERFACE_FILTERING_CHEMICAL.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status filtering interface is incorrect");
            helper.assertValueEqual((Object)partStateInterface.getActiveAspect(), MekanismTunnelsAspects.Write.ChemicalFilter.CHEMICALSTACK_SET_FILTER, "Active aspect filtering interface is incorrect");
            helper.assertTrue(partStateInterface.getErrors(MekanismTunnelsAspects.Write.ChemicalFilter.CHEMICALSTACK_SET_FILTER).isEmpty(), "Active aspect filtering interface has errors");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalsImporterToInterfaceChemicalListCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeChemicalStack.ValueChemicalStack[]{ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.GOLD, 100L)), ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 100L))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.LIST_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank out does not contain chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank in was not drained");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalsImporterToInterfaceChemicalListIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspectImporter = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeChemicalStack.ValueChemicalStack[]{ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.GOLD, 100L)), ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.BIO, 100L))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.LIST_IMPORT, (ItemStack)variableAspectImporter);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank out contains chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank in was drained");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalsImporterToInterfaceChemicalListBlacklistCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeChemicalStack.ValueChemicalStack[]{ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.GOLD, 100L)), ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.BIO, 100L))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.LIST_IMPORT, (ItemStack)variableAspect);
        PartPos posImporter = PartPos.of((DimPos)DimPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS)), (Direction)Direction.WEST);
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)posImporter);
        IAspectProperties properties = MekanismTunnelsAspects.Write.Chemical.LIST_IMPORT.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)posImporter), partStateHolder.getState());
        properties.setValue(TunnelAspectWriteBuilders.PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
        partStateHolder.getState().setAspectProperties(MekanismTunnelsAspects.Write.Chemical.LIST_IMPORT, properties);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank out does not contain chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank in was not drained");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalsImporterToInterfaceChemicalListBlacklistIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn = GameTestsTunnelChemical.setTank(helper, POS.west());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeChemicalStack.ValueChemicalStack[]{ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 100L)), ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.GOLD, 100L))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.Chemical.LIST_IMPORT, (ItemStack)variableAspect);
        PartPos posImporter = PartPos.of((DimPos)DimPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS)), (Direction)Direction.WEST);
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)posImporter);
        IAspectProperties properties = MekanismTunnelsAspects.Write.Chemical.LIST_IMPORT.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)posImporter), partStateHolder.getState());
        properties.setValue(TunnelAspectWriteBuilders.PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
        partStateHolder.getState().setAspectProperties(MekanismTunnelsAspects.Write.Chemical.LIST_IMPORT, properties);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank out contains chemicals");
            helper.assertValueEqual((Object)tankIn.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank in was drained");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalInterfaceToExporterChemicalFromSubnet(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.EXPORTER_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.EXPORTER_CHEMICAL.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.west()), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.west()), (Direction)Direction.NORTH, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.west()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        TileEntityChemicalTank tankIn1 = GameTestsTunnelChemical.setTank(helper, POS.west().west());
        TileEntityChemicalTank tankIn2 = GameTestsTunnelChemical.setTank(helper, POS.west().north());
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        tankIn1.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        tankIn2.getChemicalTank().setStack(new ChemicalStack((Holder)MekanismChemicals.GOLD, 1000L));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.GOLD, 100L)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), MekanismTunnelsAspects.Write.Chemical.CHEMICALSTACK_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank out does not contain chemicals");
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getChemical(), (Object)((Chemical)MekanismChemicals.GOLD.value()), "Tank out does not contain the correct chemical type");
            helper.assertValueEqual((Object)tankIn1.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank in 1 was incorrectly drained");
            helper.assertValueEqual((Object)tankIn2.getChemicalTank().getStack().getAmount(), (Object)0L, "Tank in 2 was not drained");
        });
    }

    @GameTest(template="empty10", timeoutTicks=3000)
    public void testChemicalWorldImporterToInterfaceBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypesMekanismTunnels.IMPORTER_WORLD_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypesMekanismTunnels.INTERFACE_CHEMICAL, (ItemStack)new ItemStack((ItemLike)PartTypesMekanismTunnels.INTERFACE_CHEMICAL.getItem()));
        ItemStack tankIn = helper.spawnItem(MekanismBlocks.BASIC_CHEMICAL_TANK.asItem(), POS.west()).getItem();
        TileEntityChemicalTank tankOut = GameTestsTunnelChemical.setTank(helper, POS.east().east());
        ((IChemicalHandler)tankIn.getCapability(Capabilities.CHEMICAL.item())).setChemicalInTank(0, new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), MekanismTunnelsAspects.Write.World.ENTITY_CHEMICAL_BOOLEAN_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)tankOut.getChemicalTank().getStack().getAmount(), (Object)1000L, "Tank out does not contain chemicals");
            helper.assertValueEqual((Object)((IChemicalHandler)tankIn.getCapability(Capabilities.CHEMICAL.item())).getChemicalInTank(0).getAmount(), (Object)0L, "Tank in was not drained");
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), "Importer is deactivated");
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypesMekanismTunnels.IMPORTER_CHEMICAL.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, "Block status is incorrect");
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), MekanismTunnelsAspects.Write.World.ENTITY_CHEMICAL_BOOLEAN_IMPORT, "Active aspect is incorrect");
            helper.assertTrue(partStateWriter.getErrors(MekanismTunnelsAspects.Write.World.ENTITY_CHEMICAL_BOOLEAN_IMPORT).isEmpty(), "Active aspect has errors");
        });
    }
}

