/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest.integration;

import mekanism.api.chemical.ChemicalStack;
import mekanism.api.text.EnumColor;
import mekanism.common.registration.impl.SlurryRegistryObject;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.resource.PrimaryResource;
import net.minecraft.core.Holder;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.core.test.TestHelpers;
import org.cyclops.integratedmekanism.gametest.integration.Asserts;
import org.cyclops.integratedmekanism.gametest.integration.DummyValueType;
import org.cyclops.integratedmekanism.gametest.integration.DummyVariable;
import org.cyclops.integratedmekanism.gametest.integration.DummyVariableChemicalStack;
import org.cyclops.integratedmekanism.operator.MekanismOperators;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;

public class TestChemicalStackOperators {
    private static final DummyValueType DUMMY_TYPE = DummyValueType.TYPE;
    private static final DummyVariable<DummyValueType.DummyValue> DUMMY_VARIABLE = new DummyVariable<DummyValueType.DummyValue>(DUMMY_TYPE, DummyValueType.DummyValue.of());
    private DummyVariableChemicalStack eHydrogen;
    private DummyVariableChemicalStack eHydrogen100;
    private DummyVariableChemicalStack eSteam;
    private DummyVariableChemicalStack eGold;
    private DummyVariableChemicalStack ePlutonium;
    private DummyVariableChemicalStack eSodium;
    private DummyVariableChemicalStack eSodiumSuperheated;
    private DummyVariableChemicalStack eRed;
    private DummyVariableChemicalStack eIron;
    private DummyVariable<ValueTypeLong.ValueLong> l100;
    private DummyVariable<ValueTypeString.ValueString> sWaterVapor;

    @IntegrationBefore
    public void before() {
        this.eHydrogen = new DummyVariableChemicalStack(ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L)));
        this.eHydrogen100 = new DummyVariableChemicalStack(ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 100L)));
        this.eSteam = new DummyVariableChemicalStack(ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.STEAM, 1000L)));
        this.eGold = new DummyVariableChemicalStack(ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.GOLD, 1000L)));
        this.ePlutonium = new DummyVariableChemicalStack(ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.PLUTONIUM, 1000L)));
        this.eSodium = new DummyVariableChemicalStack(ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.SODIUM, 1000L)));
        this.eSodiumSuperheated = new DummyVariableChemicalStack(ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.SUPERHEATED_SODIUM, 1000L)));
        this.eRed = new DummyVariableChemicalStack(ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)MekanismChemicals.PIGMENT_COLOR_LOOKUP.get(EnumColor.RED), 1000L)));
        this.eIron = new DummyVariableChemicalStack(ValueObjectTypeChemicalStack.ValueChemicalStack.of(new ChemicalStack((Holder)((SlurryRegistryObject)MekanismChemicals.PROCESSED_RESOURCES.get(PrimaryResource.IRON)).getCleanSlurry(), 1000L)));
        this.l100 = new DummyVariable<ValueTypeLong.ValueLong>((IValueType<ValueTypeLong.ValueLong>)ValueTypes.LONG, ValueTypeLong.ValueLong.of((long)100L));
        this.sWaterVapor = new DummyVariable<ValueTypeString.ValueString>((IValueType<ValueTypeString.ValueString>)ValueTypes.STRING, ValueTypeString.ValueString.of((String)"mekanism:water_vapor"));
    }

    @IntegrationTest
    public void testAmount() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_AMOUNT.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeLong.ValueLong, "result is a long");
        TestHelpers.assertEqual((Object)((ValueTypeLong.ValueLong)res1).getRawValue(), (Object)1000L, (String)"amount(hydrogen:1000) = 1000");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_AMOUNT.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeLong.ValueLong)res2).getRawValue(), (Object)1000L, (String)"amount(gold:1000) = 1000");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_AMOUNT.evaluate(new IVariable[]{this.eHydrogen100});
        TestHelpers.assertEqual((Object)((ValueTypeLong.ValueLong)res3).getRawValue(), (Object)100L, (String)"amount(hydrogen:100) = 100");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeAmountLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_AMOUNT.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeAmountSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_AMOUNT.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeAmount() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_AMOUNT.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testTint() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_TINT.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual((Object)((ValueTypeInteger.ValueInteger)res1).getRawValue(), (Object)-1, (String)"tint(hydrogen) = -1");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_TINT.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeInteger.ValueInteger)res2).getRawValue(), (Object)15912295, (String)"tint(gold) = 15912295");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTintLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_TINT.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTintSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_TINT.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTint() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_TINT.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testIsRadioactive() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_ISRADIOACTIVE.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), (Object)false, (String)"isradioactive(hydrogen) = false");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_ISRADIOACTIVE.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), (Object)false, (String)"isradioactive(gold) = false");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_ISRADIOACTIVE.evaluate(new IVariable[]{this.ePlutonium});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), (Object)true, (String)"isradioactive(plutonium) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsRadioactiveLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISRADIOACTIVE.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsRadioactiveSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISRADIOACTIVE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsRadioactive() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISRADIOACTIVE.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testRadioactivity() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_RADIOACTIVITY.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeDouble.ValueDouble, "result is a double");
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res1).getRawValue(), (Object)0.0, (String)"radioactivity(hydrogen) = 0");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_RADIOACTIVITY.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res2).getRawValue(), (Object)0.0, (String)"radioactivity(gold) = 0");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_RADIOACTIVITY.evaluate(new IVariable[]{this.ePlutonium});
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res3).getRawValue(), (Object)0.02, (String)"radioactivity(plutonium) = 0.02");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeRadioactivityLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_RADIOACTIVITY.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeRadioactivitySmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_RADIOACTIVITY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeRadioactivity() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_RADIOACTIVITY.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testIsCoolant() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLANT.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), (Object)false, (String)"iscoolant(hydrogen) = false");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLANT.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), (Object)false, (String)"iscoolant(gold) = false");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLANT.evaluate(new IVariable[]{this.eSodium});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), (Object)true, (String)"iscoolant(sodium) = true");
        IValue res4 = MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLANT.evaluate(new IVariable[]{this.eSodiumSuperheated});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res4).getRawValue(), (Object)true, (String)"iscoolant(sodiumSuperheated) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsCoolantLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLANT.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsCoolantSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLANT.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsCoolant() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLANT.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testThermalEnthalpy() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_THERMALENTHALPY.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeDouble.ValueDouble, "result is a double");
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res1).getRawValue(), (Object)0.0, (String)"thermalenthalpy(hydrogen) = 0");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_THERMALENTHALPY.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res2).getRawValue(), (Object)0.0, (String)"thermalenthalpy(gold) = 0");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_THERMALENTHALPY.evaluate(new IVariable[]{this.eSodium});
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res3).getRawValue(), (Object)5.0, (String)"thermalenthalpy(sodium) = 5.0");
        IValue res4 = MekanismOperators.OBJECT_CHEMICALSTACK_THERMALENTHALPY.evaluate(new IVariable[]{this.eSodiumSuperheated});
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res4).getRawValue(), (Object)5.0, (String)"thermalenthalpy(sodiumSuperheated) = 5.0");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeThermalEnthalpyLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_THERMALENTHALPY.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeThermalEnthalpySmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_THERMALENTHALPY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeThermalEnthalpy() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_THERMALENTHALPY.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testConductivity() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_CONDUCTIVITY.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeDouble.ValueDouble, "result is a double");
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res1).getRawValue(), (Object)0.0, (String)"conductivity(hydrogen) = 0");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_CONDUCTIVITY.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res2).getRawValue(), (Object)0.0, (String)"conductivity(gold) = 0");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_CONDUCTIVITY.evaluate(new IVariable[]{this.eSodium});
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res3).getRawValue(), (Object)5.0, (String)"conductivity(sodium) = 1.0");
        IValue res4 = MekanismOperators.OBJECT_CHEMICALSTACK_CONDUCTIVITY.evaluate(new IVariable[]{this.eSodiumSuperheated});
        TestHelpers.assertEqual((Object)((ValueTypeDouble.ValueDouble)res4).getRawValue(), (Object)5.0, (String)"conductivity(sodiumSuperheated) = 1.0");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeConductivityLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_CONDUCTIVITY.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeConductivitySmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_CONDUCTIVITY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeConductivity() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_CONDUCTIVITY.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testIsCooledCoolant() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLEDCOOLANT.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), (Object)false, (String)"iscooledcoolant(hydrogen) = false");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLEDCOOLANT.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), (Object)false, (String)"iscooledcoolant(gold) = false");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLEDCOOLANT.evaluate(new IVariable[]{this.eSodium});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), (Object)true, (String)"iscooledcoolant(sodium) = true");
        IValue res4 = MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLEDCOOLANT.evaluate(new IVariable[]{this.eSodiumSuperheated});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res4).getRawValue(), (Object)false, (String)"iscooledcoolant(sodiumSuperheated) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsCooledCoolantLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLEDCOOLANT.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsCooledCoolantSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLEDCOOLANT.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsCooledCoolant() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISCOOLEDCOOLANT.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testCooledCoolantOf() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_COOLEDCOOLANTOF.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueObjectTypeChemicalStack.ValueChemicalStack, "result is a chemical");
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res1).getRawValue().isEmpty(), (Object)true, (String)"cooledcoolantof(hydrogen) = empty");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_COOLEDCOOLANTOF.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res2).getRawValue().isEmpty(), (Object)true, (String)"cooledcoolantof(gold) = empty");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_COOLEDCOOLANTOF.evaluate(new IVariable[]{this.eSodium});
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res3).getRawValue().equals((Object)new ChemicalStack((Holder)MekanismChemicals.SUPERHEATED_SODIUM, 1000L)), (Object)true, (String)"cooledcoolantof(sodiumSuperheated) = true");
        IValue res4 = MekanismOperators.OBJECT_CHEMICALSTACK_COOLEDCOOLANTOF.evaluate(new IVariable[]{this.eSodiumSuperheated});
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res4).getRawValue().isEmpty(), (Object)true, (String)"cooledcoolantof(sodiumSuperheated) = empty");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeCooledCoolantOfLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_COOLEDCOOLANTOF.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeCooledCoolantOfSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_COOLEDCOOLANTOF.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeCooledCoolantOf() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_COOLEDCOOLANTOF.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testIsHeatedCoolant() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_ISHEATEDCOOLANT.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), (Object)false, (String)"isheatedcoolant(hydrogen) = false");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_ISHEATEDCOOLANT.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), (Object)false, (String)"isheatedcoolant(gold) = false");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_ISHEATEDCOOLANT.evaluate(new IVariable[]{this.eSodium});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), (Object)false, (String)"isheatedcoolant(sodium) = false");
        IValue res4 = MekanismOperators.OBJECT_CHEMICALSTACK_ISHEATEDCOOLANT.evaluate(new IVariable[]{this.eSodiumSuperheated});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res4).getRawValue(), (Object)true, (String)"isheatedcoolant(sodiumSuperheated) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsHeatedCoolantLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISHEATEDCOOLANT.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsHeatedCoolantSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISHEATEDCOOLANT.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsHeatedCoolant() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISHEATEDCOOLANT.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testHeatedCoolantOf() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_HEATEDCOOLANTOF.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueObjectTypeChemicalStack.ValueChemicalStack, "result is a chemical");
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res1).getRawValue().isEmpty(), (Object)true, (String)"heatedcoolantof(hydrogen) = empty");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_HEATEDCOOLANTOF.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res2).getRawValue().isEmpty(), (Object)true, (String)"heatedcoolantof(gold) = empty");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_HEATEDCOOLANTOF.evaluate(new IVariable[]{this.eSodium});
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res3).getRawValue().isEmpty(), (Object)true, (String)"heatedcoolantof(sodium) = empty");
        IValue res4 = MekanismOperators.OBJECT_CHEMICALSTACK_HEATEDCOOLANTOF.evaluate(new IVariable[]{this.eSodiumSuperheated});
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res4).getRawValue().equals((Object)new ChemicalStack((Holder)MekanismChemicals.SODIUM, 1000L)), (Object)true, (String)"heatedcoolantof(sodiumSuperheated) = sodium");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHeatedCoolantOfLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_HEATEDCOOLANTOF.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeHeatedCoolantOfSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_HEATEDCOOLANTOF.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeHeatedCoolantOf() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_HEATEDCOOLANTOF.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testIsFuel() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_ISFUEL.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), (Object)true, (String)"isfuel(hydrogen) = true");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_ISFUEL.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), (Object)false, (String)"isfuel(gold) = false");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_ISFUEL.evaluate(new IVariable[]{this.eSodium});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), (Object)false, (String)"isfuel(sodium) = false");
        IValue res4 = MekanismOperators.OBJECT_CHEMICALSTACK_ISFUEL.evaluate(new IVariable[]{this.eSodiumSuperheated});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res4).getRawValue(), (Object)false, (String)"isfuel(sodiumSuperheated) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsFuelLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISFUEL.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsFuelSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISFUEL.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsFuel() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISFUEL.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testBurnTicks() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_BURN_TICKS.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual((Object)((ValueTypeInteger.ValueInteger)res1).getRawValue(), (Object)1, (String)"burnticks(hydrogen) = 1");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_BURN_TICKS.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeInteger.ValueInteger)res2).getRawValue(), (Object)0, (String)"burnticks(gold) = 0");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_BURN_TICKS.evaluate(new IVariable[]{this.eSodium});
        TestHelpers.assertEqual((Object)((ValueTypeInteger.ValueInteger)res3).getRawValue(), (Object)0, (String)"burnticks(sodium) = 0");
        IValue res4 = MekanismOperators.OBJECT_CHEMICALSTACK_BURN_TICKS.evaluate(new IVariable[]{this.eSodiumSuperheated});
        TestHelpers.assertEqual((Object)((ValueTypeInteger.ValueInteger)res4).getRawValue(), (Object)0, (String)"burnticks(sodiumSuperheated) = 0");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBurnTicksLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_BURN_TICKS.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBurnTicksSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_BURN_TICKS.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeBurnTicks() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_BURN_TICKS.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testEnergyPerTick() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_ENERGY_PER_TICK.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeLong.ValueLong, "result is a long");
        TestHelpers.assertEqual((Object)((ValueTypeLong.ValueLong)res1).getRawValue(), (Object)200L, (String)"energypertick(hydrogen) = 200");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_ENERGY_PER_TICK.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeLong.ValueLong)res2).getRawValue(), (Object)0L, (String)"energypertick(gold) = 0");
        IValue res3 = MekanismOperators.OBJECT_CHEMICALSTACK_ENERGY_PER_TICK.evaluate(new IVariable[]{this.eSodium});
        TestHelpers.assertEqual((Object)((ValueTypeLong.ValueLong)res3).getRawValue(), (Object)0L, (String)"energypertick(sodium) = 0");
        IValue res4 = MekanismOperators.OBJECT_CHEMICALSTACK_ENERGY_PER_TICK.evaluate(new IVariable[]{this.eSodiumSuperheated});
        TestHelpers.assertEqual((Object)((ValueTypeLong.ValueLong)res4).getRawValue(), (Object)0L, (String)"energypertick(sodiumSuperheated) = 0");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeEnergyPerTickLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ENERGY_PER_TICK.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeEnergyPerTickSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ENERGY_PER_TICK.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeEnergyPerTick() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ENERGY_PER_TICK.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testIsRawChemicalEqual() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_ISRAWCHEMICALEQUAL.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen100});
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), (Object)true, (String)"israwchemicalequal(hydrogen:1000, hydrogen:100) = true");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_ISRAWCHEMICALEQUAL.evaluate(new IVariable[]{this.eGold, this.eHydrogen});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), (Object)false, (String)"israwchemicalequal(gold:1000, hydrogen:1000) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsRawChemicalEqualLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISRAWCHEMICALEQUAL.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsRawChemicalEqualSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISRAWCHEMICALEQUAL.evaluate(new IVariable[]{this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsRawChemicalEqual() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_ISRAWCHEMICALEQUAL.evaluate(new IVariable[]{DUMMY_VARIABLE, DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testModname() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_MODNAME.evaluate(new IVariable[]{this.eHydrogen});
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual((Object)((ValueTypeString.ValueString)res1).getRawValue(), (Object)"Mekanism", (String)"modname(hydrogen) = Mekanism");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_MODNAME.evaluate(new IVariable[]{this.eGold});
        TestHelpers.assertEqual((Object)((ValueTypeString.ValueString)res2).getRawValue(), (Object)"Mekanism", (String)"modname(gold) = Mekanism");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeModnameLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_MODNAME.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeModnameSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_MODNAME.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeModname() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_MODNAME.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testWithAmount() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_WITH_AMOUNT.evaluate(new IVariable[]{this.eHydrogen, this.l100});
        Asserts.check(res1 instanceof ValueObjectTypeChemicalStack.ValueChemicalStack, "result is a chemical");
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res1).getRawValue().equals((Object)new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 100L)), (Object)true, (String)"withamount(hydrogen:1000, 100) = hydrogen:100");
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res1).getRawValue().equals((Object)new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L)), (Object)false, (String)"withamount(hydrogen:1000, 100) != hydrogen:1000");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeWithAmountLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_WITH_AMOUNT.evaluate(new IVariable[]{this.eHydrogen, this.l100, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeWithAmountSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_WITH_AMOUNT.evaluate(new IVariable[]{this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeWithAmount() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_WITH_AMOUNT.evaluate(new IVariable[]{DUMMY_VARIABLE, DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testTag() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_TAG.evaluate(new IVariable[]{this.eSteam});
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        IValueTypeListProxy list = ((ValueTypeList.ValueList)res1).getRawValue();
        TestHelpers.assertEqual((Object)list.getLength(), (Object)2, (String)"tag(steam).length = 2");
        TestHelpers.assertEqual((Object)((ValueTypeString.ValueString)list.get(0)).getRawValue(), (Object)"mekanism:gaseous", (String)"tag(steam)[0] = mekanism:gaseous");
        TestHelpers.assertEqual((Object)((ValueTypeString.ValueString)list.get(1)).getRawValue(), (Object)"mekanism:water_vapor", (String)"tag(steam)[1] = mekanism:water_vapor");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_TAG.evaluate(new IVariable[]{this.eHydrogen});
        TestHelpers.assertEqual((Object)((ValueTypeList.ValueList)res2).getRawValue().getLength(), (Object)1, (String)"tag(hydrogen).length = 1");
        TestHelpers.assertEqual((Object)((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(0)).getRawValue(), (Object)"mekanism:gaseous", (String)"tag(hydrogen)[1] = mekanism:gaseous");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_TAG.evaluate(new IVariable[]{this.eHydrogen, this.eHydrogen});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_TAG.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTag() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_TAG.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testTagStacks() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_TAG_STACKS.evaluate(new IVariable[]{this.sWaterVapor});
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        IValueTypeListProxy list = ((ValueTypeList.ValueList)res1).getRawValue();
        TestHelpers.assertEqual((Object)list.getLength(), (Object)2, (String)"tagstacks(mekanism:water_vapor).length = 2");
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)list.get(0)).getRawValue().equals((Object)new ChemicalStack((Holder)MekanismChemicals.WATER_VAPOR, 1000L)), (Object)true, (String)"tagstacks(mekanism:water_vapor)[0] = water_vapor");
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)list.get(1)).getRawValue().equals((Object)new ChemicalStack((Holder)MekanismChemicals.STEAM, 1000L)), (Object)true, (String)"tagstacks(mekanism:water_vapor)[1] = steam");
        IValue res2 = MekanismOperators.OBJECT_CHEMICALSTACK_TAG_STACKS.evaluate(new IVariable[]{new DummyVariable<ValueTypeString.ValueString>((IValueType<ValueTypeString.ValueString>)ValueTypes.STRING, ValueTypeString.ValueString.of((String)"none"))});
        TestHelpers.assertEqual((Object)((ValueTypeList.ValueList)res2).getRawValue().getLength(), (Object)0, (String)"tagstacks(none) = empty");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagStacksLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_TAG_STACKS.evaluate(new IVariable[]{this.sWaterVapor, this.sWaterVapor});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagStacksSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_TAG_STACKS.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTagStacks() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_TAG_STACKS.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testChemicalChemicalByName() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_CHEMICALSTACK_BY_NAME.evaluate(new IVariable[]{this.sWaterVapor});
        Asserts.check(res1 instanceof ValueObjectTypeChemicalStack.ValueChemicalStack, "result is a chemical");
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res1).getRawValue().getChemical(), (Object)new ChemicalStack((Holder)MekanismChemicals.WATER_VAPOR, 1000L).getChemical(), (String)"chemicalbyname(mekanism:watervapor) = watervapor");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeChemicalByNameLarge() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_BY_NAME.evaluate(new IVariable[]{this.sWaterVapor, this.sWaterVapor});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeChemicalByNameSmall() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_BY_NAME.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeChemicalByName() throws EvaluationException {
        MekanismOperators.OBJECT_CHEMICALSTACK_BY_NAME.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }
}

