/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest.integration;

import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismChemicals;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.core.test.TestHelpers;
import org.cyclops.integratedmekanism.gametest.integration.Asserts;
import org.cyclops.integratedmekanism.gametest.integration.DummyValueType;
import org.cyclops.integratedmekanism.gametest.integration.DummyVariable;
import org.cyclops.integratedmekanism.gametest.integration.DummyVariableItemStack;
import org.cyclops.integratedmekanism.operator.MekanismOperators;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;

public class TestItemStackOperators {
    private static final DummyValueType DUMMY_TYPE = DummyValueType.TYPE;
    private static final DummyVariable<DummyValueType.DummyValue> DUMMY_VARIABLE = new DummyVariable<DummyValueType.DummyValue>(DUMMY_TYPE, DummyValueType.DummyValue.of());
    private DummyVariableItemStack iApple;
    private DummyVariableItemStack iHoe;
    private DummyVariableItemStack iTankEmpty;
    private DummyVariableItemStack iTankHydrogen;
    private DummyVariableItemStack iTankGold;

    @IntegrationBefore
    public void before() {
        this.iApple = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.APPLE)));
        this.iHoe = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.DIAMOND_HOE)));
        this.iTankEmpty = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK)));
        this.iTankHydrogen = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK)));
        IChemicalHandler h1 = (IChemicalHandler)((ValueObjectTypeItemStack.ValueItemStack)this.iTankHydrogen.getValue()).getRawValue().getCapability(Capabilities.CHEMICAL.item());
        h1.insertChemical(new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L), Action.EXECUTE);
        this.iTankGold = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK)));
        IChemicalHandler h2 = (IChemicalHandler)((ValueObjectTypeItemStack.ValueItemStack)this.iTankGold.getValue()).getRawValue().getCapability(Capabilities.CHEMICAL.item());
        h2.insertChemical(new ChemicalStack((Holder)MekanismChemicals.GOLD, 100L), Action.EXECUTE);
    }

    @IntegrationTest
    public void testItemStackIsChemicalStack() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_ITEMSTACK_ISCHEMICALSTACK.evaluate(new IVariable[]{this.iHoe});
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), (Object)false, (String)"ischemicalstack(hoe) = false");
        IValue res2 = MekanismOperators.OBJECT_ITEMSTACK_ISCHEMICALSTACK.evaluate(new IVariable[]{this.iTankHydrogen});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), (Object)true, (String)"ischemicalstack(tankhydrogen) = true");
        IValue res3 = MekanismOperators.OBJECT_ITEMSTACK_ISCHEMICALSTACK.evaluate(new IVariable[]{this.iTankEmpty});
        TestHelpers.assertEqual((Object)((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), (Object)true, (String)"ischemicalstack(tankempty) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsChemicalStackIsChemicalStackLarge() throws EvaluationException {
        MekanismOperators.OBJECT_ITEMSTACK_ISCHEMICALSTACK.evaluate(new IVariable[]{this.iApple, this.iApple});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputIsChemicalStackIsChemicalStackSmall() throws EvaluationException {
        MekanismOperators.OBJECT_ITEMSTACK_ISCHEMICALSTACK.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsChemicalStack() throws EvaluationException {
        MekanismOperators.OBJECT_ITEMSTACK_ISCHEMICALSTACK.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testItemStackChemicalStack() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACK.evaluate(new IVariable[]{this.iHoe});
        Asserts.check(res1 instanceof ValueObjectTypeChemicalStack.ValueChemicalStack, "result is a chemicalstack");
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res1).getRawValue().isEmpty(), (Object)true, (String)"chemicalstack(hoe) = null");
        IValue res2 = MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACK.evaluate(new IVariable[]{this.iTankHydrogen});
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res2).getRawValue().equals((Object)new ChemicalStack((Holder)MekanismChemicals.HYDROGEN, 1000L)), (Object)true, (String)"chemicalstack(tankhydrogen) = hydrogen:1000");
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res2).getRawValue().equals((Object)new ChemicalStack((Holder)MekanismChemicals.GOLD, 1000L)), (Object)false, (String)"chemicalstack(tankhydrogen) != gold:1000");
        IValue res3 = MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACK.evaluate(new IVariable[]{this.iTankGold});
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res3).getRawValue().equals((Object)new ChemicalStack((Holder)MekanismChemicals.GOLD, 100L)), (Object)true, (String)"chemicalstack(tankgold) = gold:100");
        IValue res4 = MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACK.evaluate(new IVariable[]{this.iTankEmpty});
        TestHelpers.assertEqual((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)res4).getRawValue().isEmpty(), (Object)true, (String)"chemicalstack(empty) = empty");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputChemicalStackChemicalStackLarge() throws EvaluationException {
        MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACK.evaluate(new IVariable[]{this.iApple, this.iApple});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputChemicalStackChemicalStackSmall() throws EvaluationException {
        MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACK.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeChemicalStack() throws EvaluationException {
        MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACK.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }

    @IntegrationTest
    public void testItemStackChemicalStackCapacity() throws EvaluationException {
        IValue res1 = MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACKCAPACITY.evaluate(new IVariable[]{this.iHoe});
        Asserts.check(res1 instanceof ValueTypeLong.ValueLong, "result is a long");
        TestHelpers.assertEqual((Object)((ValueTypeLong.ValueLong)res1).getRawValue(), (Object)0L, (String)"chemicalstackcapacity(hoe) = 0");
        IValue res2 = MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACKCAPACITY.evaluate(new IVariable[]{this.iTankHydrogen});
        TestHelpers.assertEqual((Object)((ValueTypeLong.ValueLong)res2).getRawValue(), (Object)64000L, (String)"chemicalstackcapacity(tankhydrogen) = 64000");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputChemicalStackCapacityChemicalStackCapacityLarge() throws EvaluationException {
        MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACKCAPACITY.evaluate(new IVariable[]{this.iApple, this.iApple});
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputChemicalStackCapacityChemicalStackCapacitySmall() throws EvaluationException {
        MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACKCAPACITY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeChemicalStackCapacity() throws EvaluationException {
        MekanismOperators.OBJECT_ITEMSTACK_CHEMICALSTACKCAPACITY.evaluate(new IVariable[]{DUMMY_VARIABLE});
    }
}

