/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.ingredient;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.neoforged.neoforge.capabilities.BaseCapability;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.capability.ICapabilityGetter;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.integratedmekanism.ingredient.ChemicalHandlerChemicalStackIterator;
import org.cyclops.integratedmekanism.ingredient.ChemicalMatch;

public class IngredientComponentStorageWrapperHandlerChemicalStack<C>
implements IIngredientComponentStorageWrapperHandler<ChemicalStack, Integer, IChemicalHandler, C> {
    private final IngredientComponent<ChemicalStack, Integer> ingredientComponent;
    private final BaseCapability<? extends IChemicalHandler, C> handlerCapability;

    public IngredientComponentStorageWrapperHandlerChemicalStack(IngredientComponent<ChemicalStack, Integer> ingredientComponent, BaseCapability<? extends IChemicalHandler, C> handlerCapability) {
        this.ingredientComponent = Objects.requireNonNull(ingredientComponent);
        this.handlerCapability = handlerCapability;
    }

    public static Action simulateToChemicalAction(boolean simulate) {
        return simulate ? Action.SIMULATE : Action.EXECUTE;
    }

    public static boolean chemicalActionToSimulate(Action chemicalAction) {
        return chemicalAction.simulate();
    }

    public IIngredientComponentStorage<ChemicalStack, Integer> wrapComponentStorage(IChemicalHandler storage) {
        return new ComponentStorageWrapper(this.getComponent(), storage);
    }

    public IChemicalHandler wrapStorage(IIngredientComponentStorage<ChemicalStack, Integer> componentStorage) {
        if (componentStorage instanceof IIngredientComponentStorageSlotted) {
            IIngredientComponentStorageSlotted componentStorageSlotted = (IIngredientComponentStorageSlotted)componentStorage;
            return new ChemicalStorageWrapperSlotted((IIngredientComponentStorageSlotted<ChemicalStack, Integer>)componentStorageSlotted);
        }
        return new ChemicalStorageWrapper(componentStorage);
    }

    public Optional<IChemicalHandler> getStorage(ICapabilityGetter<C> capabilityProvider, @Nullable C context) {
        return Optional.ofNullable((IChemicalHandler)capabilityProvider.getCapability(this.handlerCapability, context));
    }

    public IngredientComponent<ChemicalStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    public static class ComponentStorageWrapper
    implements IIngredientComponentStorage<ChemicalStack, Integer> {
        private final IngredientComponent<ChemicalStack, Integer> ingredientComponent;
        private final IChemicalHandler storage;

        public ComponentStorageWrapper(IngredientComponent<ChemicalStack, Integer> ingredientComponent, IChemicalHandler storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        public IngredientComponent<ChemicalStack, Integer> getComponent() {
            return this.ingredientComponent;
        }

        public Iterator<ChemicalStack> iterator() {
            return new ChemicalHandlerChemicalStackIterator(this.storage);
        }

        public Iterator<ChemicalStack> iterator(@Nonnull ChemicalStack prototype, Integer matchFlags) {
            if (((Integer)this.getComponent().getMatcher().getAnyMatchCondition()).equals(matchFlags)) {
                return this.iterator();
            }
            return new FilteredIngredientCollectionIterator(this.iterator(), this.getComponent().getMatcher(), (Object)prototype, (Object)matchFlags);
        }

        public long getMaxQuantity() {
            long sum = 0L;
            for (int i = 0; i < this.storage.getChemicalTanks(); ++i) {
                sum = Math.addExact(sum, this.storage.getChemicalTankCapacity(i));
            }
            return sum;
        }

        public ChemicalStack insert(@Nonnull ChemicalStack ingredient, boolean simulate) {
            if (ingredient.isEmpty()) {
                return (ChemicalStack)this.getComponent().getMatcher().getEmptyInstance();
            }
            return this.storage.insertChemical(ingredient, IngredientComponentStorageWrapperHandlerChemicalStack.simulateToChemicalAction(simulate));
        }

        public ChemicalStack extract(@Nonnull ChemicalStack prototype, Integer matchFlags, boolean simulate) {
            if (prototype.isEmpty()) {
                return (ChemicalStack)this.getComponent().getMatcher().getEmptyInstance();
            }
            if (matchFlags == 0) {
                return this.storage.extractChemical(prototype.getAmount(), IngredientComponentStorageWrapperHandlerChemicalStack.simulateToChemicalAction(simulate));
            }
            if (matchFlags == 2) {
                ChemicalStack drainedSimulated = this.storage.extractChemical(prototype.getAmount(), Action.SIMULATE);
                if (drainedSimulated.isEmpty() || drainedSimulated.getAmount() != prototype.getAmount()) {
                    return (ChemicalStack)this.getComponent().getMatcher().getEmptyInstance();
                }
                return simulate ? drainedSimulated : this.storage.extractChemical(prototype.getAmount(), Action.EXECUTE);
            }
            for (int i = 0; i < this.storage.getChemicalTanks(); ++i) {
                ChemicalStack contents = this.storage.getChemicalInTank(i);
                if (contents.isEmpty() || !ChemicalMatch.areStacksEqual(contents, prototype, matchFlags & 0xFFFFFFFD)) continue;
                ChemicalStack toDrain = contents.copy();
                toDrain.setAmount(prototype.getAmount());
                ChemicalStack drained = this.storage.extractChemical(toDrain, IngredientComponentStorageWrapperHandlerChemicalStack.simulateToChemicalAction(simulate));
                if (!ChemicalMatch.areStacksEqual(drained, prototype, matchFlags)) continue;
                return drained;
            }
            return (ChemicalStack)this.getComponent().getMatcher().getEmptyInstance();
        }

        public ChemicalStack extract(long maxQuantity, boolean simulate) {
            return this.storage.extractChemical(maxQuantity, IngredientComponentStorageWrapperHandlerChemicalStack.simulateToChemicalAction(simulate));
        }
    }

    public static class ChemicalStorageWrapperSlotted
    extends ChemicalStorageWrapper {
        private final IIngredientComponentStorageSlotted<ChemicalStack, Integer> storage;

        public ChemicalStorageWrapperSlotted(IIngredientComponentStorageSlotted<ChemicalStack, Integer> storage) {
            super((IIngredientComponentStorage<ChemicalStack, Integer>)storage);
            this.storage = storage;
        }

        @Override
        public int getChemicalTanks() {
            return this.storage.getSlots();
        }

        @Override
        @Nonnull
        public ChemicalStack getChemicalInTank(int tank) {
            int tanks = this.getChemicalTanks();
            if (tank < 0 || tank >= tanks) {
                throw new IndexOutOfBoundsException("Tank " + tank + " not in valid range - [0," + tanks + ")");
            }
            return (ChemicalStack)this.storage.getSlotContents(tank);
        }

        @Override
        public void setChemicalInTank(int i, ChemicalStack stack) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValid(int tank, @Nonnull ChemicalStack stack) {
            return true;
        }

        @Override
        public ChemicalStack insertChemical(int i, ChemicalStack stack, Action action) {
            return (ChemicalStack)this.storage.insert(i, (Object)stack, IngredientComponentStorageWrapperHandlerChemicalStack.chemicalActionToSimulate(action));
        }

        @Override
        public ChemicalStack extractChemical(int i, long l, Action action) {
            return (ChemicalStack)this.storage.extract(i, l, IngredientComponentStorageWrapperHandlerChemicalStack.chemicalActionToSimulate(action));
        }
    }

    public static class ChemicalStorageWrapper
    implements IChemicalHandler {
        private final IIngredientComponentStorage<ChemicalStack, Integer> storage;

        public ChemicalStorageWrapper(IIngredientComponentStorage<ChemicalStack, Integer> storage) {
            this.storage = storage;
        }

        public int getChemicalTanks() {
            return Iterators.size((Iterator)this.storage.iterator()) + 1;
        }

        @Nonnull
        public ChemicalStack getChemicalInTank(int tank) {
            return (ChemicalStack)Iterables.get(this.storage, (int)tank, (Object)ChemicalStack.EMPTY);
        }

        public long getChemicalTankCapacity(int tank) {
            return Long.MAX_VALUE;
        }

        public void setChemicalInTank(int i, ChemicalStack stack) {
            throw new UnsupportedOperationException();
        }

        public boolean isValid(int tank, @Nonnull ChemicalStack stack) {
            return false;
        }

        public ChemicalStack insertChemical(int i, ChemicalStack stack, Action action) {
            return stack;
        }

        public ChemicalStack extractChemical(int i, long l, Action action) {
            return ChemicalStack.EMPTY;
        }

        public ChemicalStack insertChemical(ChemicalStack resource, Action action) {
            return (ChemicalStack)this.storage.insert((Object)resource, IngredientComponentStorageWrapperHandlerChemicalStack.chemicalActionToSimulate(action));
        }

        public ChemicalStack extractChemical(ChemicalStack resource, Action action) {
            return (ChemicalStack)this.storage.extract((Object)resource, (Object)3, IngredientComponentStorageWrapperHandlerChemicalStack.chemicalActionToSimulate(action));
        }

        public ChemicalStack extractChemical(long maxDrain, Action action) {
            return (ChemicalStack)this.storage.extract(maxDrain, IngredientComponentStorageWrapperHandlerChemicalStack.chemicalActionToSimulate(action));
        }
    }
}

