/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.capability.recipehandler;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedmekanism.capability.recipehandler.MekanismRecipeHandler;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;

public class ChemicalCrystallizerRecipeHandler
extends MekanismRecipeHandler<ChemicalCrystallizerRecipe> {
    protected ChemicalCrystallizerRecipeHandler(Supplier<Level> levelSupplier) {
        super(MekanismRecipeType.CRYSTALLIZING, levelSupplier, Set.of(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK), Set.of(IngredientComponents.ITEMSTACK));
    }

    public boolean isValidSizeInput(IngredientComponent<?, ?> ingredientComponent, int size) {
        return ingredientComponent == MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK && size == 1;
    }

    @Override
    protected void recipeToInputs(ChemicalCrystallizerRecipe recipe, Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs) {
        inputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, List.of(new PrototypedIngredientAlternativesList(ChemicalCrystallizerRecipeHandler.getPrototypesFromChemicalIngredient(recipe.getInput()))));
    }

    @Override
    protected void recipeToOutputs(ChemicalCrystallizerRecipe recipe, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        outputs.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{(ItemStack)recipe.getOutputDefinition().get(0)}));
    }

    @Override
    protected void recipeToOutputsSimulated(ChemicalCrystallizerRecipe recipe, IMixedIngredients input, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        outputs.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipe.getOutput((ChemicalStack)input.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).get(0))}));
    }

    @Override
    protected boolean doesRecipeMatchInput(ChemicalCrystallizerRecipe recipe, IMixedIngredients input) {
        return recipe.getInput().test((ChemicalStack)input.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).get(0));
    }
}

