/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.capability.recipehandler;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedmekanism.capability.recipehandler.MekanismRecipeHandler;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;

public class ChemicalDissolutionRecipeHandler
extends MekanismRecipeHandler<ChemicalDissolutionRecipe> {
    protected ChemicalDissolutionRecipeHandler(Supplier<Level> levelSupplier) {
        super(MekanismRecipeType.DISSOLUTION, levelSupplier, Set.of(IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK), Set.of(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK));
    }

    public boolean isValidSizeInput(IngredientComponent<?, ?> ingredientComponent, int size) {
        return ingredientComponent == IngredientComponents.ITEMSTACK && size == 1 || ingredientComponent == MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK && size == 1;
    }

    @Override
    protected void recipeToInputs(ChemicalDissolutionRecipe recipe, Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs) {
        inputs.put(IngredientComponents.ITEMSTACK, List.of(new PrototypedIngredientAlternativesList(ChemicalDissolutionRecipeHandler.getPrototypesFromItemIngredient((InputIngredient<ItemStack>)recipe.getItemInput()))));
        inputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, List.of(new PrototypedIngredientAlternativesList(ChemicalDissolutionRecipeHandler.getPrototypesFromChemicalIngredient(recipe.getChemicalInput()))));
    }

    @Override
    protected void recipeToOutputs(ChemicalDissolutionRecipe recipe, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        outputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, Lists.newArrayList((Object[])new ChemicalStack[]{(ChemicalStack)recipe.getOutputDefinition().get(0)}));
    }

    @Override
    protected void recipeToOutputsSimulated(ChemicalDissolutionRecipe recipe, IMixedIngredients input, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        ChemicalStack chemicalStack = (ChemicalStack)input.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).get(0);
        outputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, Lists.newArrayList((Object[])new ChemicalStack[]{(ChemicalStack)recipe.getOutput((ItemStack)input.getInstances(IngredientComponents.ITEMSTACK).get(0), chemicalStack)}));
    }

    @Override
    protected boolean doesRecipeMatchInput(ChemicalDissolutionRecipe recipe, IMixedIngredients input) {
        return recipe.getItemInput().test((ItemStack)input.getInstances(IngredientComponents.ITEMSTACK).get(0)) && recipe.getChemicalInput().test((ChemicalStack)input.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).get(0));
    }
}

