/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.capability.recipehandler;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedmekanism.capability.recipehandler.MekanismRecipeHandler;

public class CombinerRecipeHandler
extends MekanismRecipeHandler<CombinerRecipe> {
    protected CombinerRecipeHandler(Supplier<Level> levelSupplier) {
        super(MekanismRecipeType.COMBINING, levelSupplier, Set.of(IngredientComponents.ITEMSTACK), Set.of(IngredientComponents.ITEMSTACK));
    }

    public boolean isValidSizeInput(IngredientComponent<?, ?> ingredientComponent, int size) {
        return ingredientComponent == IngredientComponents.ITEMSTACK && size == 2;
    }

    @Override
    protected void recipeToInputs(CombinerRecipe recipe, Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs) {
        inputs.put(IngredientComponents.ITEMSTACK, List.of(new PrototypedIngredientAlternativesList(CombinerRecipeHandler.getPrototypesFromItemIngredient((InputIngredient<ItemStack>)recipe.getMainInput())), new PrototypedIngredientAlternativesList(CombinerRecipeHandler.getPrototypesFromItemIngredient((InputIngredient<ItemStack>)recipe.getExtraInput()))));
    }

    @Override
    protected void recipeToOutputs(CombinerRecipe recipe, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        outputs.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{(ItemStack)recipe.getOutputDefinition().get(0)}));
    }

    @Override
    protected void recipeToOutputsSimulated(CombinerRecipe recipe, IMixedIngredients input, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        outputs.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipe.getOutput((ItemStack)input.getInstances(IngredientComponents.ITEMSTACK).get(0), (ItemStack)input.getInstances(IngredientComponents.ITEMSTACK).get(1))}));
    }

    @Override
    protected boolean doesRecipeMatchInput(CombinerRecipe recipe, IMixedIngredients input) {
        return recipe.getMainInput().test((ItemStack)input.getInstances(IngredientComponents.ITEMSTACK).get(0)) && recipe.getExtraInput().test((ItemStack)input.getInstances(IngredientComponents.ITEMSTACK).get(1));
    }
}

