/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.client.render.value;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;
import org.joml.Matrix4f;

public class ChemicalValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    public void renderValue(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        ChemicalStack chemicalStack = ((ValueObjectTypeChemicalStack.ValueChemicalStack)value).getRawValue();
        if (!chemicalStack.isEmpty()) {
            Chemical chemical = chemicalStack.getChemical();
            int brightness = combinedLight;
            int l2 = brightness >> 16 & 0xFFFF;
            int i3 = brightness & 0xFFFF;
            matrixStack.pushPose();
            TextureAtlasSprite icon = MekanismRenderer.getSprite((ResourceLocation)chemical.getIcon());
            Triple color = Helpers.intToRGB((int)chemical.getTint());
            VertexConsumer vb = renderTypeBuffer.getBuffer(RenderType.text((ResourceLocation)icon.atlasLocation()));
            Matrix4f matrix = matrixStack.last().pose();
            float min = 0.0f;
            float max = 12.5f;
            float u1 = icon.getU0();
            float u2 = icon.getU1();
            float v1 = icon.getV0();
            float v2 = icon.getV1();
            vb.addVertex(matrix, max, max, 0.0f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), alpha).setUv(u2, v2).setUv2(l2, i3);
            vb.addVertex(matrix, max, min, 0.0f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), alpha).setUv(u2, v1).setUv2(l2, i3);
            vb.addVertex(matrix, min, min, 0.0f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), alpha).setUv(u1, v1).setUv2(l2, i3);
            vb.addVertex(matrix, min, max, 0.0f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), alpha).setUv(u1, v2).setUv2(l2, i3);
            matrixStack.translate(7.0f, 8.5f, 0.1f);
            String string = String.valueOf(chemicalStack.getAmount());
            float scale = 5.0f / (float)context.getFont().width(string);
            matrixStack.scale(scale, scale, 1.0f);
            context.getFont().drawInBatch(string, 0.0f, 0.0f, Helpers.RGBAToInt((int)200, (int)200, (int)200, (int)((int)(alpha * 255.0f))), false, matrixStack.last().pose(), renderTypeBuffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            matrixStack.popPose();
        }
    }
}

