/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest;

import mekanism.generators.common.registries.GeneratorsBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedmekanism.part.aspect.MekanismAspects;

@GameTestHolder(value="integratedmekanism")
@PrefixGameTestTemplate(value=false)
public class GameTestsAspectsReadMachineFission {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    public static BlockPos build(GameTestHelper helper, BlockPos pos) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 3; ++z) {
                    BlockPos posi = pos.offset(x, y, z);
                    if (y == 0 || y == 3 || x == 0 || x == 2 || z == 0 || z == 2) {
                        helper.setBlock(posi, GeneratorsBlocks.FISSION_REACTOR_CASING.defaultState());
                        continue;
                    }
                    if (x % 2 != z % 2) continue;
                    if (y == 2) {
                        helper.setBlock(posi, GeneratorsBlocks.CONTROL_ROD_ASSEMBLY.defaultState());
                        continue;
                    }
                    helper.setBlock(posi, GeneratorsBlocks.FISSION_FUEL_ASSEMBLY.defaultState());
                }
            }
        }
        BlockPos ioPos = pos.east().east().above().south();
        helper.setBlock(ioPos, (Block)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER.get());
        return ioPos;
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionDamageInvalid(GameTestHelper helper) {
        helper.setBlock(POS, (Block)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER.get());
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_DAMAGE, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionDamageValid(GameTestHelper helper) {
        BlockPos ioPos = GameTestsAspectsReadMachineFission.build(helper, POS);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)ioPos.east(), (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_DAMAGE, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionBurnRateInvalid(GameTestHelper helper) {
        helper.setBlock(POS, (Block)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER.get());
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_BURNRATE, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionBurnRateValid(GameTestHelper helper) {
        BlockPos ioPos = GameTestsAspectsReadMachineFission.build(helper, POS);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)ioPos.east(), (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_BURNRATE, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionBurnRateMaxInvalid(GameTestHelper helper) {
        helper.setBlock(POS, (Block)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER.get());
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_BURNRATEMAX, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionBurnRateMaxValid(GameTestHelper helper) {
        BlockPos ioPos = GameTestsAspectsReadMachineFission.build(helper, POS);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)ioPos.east(), (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_BURNRATEMAX, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionBurnRateLimitInvalid(GameTestHelper helper) {
        helper.setBlock(POS, (Block)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER.get());
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_BURNRATELIMIT, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionBurnRateLimitValid(GameTestHelper helper) {
        BlockPos ioPos = GameTestsAspectsReadMachineFission.build(helper, POS);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)ioPos.east(), (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_BURNRATELIMIT, (IValue)ValueTypeDouble.ValueDouble.of((double)0.1));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionHeatRateInvalid(GameTestHelper helper) {
        helper.setBlock(POS, (Block)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER.get());
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.LONG_FISSIONREACTOR_HEATERATE, (IValue)ValueTypeLong.ValueLong.of((long)0L));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionHeatRateValid(GameTestHelper helper) {
        BlockPos ioPos = GameTestsAspectsReadMachineFission.build(helper, POS);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)ioPos.east(), (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.LONG_FISSIONREACTOR_HEATERATE, (IValue)ValueTypeLong.ValueLong.of((long)0L));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionEnvironmentLossInvalid(GameTestHelper helper) {
        helper.setBlock(POS, (Block)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER.get());
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)POS, (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_ENVIRONMENTLOSS, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
    }

    @GameTest(template="empty10")
    public void testAspectsReadFissionEnvironmentLossValid(GameTestHelper helper) {
        BlockPos ioPos = GameTestsAspectsReadMachineFission.build(helper, POS);
        GameTestHelpersIntegratedDynamics.testReadAspect((BlockPos)ioPos.east(), (GameTestHelper)helper, (IPartTypeReader)PartTypes.MACHINE_READER, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_ENVIRONMENTLOSS, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
    }
}

