/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datamaps.chemical.attribute.ChemicalFuel;
import mekanism.api.datamaps.chemical.attribute.ChemicalRadioactivity;
import mekanism.api.datamaps.chemical.attribute.CooledCoolant;
import mekanism.api.datamaps.chemical.attribute.HeatedCoolant;
import mekanism.api.datamaps.chemical.attribute.IChemicalCoolant;
import mekanism.api.radiation.capability.IRadiationEntity;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismDataMapTypes;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.IOperatorValuePropagator;
import org.cyclops.integrateddynamics.core.evaluate.OperatorBuilders;
import org.cyclops.integrateddynamics.core.evaluate.operator.IterativeFunction;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.ExtendedIngredientsList;
import org.cyclops.integrateddynamics.core.ingredient.ExtendedIngredientsSingle;
import org.cyclops.integratedmekanism.core.CapabilityHelpers;
import org.cyclops.integratedmekanism.core.ChemicalHelpers;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.operator.MekanismOperatorBuilders;
import org.cyclops.integratedmekanism.value.MekanismValueTypes;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;

public class MekanismOperators {
    public static final IOperatorRegistry REGISTRY = MekanismOperators.constructRegistry();
    public static final IOperator OBJECT_ITEMSTACK_ISCHEMICALSTACK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.modId("integratedmekanism").output((IValueType)ValueTypes.BOOLEAN).symbol("is_chemicalstack").operatorName("ischemicalstack").interactName("isChemicalStack").function((OperatorBase.IFunction)OperatorBuilders.FUNCTION_ITEMSTACK_TO_BOOLEAN.build(itemStack -> !itemStack.isEmpty() && CapabilityHelpers.getChemicalHandler(itemStack).isPresent())).build());
    public static final IOperator OBJECT_ITEMSTACK_CHEMICALSTACK = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.modId("integratedmekanism").output((IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK).symbolOperator("chemicalstack").interactName("chemicalStack").function(variables -> {
        ValueObjectTypeItemStack.ValueItemStack a = (ValueObjectTypeItemStack.ValueItemStack)variables.getValue(0, (IValueType)ValueTypes.OBJECT_ITEMSTACK);
        return ValueObjectTypeChemicalStack.ValueChemicalStack.of(!a.getRawValue().isEmpty() ? CapabilityHelpers.getChemicalHandler(a.getRawValue()).map(h -> h.getChemicalTanks() > 0 ? h.getChemicalInTank(0) : ChemicalStack.EMPTY).orElse(ChemicalStack.EMPTY) : ChemicalStack.EMPTY);
    }).build());
    public static final IOperator OBJECT_ITEMSTACK_CHEMICALSTACKCAPACITY = REGISTRY.register(OperatorBuilders.ITEMSTACK_1_SUFFIX_LONG.modId("integratedmekanism").output((IValueType)ValueTypes.LONG).symbol("chemicalstack_capacity").operatorName("chemicalstackcapacity").interactName("chemicalCapacity").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_ITEMSTACK_TO_LONG.build(itemStack -> !itemStack.isEmpty() ? CapabilityHelpers.getChemicalHandler(itemStack).map(h -> h.getChemicalTanks() > 0 ? h.getChemicalTankCapacity(0) : 0L).orElse(0L) : 0L)).build());
    public static final IOperator OBJECT_CHEMICALSTACK_AMOUNT = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.LONG).symbolOperatorInteract("amount").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_LONG.build(ChemicalStack::getAmount)).build());
    public static final IOperator OBJECT_CHEMICALSTACK_TINT = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.INTEGER).symbolOperatorInteract("tint").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_INT.build(ChemicalStack::getChemicalTint)).build());
    public static final IOperator OBJECT_CHEMICALSTACK_ISRADIOACTIVE = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.BOOLEAN).symbolOperator("is_radioactive").interactName("isRadioactive").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_BOOLEAN.build(chemicalStack -> Optional.ofNullable((ChemicalRadioactivity)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.chemicalRadioactivity())).map(a -> a.needsValidation() && a.radioactivity() > 0.0).orElse(false))).build());
    public static final IOperator OBJECT_CHEMICALSTACK_RADIOACTIVITY = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.DOUBLE).symbolOperatorInteract("radioactivity").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_DOUBLE.build(chemicalStack -> Optional.ofNullable((ChemicalRadioactivity)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.chemicalRadioactivity())).map(ChemicalRadioactivity::radioactivity).orElse(0.0))).build());
    public static final IOperator OBJECT_CHEMICALSTACK_ISCOOLANT = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.BOOLEAN).symbolOperator("is_coolant").interactName("isCoolant").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_BOOLEAN.build(chemicalStack -> chemicalStack.getData(MekanismDataMapTypes.INSTANCE.cooledChemicalCoolant()) != null || chemicalStack.getData(MekanismDataMapTypes.INSTANCE.heatedChemicalCoolant()) != null)).build());
    public static final IOperator OBJECT_CHEMICALSTACK_THERMALENTHALPY = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.DOUBLE).symbolOperator("thermal_enthalpy").interactName("thermalEnthalpy").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_DOUBLE.build(chemicalStack -> Optional.ofNullable((IChemicalCoolant)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.cooledChemicalCoolant())).or(() -> Optional.ofNullable((HeatedCoolant)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.heatedChemicalCoolant()))).map(IChemicalCoolant::thermalEnthalpy).orElse(0.0))).build());
    public static final IOperator OBJECT_CHEMICALSTACK_CONDUCTIVITY = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.DOUBLE).symbolOperatorInteract("conductivity").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_DOUBLE.build(chemicalStack -> Optional.ofNullable((IChemicalCoolant)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.cooledChemicalCoolant())).or(() -> Optional.ofNullable((HeatedCoolant)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.heatedChemicalCoolant()))).map(IChemicalCoolant::conductivity).orElse(0.0))).build());
    public static final IOperator OBJECT_CHEMICALSTACK_ISCOOLEDCOOLANT = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.BOOLEAN).symbolOperator("is_cooled_coolant").interactName("isCooledCoolant").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_BOOLEAN.build(chemicalStack -> chemicalStack.getData(MekanismDataMapTypes.INSTANCE.cooledChemicalCoolant()) != null)).build());
    public static final IOperator OBJECT_CHEMICALSTACK_COOLEDCOOLANTOF = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK).symbolOperator("cooled_coolant_of").interactName("cooledCoolantOf").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_CHEMICALSTACK.build(chemicalStack -> Optional.ofNullable((CooledCoolant)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.cooledChemicalCoolant())).map(coolant -> coolant.heat(chemicalStack.getAmount())).orElse(ChemicalStack.EMPTY))).build());
    public static final IOperator OBJECT_CHEMICALSTACK_ISHEATEDCOOLANT = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.BOOLEAN).symbolOperator("is_heated_coolant").interactName("isHeatedCoolant").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_BOOLEAN.build(chemicalStack -> chemicalStack.getData(MekanismDataMapTypes.INSTANCE.heatedChemicalCoolant()) != null)).build());
    public static final IOperator OBJECT_CHEMICALSTACK_HEATEDCOOLANTOF = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK).symbolOperator("heated_coolant_of").interactName("heatedCoolantOf").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_CHEMICALSTACK.build(chemicalStack -> Optional.ofNullable((HeatedCoolant)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.heatedChemicalCoolant())).map(coolant -> coolant.cool(chemicalStack.getAmount())).orElse(ChemicalStack.EMPTY))).build());
    public static final IOperator OBJECT_CHEMICALSTACK_ISFUEL = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.BOOLEAN).symbolOperator("is_fuel").interactName("isFuel").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_BOOLEAN.build(chemicalStack -> chemicalStack.getData(MekanismDataMapTypes.INSTANCE.chemicalFuel()) != null)).build());
    public static final IOperator OBJECT_CHEMICALSTACK_BURN_TICKS = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.INTEGER).symbolOperator("burn_ticks").interactName("burnTicks").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_INT.build(chemicalStack -> Optional.ofNullable((ChemicalFuel)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.chemicalFuel())).map(ChemicalFuel::burnTicks).orElse(0))).build());
    public static final IOperator OBJECT_CHEMICALSTACK_ENERGY_PER_TICK = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.LONG).symbolOperator("energy_per_tick").interactName("energyPerTick").function((OperatorBase.IFunction)MekanismOperatorBuilders.FUNCTION_CHEMICALSTACK_TO_LONG.build(chemicalStack -> Optional.ofNullable((ChemicalFuel)chemicalStack.getData(MekanismDataMapTypes.INSTANCE.chemicalFuel())).map(ChemicalFuel::energyPerTick).orElse(0L))).build());
    public static final IOperator OBJECT_CHEMICALSTACK_ISRAWCHEMICALEQUAL = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_2.output((IValueType)ValueTypes.BOOLEAN).symbol("=Raw=").operatorName("israwchemicalequal").interactName("isRawEqual").function(variables -> {
        ValueObjectTypeChemicalStack.ValueChemicalStack valueChemicalStack0 = (ValueObjectTypeChemicalStack.ValueChemicalStack)variables.getValue(0, (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK);
        ValueObjectTypeChemicalStack.ValueChemicalStack valueChemicalStack1 = (ValueObjectTypeChemicalStack.ValueChemicalStack)variables.getValue(1, (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK);
        return ValueTypeBoolean.ValueBoolean.of((boolean)valueChemicalStack0.getRawValue().is(valueChemicalStack1.getRawValue().getChemical()));
    }).build());
    public static final IOperator OBJECT_CHEMICALSTACK_MODNAME = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.STRING).symbolOperatorInteract("mod").function((OperatorBase.IFunction)new IterativeFunction((List)Lists.newArrayList((Object[])new IOperatorValuePropagator[]{variables -> {
        ValueObjectTypeChemicalStack.ValueChemicalStack a = (ValueObjectTypeChemicalStack.ValueChemicalStack)variables.getValue(0, (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK);
        return ChemicalHelpers.getStackRegistry().getKey((Object)a.getRawValue().getChemical());
    }, OperatorBuilders.PROPAGATOR_RESOURCELOCATION_MODNAME}))).build());
    public static final IOperator OBJECT_CHEMICALSTACK_WITH_AMOUNT = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_2.inputTypes(new IValueType[]{MekanismValueTypes.OBJECT_CHEMICALSTACK, ValueTypes.LONG}).output((IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK).symbolOperator("with_amount").interactName("withAmount").function(variables -> {
        ValueObjectTypeChemicalStack.ValueChemicalStack valueChemicalStack = (ValueObjectTypeChemicalStack.ValueChemicalStack)variables.getValue(0, (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK);
        ValueTypeLong.ValueLong valueLong = (ValueTypeLong.ValueLong)variables.getValue(1, (IValueType)ValueTypes.LONG);
        ChemicalStack chemicalStack = valueChemicalStack.getRawValue().copy();
        chemicalStack.setAmount(valueLong.getRawValue());
        return ValueObjectTypeChemicalStack.ValueChemicalStack.of(chemicalStack);
    }).build());
    public static final IOperator OBJECT_CHEMICALSTACK_TAG = REGISTRY.register(MekanismOperatorBuilders.CHEMICALSTACK_1_SUFFIX_LONG.output((IValueType)ValueTypes.LIST).symbol("chemical_tag_names").operatorName("tag").interactName("tags").function(variables -> {
        ValueObjectTypeChemicalStack.ValueChemicalStack a = (ValueObjectTypeChemicalStack.ValueChemicalStack)variables.getValue(0, (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!a.getRawValue().isEmpty()) {
            a.getRawValue().getTags().map(owningTag -> owningTag.location().toString()).sorted().forEach(value -> builder.add((Object)ValueTypeString.ValueString.of((String)value)));
        }
        return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.STRING, (List)builder.build());
    }).build());
    public static final IOperator OBJECT_CHEMICALSTACK_TAG_STACKS = REGISTRY.register(OperatorBuilders.STRING_1_PREFIX.modId("integratedmekanism").output((IValueType)ValueTypes.LIST).symbol("chemical_tag_values").operatorName("chemicaltag").interactName("chemicalsByTag").inputType((IValueType)ValueTypes.STRING).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG).function(variables -> {
        ValueTypeString.ValueString a = (ValueTypeString.ValueString)variables.getValue(0, (IValueType)ValueTypes.STRING);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!StringUtil.isNullOrEmpty((String)a.getRawValue())) {
            try {
                ChemicalHelpers.getChemicalTagValues(a.getRawValue()).map(ValueObjectTypeChemicalStack.ValueChemicalStack::of).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            }
            catch (ResourceLocationException e) {
                throw new EvaluationException(Component.translatable((String)e.getMessage()));
            }
        }
        return ValueTypeList.ValueList.ofList((IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK, (List)builder.build());
    }).build());
    public static final IOperator INGREDIENTS_CHEMICALS = REGISTRY.register(OperatorBuilders.INGREDIENTS_1_PREFIX_LONG.modId("integratedmekanism").output((IValueType)ValueTypes.LIST).operatorInteract("chemicals").symbol("Ingr.chemicals").function(OperatorBuilders.createFunctionIngredientsList(() -> MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK)).build());
    public static final IOperator INGREDIENTS_WITH_CHEMICAL = REGISTRY.register(MekanismOperatorBuilders.INGREDIENTS_3_CHEMICALSTACK.operatorName("with_chemical").symbol("Ingr.with_chemical").interactName("withChemical").function(variables -> {
        ValueObjectTypeIngredients.ValueIngredients value = (ValueObjectTypeIngredients.ValueIngredients)variables.getValue(0, (IValueType)ValueTypes.OBJECT_INGREDIENTS);
        ValueTypeInteger.ValueInteger index = (ValueTypeInteger.ValueInteger)variables.getValue(1, (IValueType)ValueTypes.INTEGER);
        ValueObjectTypeChemicalStack.ValueChemicalStack chemicalStack = (ValueObjectTypeChemicalStack.ValueChemicalStack)variables.getValue(2, (IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK);
        if (value.getRawValue().isEmpty()) {
            value = ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)new MixedIngredients((Map)Maps.newIdentityHashMap()));
        }
        IMixedIngredients baseIngredients = (IMixedIngredients)value.getRawValue().get();
        return ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)new ExtendedIngredientsSingle(baseIngredients, index.getRawValue(), MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, (Object)chemicalStack.getRawValue()));
    }).build());
    public static final IOperator INGREDIENTS_WITH_CHEMICALS = REGISTRY.register(OperatorBuilders.INGREDIENTS_2_LIST.modId("integratedmekanism").operatorName("with_chemicals").symbol("Ingr.with_chemicals").interactName("withChemicals").function(variables -> {
        ValueObjectTypeIngredients.ValueIngredients valueIngredients = (ValueObjectTypeIngredients.ValueIngredients)variables.getValue(0, (IValueType)ValueTypes.OBJECT_INGREDIENTS);
        ValueTypeList.ValueList list = (ValueTypeList.ValueList)variables.getValue(1, (IValueType)ValueTypes.LIST);
        if (valueIngredients.getRawValue().isEmpty()) {
            valueIngredients = ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)new MixedIngredients((Map)Maps.newIdentityHashMap()));
        }
        IMixedIngredients baseIngredients = (IMixedIngredients)valueIngredients.getRawValue().get();
        return ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)new ExtendedIngredientsList(baseIngredients, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, OperatorBuilders.unwrapIngredientComponentList(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, (ValueTypeList.ValueList)list)));
    }).build());
    public static final IOperator OBJECT_ENTITY_RADIATION = REGISTRY.register(OperatorBuilders.ENTITY_1_SUFFIX_LONG.modId("integratedmekanism").output((IValueType)ValueTypes.DOUBLE).symbolOperatorInteract("radiation").function((OperatorBase.IFunction)OperatorBuilders.FUNCTION_ENTITY_TO_DOUBLE.build(entity -> Optional.ofNullable((IRadiationEntity)entity.getCapability(Capabilities.RADIATION_ENTITY)).map(IRadiationEntity::getRadiation).orElse(0.0))).build());

    private static IOperatorRegistry constructRegistry() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return (IOperatorRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IOperatorRegistry.class);
        }
        return OperatorRegistry.getInstance();
    }

    public static void load() {
    }
}

