/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.value;

import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integratedmekanism.core.CapabilityHelpers;
import org.cyclops.integratedmekanism.core.ChemicalHelpers;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.value.MekanismValueTypes;

public class ValueObjectTypeChemicalStack
extends ValueObjectTypeBase<ValueChemicalStack>
implements IValueTypeNamed<ValueChemicalStack>,
IValueTypeUniquelyNamed<ValueChemicalStack>,
IValueTypeNullable<ValueChemicalStack> {
    public ValueObjectTypeChemicalStack() {
        super("chemicalstack", ValueChemicalStack.class);
    }

    protected String getModId() {
        return "integratedmekanism";
    }

    public ValueChemicalStack getDefault() {
        return ValueChemicalStack.of(ChemicalStack.EMPTY);
    }

    public MutableComponent toCompactString(ValueChemicalStack value) {
        ChemicalStack chemicalStack = value.getRawValue();
        return !chemicalStack.isEmpty() ? ((MutableComponent)chemicalStack.getTextComponent()).append(String.format(" (%s mB)", chemicalStack.getAmount())) : Component.literal((String)"");
    }

    public Tag serialize(ValueDeseralizationContext valueDeseralizationContext, ValueChemicalStack value) {
        return MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK.getSerializer().serializeInstance(valueDeseralizationContext.holderLookupProvider(), (Object)value.chemicalStack);
    }

    public ValueChemicalStack deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        if (value instanceof CompoundTag) {
            return ValueChemicalStack.of((ChemicalStack)MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK.getSerializer().deserializeInstance(valueDeseralizationContext.holderLookupProvider(), value));
        }
        return null;
    }

    public String getName(ValueChemicalStack a) {
        return this.toCompactString(a).getString();
    }

    public boolean isNull(ValueChemicalStack a) {
        return a.getRawValue().isEmpty();
    }

    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement((IValueType)this, (ValueTypeItemStackLPElement.IItemStackToValue)new ValueTypeItemStackLPElement.IItemStackToValue<ValueChemicalStack>(this){

            public boolean isNullable() {
                return true;
            }

            public Component validate(ItemStack itemStack) {
                return itemStack.isEmpty() || CapabilityHelpers.getChemicalHandler(itemStack).isPresent() ? null : Component.translatable((String)"valuetype.integratedmekanism.error.chemical.no_chemical");
            }

            public ValueChemicalStack getValue(ItemStack itemStack) {
                return ValueChemicalStack.of(CapabilityHelpers.getChemicalHandler(itemStack).filter(handler -> handler.getChemicalTanks() > 0).map(handler -> handler.getChemicalInTank(0)).orElse(ChemicalStack.EMPTY));
            }

            public ItemStack getValueAsItemStack(ValueChemicalStack value) {
                return ValueObjectTypeChemicalStack.valueToItemStack(value.getRawValue());
            }
        });
    }

    public static ItemStack valueToItemStack(ChemicalStack chemicalStack) {
        ItemStack itemStack = new ItemStack((ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK);
        IChemicalHandler handler = (IChemicalHandler)itemStack.getCapability(Capabilities.CHEMICAL.item());
        if (handler != null) {
            handler.insertChemical(chemicalStack, Action.EXECUTE);
        }
        return itemStack;
    }

    public String getUniqueName(ValueChemicalStack value) {
        ChemicalStack chemicalStack = value.getRawValue();
        return !chemicalStack.isEmpty() ? String.format("%s %s", ChemicalHelpers.getStackRegistry().getKey((Object)chemicalStack.getChemical()), chemicalStack.getAmount()) : "";
    }

    public static class ValueChemicalStack
    extends ValueBase {
        private final ChemicalStack chemicalStack;

        private ValueChemicalStack(ChemicalStack itemStack) {
            super((IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK);
            this.chemicalStack = Objects.requireNonNull(itemStack, "Attempted to create a ValueChemicalStack for a null ChemicalStack.");
        }

        public static ValueChemicalStack of(ChemicalStack itemStack) {
            return new ValueChemicalStack(itemStack);
        }

        public ChemicalStack getRawValue() {
            return this.chemicalStack;
        }

        public boolean equals(Object o) {
            return o instanceof ValueChemicalStack && this.getRawValue().equals((Object)((ValueChemicalStack)((Object)o)).getRawValue());
        }

        public int hashCode() {
            return this.chemicalStack.hashCode();
        }

        public String toString() {
            return "ValueChemicalStack{chemicalStack=" + String.valueOf(this.chemicalStack) + "}";
        }
    }
}

