/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.capability.recipehandler;

import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.machine.TileEntityAntiprotonicNucleosynthesizer;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import mekanism.common.tile.machine.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.machine.TileEntityChemicalInfuser;
import mekanism.common.tile.machine.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.machine.TileEntityChemicalOxidizer;
import mekanism.common.tile.machine.TileEntityChemicalWasher;
import mekanism.common.tile.machine.TileEntityCombiner;
import mekanism.common.tile.machine.TileEntityCrusher;
import mekanism.common.tile.machine.TileEntityElectrolyticSeparator;
import mekanism.common.tile.machine.TileEntityEnergizedSmelter;
import mekanism.common.tile.machine.TileEntityEnrichmentChamber;
import mekanism.common.tile.machine.TileEntityIsotopicCentrifuge;
import mekanism.common.tile.machine.TileEntityMetallurgicInfuser;
import mekanism.common.tile.machine.TileEntityOsmiumCompressor;
import mekanism.common.tile.machine.TileEntityPaintingMachine;
import mekanism.common.tile.machine.TileEntityPigmentExtractor;
import mekanism.common.tile.machine.TileEntityPigmentMixer;
import mekanism.common.tile.machine.TileEntityPrecisionSawmill;
import mekanism.common.tile.machine.TileEntityPressurizedReactionChamber;
import mekanism.common.tile.machine.TileEntityPurificationChamber;
import mekanism.common.tile.machine.TileEntityRotaryCondensentrator;
import mekanism.common.tile.machine.TileEntitySolarNeutronActivator;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationController;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationValve;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorLogicAdapter;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.commoncapabilities.capability.recipehandler.RecipeHandlerConfig;
import org.cyclops.commoncapabilities.capability.temperature.TemperatureConfig;
import org.cyclops.commoncapabilities.capability.worker.WorkerConfig;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;
import org.cyclops.integratedmekanism.IntegratedMekanism;
import org.cyclops.integratedmekanism.capability.recipehandler.ChemicalChemicalToChemicalRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ChemicalCrystallizerRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ChemicalDissolutionRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ChemicalToChemicalRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.CombinerRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.FluidChemicalToChemicalRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.FluidToFluidRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ItemChemicalToItemRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ItemToChemicalRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.ItemToItemRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.MekanismRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.PressurizedReactionRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.RotaryRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.SawmillRecipeHandler;
import org.cyclops.integratedmekanism.capability.recipehandler.SeparatingRecipeHandler;
import org.cyclops.integratedmekanism.capability.temperature.FissionReactorTemperature;
import org.cyclops.integratedmekanism.capability.worker.FissionReactorWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MekanismCapabilityLoader {
    public static void load() {
        CapabilityConstructorRegistry registry = IntegratedMekanism._instance.getCapabilityConstructorRegistry();
        registry.registerTile(TileEntityFissionReactorLogicAdapter.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, TileEntityFissionReactorLogicAdapter>(){

            public Capability<IWorker> getCapability() {
                return WorkerConfig.CAPABILITY;
            }

            @javax.annotation.Nullable
            public ICapabilityProvider createProvider(TileEntityFissionReactorLogicAdapter host) {
                return new DefaultCapabilityProvider(this::getCapability, (Object)new FissionReactorWorker(host));
            }
        });
        registry.registerTile(TileEntityFissionReactorLogicAdapter.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, TileEntityFissionReactorLogicAdapter>(){

            public Capability<ITemperature> getCapability() {
                return TemperatureConfig.CAPABILITY;
            }

            @javax.annotation.Nullable
            public ICapabilityProvider createProvider(TileEntityFissionReactorLogicAdapter host) {
                return new DefaultCapabilityProvider(this::getCapability, (Object)new FissionReactorTemperature(host));
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> MekanismRecipeHandler.CACHED_RECIPES.clear());
        final IdentityHashMap recipeTypeHandlers = Maps.newIdentityHashMap();
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityCrusher.class, MekanismRecipeType.CRUSHING, level -> new ItemToItemRecipeHandler((IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?>)MekanismRecipeType.CRUSHING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityEnrichmentChamber.class, MekanismRecipeType.ENRICHING, level -> new ItemToItemRecipeHandler((IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?>)MekanismRecipeType.ENRICHING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityEnergizedSmelter.class, MekanismRecipeType.SMELTING, level -> new ItemToItemRecipeHandler((IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?>)MekanismRecipeType.SMELTING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityChemicalInfuser.class, MekanismRecipeType.CHEMICAL_INFUSING, level -> new ChemicalChemicalToChemicalRecipeHandler(MekanismRecipeType.CHEMICAL_INFUSING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityCombiner.class, MekanismRecipeType.COMBINING, CombinerRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityElectrolyticSeparator.class, MekanismRecipeType.SEPARATING, SeparatingRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityChemicalWasher.class, MekanismRecipeType.WASHING, level -> new FluidChemicalToChemicalRecipeHandler(MekanismRecipeType.WASHING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityThermalEvaporationController.class, MekanismRecipeType.EVAPORATING, level -> new FluidToFluidRecipeHandler((IMekanismRecipeTypeProvider<? extends FluidToFluidRecipe, ?>)MekanismRecipeType.EVAPORATING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityThermalEvaporationValve.class, MekanismRecipeType.EVAPORATING, level -> new FluidToFluidRecipeHandler((IMekanismRecipeTypeProvider<? extends FluidToFluidRecipe, ?>)MekanismRecipeType.EVAPORATING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntitySolarNeutronActivator.class, MekanismRecipeType.ACTIVATING, level -> new ChemicalToChemicalRecipeHandler(MekanismRecipeType.ACTIVATING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityIsotopicCentrifuge.class, MekanismRecipeType.CENTRIFUGING, level -> new ChemicalToChemicalRecipeHandler(MekanismRecipeType.CENTRIFUGING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityChemicalCrystallizer.class, MekanismRecipeType.CRYSTALLIZING, ChemicalCrystallizerRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityChemicalDissolutionChamber.class, MekanismRecipeType.DISSOLUTION, ChemicalDissolutionRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityOsmiumCompressor.class, MekanismRecipeType.COMPRESSING, level -> new ItemChemicalToItemRecipeHandler(MekanismRecipeType.COMPRESSING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityPurificationChamber.class, MekanismRecipeType.PURIFYING, level -> new ItemChemicalToItemRecipeHandler(MekanismRecipeType.PURIFYING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityChemicalInjectionChamber.class, MekanismRecipeType.INJECTING, level -> new ItemChemicalToItemRecipeHandler(MekanismRecipeType.INJECTING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityAntiprotonicNucleosynthesizer.class, MekanismRecipeType.NUCLEOSYNTHESIZING, level -> new ItemChemicalToItemRecipeHandler(MekanismRecipeType.NUCLEOSYNTHESIZING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityChemicalOxidizer.class, MekanismRecipeType.OXIDIZING, level -> new ItemToChemicalRecipeHandler(MekanismRecipeType.OXIDIZING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityPigmentExtractor.class, MekanismRecipeType.PIGMENT_EXTRACTING, level -> new ItemToChemicalRecipeHandler(MekanismRecipeType.PIGMENT_EXTRACTING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityPigmentMixer.class, MekanismRecipeType.PIGMENT_MIXING, level -> new ChemicalChemicalToChemicalRecipeHandler(MekanismRecipeType.PIGMENT_MIXING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityMetallurgicInfuser.class, MekanismRecipeType.METALLURGIC_INFUSING, level -> new ItemChemicalToItemRecipeHandler(MekanismRecipeType.METALLURGIC_INFUSING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityPaintingMachine.class, MekanismRecipeType.PAINTING, level -> new ItemChemicalToItemRecipeHandler(MekanismRecipeType.PAINTING, (Supplier<Level>)level));
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityPressurizedReactionChamber.class, MekanismRecipeType.REACTION, PressurizedReactionRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityRotaryCondensentrator.class, MekanismRecipeType.ROTARY, RotaryRecipeHandler::new);
        MekanismCapabilityLoader.addRecipeHandler(registry, recipeTypeHandlers, TileEntityPrecisionSawmill.class, MekanismRecipeType.SAWING, SawmillRecipeHandler::new);
        registry.registerInheritableTile(TileEntityFactory.class, new ICapabilityConstructor<IRecipeHandler, TileEntityFactory<?>, TileEntityFactory<?>>(){

            public Capability<IRecipeHandler> getCapability() {
                return RecipeHandlerConfig.CAPABILITY;
            }

            @javax.annotation.Nullable
            public ICapabilityProvider createProvider(TileEntityFactory<?> hostType, final TileEntityFactory<?> host) {
                return new ICapabilityProvider(){

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
                        Function handler;
                        if (capability == RecipeHandlerConfig.CAPABILITY && (handler = (Function)recipeTypeHandlers.get(host.getRecipeType())) != null) {
                            return LazyOptional.of(() -> (IRecipeHandler)handler.apply(() -> ((TileEntityFactory)host).m_58904_())).cast();
                        }
                        return LazyOptional.empty();
                    }
                };
            }
        });
    }

    protected static <T extends BlockEntity> void addRecipeHandler(CapabilityConstructorRegistry registry, Map<IMekanismRecipeTypeProvider<?, ?>, Function<Supplier<Level>, IRecipeHandler>> recipeTypeHandlers, Class<T> clazz, IMekanismRecipeTypeProvider<?, ?> recipeType, final Function<Supplier<Level>, IRecipeHandler> recipeHandlerConstructor) {
        registry.registerTile(clazz, new ICapabilityConstructor<IRecipeHandler, T, T>(){

            public Capability<IRecipeHandler> getCapability() {
                return RecipeHandlerConfig.CAPABILITY;
            }

            @javax.annotation.Nullable
            public ICapabilityProvider createProvider(T hostType, T host) {
                return new DefaultCapabilityProvider(this::getCapability, (Object)((IRecipeHandler)recipeHandlerConstructor.apply(() -> host.m_58904_())));
            }
        });
        recipeTypeHandlers.put(recipeType, recipeHandlerConstructor);
    }
}

