/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.capability.recipehandler;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedmekanism.capability.recipehandler.MekanismRecipeHandler;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;

public class SeparatingRecipeHandler
extends MekanismRecipeHandler<ElectrolysisRecipe> {
    protected SeparatingRecipeHandler(Supplier<Level> levelSupplier) {
        super(MekanismRecipeType.SEPARATING, levelSupplier, Set.of(IngredientComponents.FLUIDSTACK), Set.of(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK));
    }

    public boolean isValidSizeInput(IngredientComponent<?, ?> ingredientComponent, int size) {
        return ingredientComponent == IngredientComponents.FLUIDSTACK && size == 1;
    }

    @Override
    protected void recipeToInputs(ElectrolysisRecipe recipe, Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs) {
        inputs.put(IngredientComponents.FLUIDSTACK, List.of(new PrototypedIngredientAlternativesList(SeparatingRecipeHandler.getPrototypesFromFluidIngredient((InputIngredient<FluidStack>)recipe.getInput()))));
    }

    @Override
    protected void recipeToOutputs(ElectrolysisRecipe recipe, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        ElectrolysisRecipe.ElectrolysisRecipeOutput output = (ElectrolysisRecipe.ElectrolysisRecipeOutput)recipe.getOutputDefinition().get(0);
        outputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, Lists.newArrayList((Object[])new GasStack[]{output.left(), output.right()}));
    }

    @Override
    protected void recipeToOutputsSimulated(ElectrolysisRecipe recipe, IMixedIngredients input, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        ElectrolysisRecipe.ElectrolysisRecipeOutput output = recipe.getOutput((FluidStack)input.getInstances(IngredientComponents.FLUIDSTACK).get(0));
        outputs.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new GasStack[]{output.left(), output.right()}));
    }

    @Override
    protected boolean doesRecipeMatchInput(ElectrolysisRecipe recipe, IMixedIngredients input) {
        return recipe.getInput().test((Object)((FluidStack)input.getInstances(IngredientComponents.FLUIDSTACK).get(0)));
    }
}

