/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.core;

import com.google.common.collect.Streams;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.providers.IPigmentProvider;
import mekanism.api.providers.ISlurryProvider;
import mekanism.common.registries.MekanismGases;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.ForgeRegistry;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedmekanism.core.predicate.IngredientPredicateChemicalStackList;
import org.cyclops.integratedmekanism.core.predicate.IngredientPredicateChemicalStackOperator;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;

public class ChemicalHelpers {
    public static final long BUCKET_VOLUME = 1000L;
    public static final IngredientPredicate<ChemicalStack<?>, Integer> MATCH_NONE = new IngredientPredicate<ChemicalStack<?>, Integer>(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, (ChemicalStack)GasStack.EMPTY, 3, false, true, 0, false){

        public boolean test(ChemicalStack input) {
            return false;
        }

        public boolean equals(Object obj) {
            return obj == MATCH_NONE;
        }

        public int hashCode() {
            return 9991029;
        }
    };

    public static ForgeRegistry<Chemical> getStackRegistry(ChemicalStack<?> instance) {
        if (instance instanceof GasStack) {
            return (ForgeRegistry)MekanismAPI.gasRegistry();
        }
        if (instance instanceof InfusionStack) {
            return (ForgeRegistry)MekanismAPI.infuseTypeRegistry();
        }
        if (instance instanceof PigmentStack) {
            return (ForgeRegistry)MekanismAPI.pigmentRegistry();
        }
        if (instance instanceof SlurryStack) {
            return (ForgeRegistry)MekanismAPI.slurryRegistry();
        }
        throw new IllegalArgumentException("Unknown chemical stack: " + String.valueOf(instance));
    }

    public static IngredientPredicate<ChemicalStack<?>, Integer> matchAll(long amount, boolean exactAmount) {
        return new IngredientPredicate<ChemicalStack<?>, Integer>(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, (ChemicalStack)new GasStack((IGasProvider)MekanismGases.HYDROGEN, amount), exactAmount ? 2 : 0, false, false, (int)amount, exactAmount){

            public boolean test(ChemicalStack input) {
                return true;
            }
        };
    }

    protected static int getChemicalStackMatchFlags(boolean checkChemical, boolean checkAmount) {
        int matchFlags = 0;
        if (checkChemical) {
            matchFlags |= 1;
        }
        if (checkAmount) {
            matchFlags |= 2;
        }
        return matchFlags;
    }

    public static IngredientPredicate<ChemicalStack<?>, Integer> matchChemicalStack(final ChemicalStack<?> chemicalStack, final boolean checkChemical, final boolean checkAmount, final boolean blacklist, boolean exactAmount) {
        return new IngredientPredicate<ChemicalStack<?>, Integer>(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, chemicalStack != null ? chemicalStack.copy() : null, ChemicalHelpers.getChemicalStackMatchFlags(checkChemical, checkAmount), blacklist, chemicalStack == null && !blacklist, chemicalStack == null ? 0 : (int)chemicalStack.getAmount(), exactAmount){

            public boolean test(@Nullable ChemicalStack input) {
                boolean result = ChemicalHelpers.areChemicalStackEqual(input, chemicalStack, checkChemical, checkAmount);
                if (blacklist) {
                    result = !result;
                }
                return result;
            }
        };
    }

    public static IngredientPredicate<ChemicalStack<?>, Integer> matchChemicalStacks(IValueTypeListProxy<ValueObjectTypeChemicalStack, ValueObjectTypeChemicalStack.ValueChemicalStack> chemicalStacks, boolean checkChemical, boolean checkAmount, boolean blacklist, long amount, boolean exactAmount) {
        return new IngredientPredicateChemicalStackList(blacklist, amount, exactAmount, chemicalStacks, ChemicalHelpers.getChemicalStackMatchFlags(checkChemical, checkAmount), checkChemical, checkAmount);
    }

    public static IngredientPredicate<ChemicalStack<?>, Integer> matchPredicate(PartTarget partTarget, IOperator predicate, long amount, boolean exactAmount) {
        return new IngredientPredicateChemicalStackOperator(amount, exactAmount, predicate, partTarget);
    }

    public static boolean areChemicalStackEqual(ChemicalStack<?> stackA, ChemicalStack<?> stackB, boolean checkChemical, boolean checkAmount) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            if (checkAmount && stackA.getAmount() != stackB.getAmount()) {
                return false;
            }
            return !checkChemical || stackA.getType() == stackB.getType();
        }
        return false;
    }

    public static ChemicalStack<?> prototypeWithCount(ChemicalStack<?> prototype, long count) {
        if (prototype == null || prototype.getAmount() != count) {
            if (prototype == null || prototype.isEmpty()) {
                return count == 0L ? null : new GasStack((IGasProvider)MekanismGases.HYDROGEN, count);
            }
            prototype = prototype.copy();
            prototype.setAmount(count);
        }
        return prototype;
    }

    public static Stream<ChemicalStack<?>> getChemicalTagValues(String name) throws ResourceLocationException {
        return Streams.concat((Stream[])new Stream[]{MekanismAPI.gasRegistry().tags().getTag(TagKey.m_203882_((ResourceKey)MekanismAPI.GAS_REGISTRY_NAME, (ResourceLocation)new ResourceLocation(name))).stream().map(chemical -> new GasStack((IGasProvider)chemical, 1000L)), MekanismAPI.infuseTypeRegistry().tags().getTag(TagKey.m_203882_((ResourceKey)MekanismAPI.INFUSE_TYPE_REGISTRY_NAME, (ResourceLocation)new ResourceLocation(name))).stream().map(chemical -> new InfusionStack((IInfuseTypeProvider)chemical, 1000L)), MekanismAPI.pigmentRegistry().tags().getTag(TagKey.m_203882_((ResourceKey)MekanismAPI.PIGMENT_REGISTRY_NAME, (ResourceLocation)new ResourceLocation(name))).stream().map(chemical -> new PigmentStack((IPigmentProvider)chemical, 1000L)), MekanismAPI.slurryRegistry().tags().getTag(TagKey.m_203882_((ResourceKey)MekanismAPI.SLURRY_REGISTRY_NAME, (ResourceLocation)new ResourceLocation(name))).stream().map(chemical -> new SlurryStack((ISlurryProvider)chemical, 1000L))});
    }
}

