/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.ingredient;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.integratedmekanism.ingredient.ChemicalHandlerChemicalStackIterator;
import org.cyclops.integratedmekanism.ingredient.ChemicalMatch;
import org.cyclops.integratedmekanism.network.ChemicalNetwork;

public abstract class IngredientComponentStorageWrapperHandlerChemicalStack<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, C extends IChemicalHandler<CHEMICAL, STACK>>
implements IIngredientComponentStorageWrapperHandler<ChemicalStack<?>, Integer, C> {
    private final IngredientComponent<ChemicalStack<?>, Integer> ingredientComponent;
    private final Capability<C> handlerCapability;

    public IngredientComponentStorageWrapperHandlerChemicalStack(IngredientComponent<ChemicalStack<?>, Integer> ingredientComponent, Capability<C> handlerCapability) {
        this.ingredientComponent = Objects.requireNonNull(ingredientComponent);
        this.handlerCapability = handlerCapability;
    }

    public static Action simulateToChemicalAction(boolean simulate) {
        return simulate ? Action.SIMULATE : Action.EXECUTE;
    }

    public static boolean chemicalActionToSimulate(Action chemicalAction) {
        return chemicalAction.simulate();
    }

    public IIngredientComponentStorage<ChemicalStack<?>, Integer> wrapComponentStorage(C storage) {
        return new ComponentStorageWrapper(this.getComponent(), storage);
    }

    public LazyOptional<C> getStorage(ICapabilityProvider capabilityProvider, @Nullable Direction facing) {
        return capabilityProvider.getCapability(this.handlerCapability, facing).cast();
    }

    public IngredientComponent<ChemicalStack<?>, Integer> getComponent() {
        return this.ingredientComponent;
    }

    public static class ComponentStorageWrapper<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, C extends IChemicalHandler<CHEMICAL, STACK>>
    implements IIngredientComponentStorage<STACK, Integer> {
        private final IngredientComponent<STACK, Integer> ingredientComponent;
        private final C storage;

        public ComponentStorageWrapper(IngredientComponent<STACK, Integer> ingredientComponent, C storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        public IngredientComponent<STACK, Integer> getComponent() {
            return this.ingredientComponent;
        }

        public Iterator<STACK> iterator() {
            return new ChemicalHandlerChemicalStackIterator(this.storage);
        }

        public Iterator<STACK> iterator(@Nonnull STACK prototype, Integer matchFlags) {
            if (((Integer)this.getComponent().getMatcher().getAnyMatchCondition()).equals(matchFlags)) {
                return this.iterator();
            }
            return new FilteredIngredientCollectionIterator(this.iterator(), this.getComponent().getMatcher(), prototype, (Object)matchFlags);
        }

        public long getMaxQuantity() {
            long sum = 0L;
            for (int i = 0; i < this.storage.getTanks(); ++i) {
                sum = Math.addExact(sum, this.storage.getTankCapacity(i));
            }
            return sum;
        }

        public STACK insert(@Nonnull STACK ingredient, boolean simulate) {
            if (ingredient.isEmpty()) {
                return (STACK)((ChemicalStack)this.getComponent().getMatcher().getEmptyInstance());
            }
            try {
                return (STACK)this.storage.insertChemical(ingredient, IngredientComponentStorageWrapperHandlerChemicalStack.simulateToChemicalAction(simulate));
            }
            catch (ClassCastException e) {
                return ingredient;
            }
        }

        public STACK extract(@Nonnull STACK prototype, Integer matchFlags, boolean simulate) {
            if (prototype.isEmpty()) {
                return (STACK)((ChemicalStack)this.getComponent().getMatcher().getEmptyInstance());
            }
            if (matchFlags == 0) {
                return (STACK)this.storage.extractChemical(prototype.getAmount(), IngredientComponentStorageWrapperHandlerChemicalStack.simulateToChemicalAction(simulate));
            }
            if (matchFlags == 2) {
                ChemicalStack drainedSimulated = this.storage.extractChemical(prototype.getAmount(), Action.SIMULATE);
                if (drainedSimulated.isEmpty() || drainedSimulated.getAmount() != prototype.getAmount()) {
                    return (STACK)((ChemicalStack)this.getComponent().getMatcher().getEmptyInstance());
                }
                return (STACK)(simulate ? drainedSimulated : this.storage.extractChemical(prototype.getAmount(), Action.EXECUTE));
            }
            for (int i = 0; i < this.storage.getTanks(); ++i) {
                ChemicalStack contents = this.storage.getChemicalInTank(i);
                if (contents.isEmpty() || !ChemicalMatch.areStacksEqual(contents, prototype, matchFlags & 0xFFFFFFFD)) continue;
                ChemicalStack toDrain = contents.copy();
                toDrain.setAmount(prototype.getAmount());
                ChemicalStack drained = this.storage.extractChemical(toDrain, IngredientComponentStorageWrapperHandlerChemicalStack.simulateToChemicalAction(simulate));
                if (!ChemicalMatch.areStacksEqual(drained, prototype, matchFlags)) continue;
                return (STACK)drained;
            }
            return (STACK)((ChemicalStack)this.getComponent().getMatcher().getEmptyInstance());
        }

        public STACK extract(long maxQuantity, boolean simulate) {
            return (STACK)this.storage.extractChemical(maxQuantity, IngredientComponentStorageWrapperHandlerChemicalStack.simulateToChemicalAction(simulate));
        }
    }

    public static final class StorageWrapperSlurry
    extends ChemicalStorageWrapper<Slurry, SlurryStack>
    implements ISlurryHandler {
        public StorageWrapperSlurry(IIngredientComponentStorage<ChemicalStack<?>, Integer> storage) {
            super(storage, Capabilities.SLURRY_HANDLER);
        }
    }

    public static final class StorageWrapperSlurrySlotted
    extends ChemicalStorageWrapperSlotted<Slurry, SlurryStack>
    implements ISlurryHandler {
        public StorageWrapperSlurrySlotted(IIngredientComponentStorageSlotted<ChemicalStack<?>, Integer> storage) {
            super(storage, Capabilities.SLURRY_HANDLER);
        }
    }

    public static final class StorageWrapperPigment
    extends ChemicalStorageWrapper<Pigment, PigmentStack>
    implements IPigmentHandler {
        public StorageWrapperPigment(IIngredientComponentStorage<ChemicalStack<?>, Integer> storage) {
            super(storage, Capabilities.PIGMENT_HANDLER);
        }
    }

    public static final class StorageWrapperPigmentSlotted
    extends ChemicalStorageWrapperSlotted<Pigment, PigmentStack>
    implements IPigmentHandler {
        public StorageWrapperPigmentSlotted(IIngredientComponentStorageSlotted<ChemicalStack<?>, Integer> storage) {
            super(storage, Capabilities.PIGMENT_HANDLER);
        }
    }

    public static final class StorageWrapperInfusion
    extends ChemicalStorageWrapper<InfuseType, InfusionStack>
    implements IInfusionHandler {
        public StorageWrapperInfusion(IIngredientComponentStorage<ChemicalStack<?>, Integer> storage) {
            super(storage, Capabilities.INFUSION_HANDLER);
        }
    }

    public static final class StorageWrapperInfusionSlotted
    extends ChemicalStorageWrapperSlotted<InfuseType, InfusionStack>
    implements IInfusionHandler {
        public StorageWrapperInfusionSlotted(IIngredientComponentStorageSlotted<ChemicalStack<?>, Integer> storage) {
            super(storage, Capabilities.INFUSION_HANDLER);
        }
    }

    public static final class StorageWrapperGas
    extends ChemicalStorageWrapper<Gas, GasStack>
    implements IGasHandler {
        public StorageWrapperGas(IIngredientComponentStorage<ChemicalStack<?>, Integer> storage) {
            super(storage, Capabilities.GAS_HANDLER);
        }
    }

    public static final class StorageWrapperGasSlotted
    extends ChemicalStorageWrapperSlotted<Gas, GasStack>
    implements IGasHandler {
        public StorageWrapperGasSlotted(IIngredientComponentStorageSlotted<ChemicalStack<?>, Integer> storage) {
            super(storage, Capabilities.GAS_HANDLER);
        }
    }

    public static abstract class ChemicalStorageWrapperSlotted<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
    extends ChemicalStorageWrapper<CHEMICAL, STACK> {
        private final IIngredientComponentStorageSlotted<ChemicalStack<?>, Integer> storage;

        public ChemicalStorageWrapperSlotted(IIngredientComponentStorageSlotted<ChemicalStack<?>, Integer> storage, Capability<? extends IChemicalHandler<CHEMICAL, STACK>> capability) {
            super((IIngredientComponentStorage<ChemicalStack<?>, Integer>)storage, capability);
            this.storage = storage;
        }

        @Override
        public int getTanks() {
            return this.storage.getSlots();
        }

        @Override
        @Nonnull
        public STACK getChemicalInTank(int tank) {
            int tanks = this.getTanks();
            if (tank < 0 || tank >= tanks) {
                throw new IndexOutOfBoundsException("Tank " + tank + " not in valid range - [0," + tanks + ")");
            }
            this.beforeOperation();
            ChemicalStack ret = (ChemicalStack)this.storage.getSlotContents(tank);
            this.afterOperation();
            return (STACK)ret;
        }

        @Override
        public void setChemicalInTank(int i, STACK stack) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValid(int tank, @Nonnull STACK stack) {
            return true;
        }

        @Override
        public STACK insertChemical(int i, STACK stack, Action action) {
            this.beforeOperation();
            ChemicalStack ret = (ChemicalStack)this.storage.insert(i, stack, IngredientComponentStorageWrapperHandlerChemicalStack.chemicalActionToSimulate(action));
            this.afterOperation();
            return (STACK)ret;
        }

        @Override
        public STACK extractChemical(int i, long l, Action action) {
            this.beforeOperation();
            ChemicalStack ret = (ChemicalStack)this.storage.extract(i, l, IngredientComponentStorageWrapperHandlerChemicalStack.chemicalActionToSimulate(action));
            this.afterOperation();
            return (STACK)ret;
        }
    }

    public static abstract class ChemicalStorageWrapper<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
    implements IChemicalHandler<CHEMICAL, STACK> {
        private final IIngredientComponentStorage<ChemicalStack<?>, Integer> storage;
        private final Capability<? extends IChemicalHandler<CHEMICAL, STACK>> capability;

        public ChemicalStorageWrapper(IIngredientComponentStorage<ChemicalStack<?>, Integer> storage, Capability<? extends IChemicalHandler<CHEMICAL, STACK>> capability) {
            this.storage = storage;
            this.capability = capability;
        }

        public int getTanks() {
            return Iterators.size((Iterator)this.storage.iterator()) + 1;
        }

        @Nonnull
        public STACK getChemicalInTank(int tank) {
            return (STACK)((ChemicalStack)Iterables.get(this.storage, (int)tank, this.getEmptyStack()));
        }

        public long getTankCapacity(int tank) {
            return Long.MAX_VALUE;
        }

        public void setChemicalInTank(int i, STACK stack) {
            throw new UnsupportedOperationException();
        }

        public boolean isValid(int tank, @Nonnull STACK stack) {
            return false;
        }

        protected void beforeOperation() {
            ChemicalNetwork.ACTIVE_CAPABILITY = this.capability;
        }

        protected void afterOperation() {
            ChemicalNetwork.ACTIVE_CAPABILITY = null;
        }

        public STACK insertChemical(int i, STACK stack, Action action) {
            return stack;
        }

        public STACK extractChemical(int i, long l, Action action) {
            return this.getEmptyStack();
        }

        public STACK insertChemical(STACK resource, Action action) {
            this.beforeOperation();
            ChemicalStack ret = (ChemicalStack)this.storage.insert(resource, IngredientComponentStorageWrapperHandlerChemicalStack.chemicalActionToSimulate(action));
            this.afterOperation();
            return (STACK)ret;
        }

        public STACK extractChemical(STACK resource, Action action) {
            this.beforeOperation();
            ChemicalStack ret = (ChemicalStack)this.storage.extract(resource, (Object)3, IngredientComponentStorageWrapperHandlerChemicalStack.chemicalActionToSimulate(action));
            this.afterOperation();
            return (STACK)ret;
        }

        public STACK extractChemical(long maxDrain, Action action) {
            this.beforeOperation();
            ChemicalStack ret = (ChemicalStack)this.storage.extract(maxDrain, IngredientComponentStorageWrapperHandlerChemicalStack.chemicalActionToSimulate(action));
            this.afterOperation();
            return (STACK)ret;
        }

        @Nonnull
        public STACK getEmptyStack() {
            return (STACK)((ChemicalStack)this.storage.getComponent().getMatcher().getEmptyInstance());
        }
    }
}

