/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.ingredient;

import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;

public class IngredientSerializerChemicalStack
implements IIngredientSerializer<ChemicalStack<?>, Integer> {
    public Tag serializeInstance(ChemicalStack<?> chemicalStack) {
        CompoundTag tag = new CompoundTag();
        if (chemicalStack instanceof GasStack) {
            tag.m_128359_("chemical", "mekanism:gas");
        } else if (chemicalStack instanceof InfusionStack) {
            tag.m_128359_("chemical", "mekanism:infuse_type");
        } else if (chemicalStack instanceof PigmentStack) {
            tag.m_128359_("chemical", "mekanism:pigment");
        } else if (chemicalStack instanceof SlurryStack) {
            tag.m_128359_("chemical", "mekanism:slurry");
        }
        tag.m_128359_("type", chemicalStack.getType().getRegistryName().toString());
        tag.m_128356_("amount", chemicalStack.getAmount());
        return tag;
    }

    public ChemicalStack<?> deserializeInstance(Tag tag) throws IllegalArgumentException {
        if (!(tag instanceof CompoundTag)) {
            throw new IllegalArgumentException("This deserializer only accepts CompoundTag");
        }
        CompoundTag compoundTag = (CompoundTag)tag;
        ForgeRegistry chemicalRegistry = RegistryManager.ACTIVE.getRegistry(ResourceLocation.m_135820_((String)compoundTag.m_128461_("chemical")));
        Chemical type = (Chemical)chemicalRegistry.getValue(ResourceLocation.m_135820_((String)compoundTag.m_128461_("type")));
        return type.getStack(compoundTag.m_128454_("amount"));
    }

    public Tag serializeCondition(Integer matchCondition) {
        return IntTag.m_128679_((int)matchCondition);
    }

    public Integer deserializeCondition(Tag tag) throws IllegalArgumentException {
        if (!(tag instanceof IntTag)) {
            throw new IllegalArgumentException("This deserializer only accepts IntTag");
        }
        return ((IntTag)tag).m_7047_();
    }
}

