/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.modcompat.integratedterminals;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistry;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.client.gui.GuiGraphicsExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integratedmekanism.GeneralConfig;
import org.cyclops.integratedmekanism.core.CapabilityHelpers;
import org.cyclops.integratedmekanism.core.ChemicalHelpers;
import org.cyclops.integratedmekanism.modcompat.integratedterminals.sorter.ChemicalStackIdSorter;
import org.cyclops.integratedmekanism.modcompat.integratedterminals.sorter.ChemicalStackNameSorter;
import org.cyclops.integratedmekanism.modcompat.integratedterminals.sorter.ChemicalStackQuantitySorter;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;
import org.jetbrains.annotations.Nullable;

public class IngredientComponentTerminalStorageHandlerChemicalStack
implements IIngredientComponentTerminalStorageHandler<ChemicalStack<?>, Integer> {
    private final IngredientComponent<ChemicalStack<?>, Integer> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerChemicalStack(IngredientComponent<ChemicalStack<?>, Integer> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    public IngredientComponent<ChemicalStack<?>, Integer> getComponent() {
        return this.ingredientComponent;
    }

    public ItemStack getIcon() {
        return new ItemStack((ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInstance(GuiGraphics guiGraphics, ChemicalStack<?> instance, long maxQuantity, @javax.annotation.Nullable String label, AbstractContainerScreen gui, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY, @javax.annotation.Nullable List<Component> additionalTooltipLines) {
        if (instance != null) {
            if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
                Chemical chemical = instance.getType();
                MekanismRenderer.color((GuiGraphics)guiGraphics, (Chemical)chemical);
                GuiUtils.drawTiledSprite((GuiGraphics)guiGraphics, (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (TextureAtlasSprite)MekanismRenderer.getSprite((ResourceLocation)chemical.getIcon()), (int)16, (int)16, (int)100, (GuiUtils.TilingDirection)GuiUtils.TilingDirection.UP_RIGHT);
                MekanismRenderer.resetColor((GuiGraphics)guiGraphics);
                GuiGraphicsExtended renderItem = new GuiGraphicsExtended(guiGraphics);
                renderItem.drawSlotText(Minecraft.m_91087_().f_91062_, label != null ? label : GuiHelpers.quantityToScaledString((long)instance.getAmount()), x, y);
            } else {
                GuiHelpers.renderTooltip((AbstractContainerScreen)gui, (PoseStack)guiGraphics.m_280168_(), (int)x, (int)y, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (int)mouseX, (int)mouseY, () -> {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(((MutableComponent)instance.getTextComponent()).m_130948_(Style.f_131099_.m_178520_(instance.getChemicalColorRepresentation())));
                    ChemicalUtil.addChemicalDataToTooltip((List)lines, (Chemical)instance.getType(), (boolean)false);
                    this.addQuantityTooltip(lines, instance);
                    if (additionalTooltipLines != null) {
                        lines.addAll(additionalTooltipLines);
                    }
                    return lines;
                });
            }
        }
    }

    public String formatQuantity(ChemicalStack<?> instance) {
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.tooltip.fluid.amount", (Object[])new Object[]{String.format(Locale.ROOT, "%,d", instance.getAmount())});
    }

    public boolean isInstance(ItemStack itemStack) {
        return itemStack.getCapability(Capabilities.GAS_HANDLER).isPresent() || itemStack.getCapability(Capabilities.INFUSION_HANDLER).isPresent() || itemStack.getCapability(Capabilities.PIGMENT_HANDLER).isPresent() || itemStack.getCapability(Capabilities.SLURRY_HANDLER).isPresent();
    }

    public ChemicalStack<?> getInstance(ItemStack itemStack) {
        return (ChemicalStack)CapabilityHelpers.getChemicalHandler(itemStack).map(handler -> handler.getTanks() > 0 ? handler.getChemicalInTank(0) : handler.getEmptyStack()).orElse(GasStack.EMPTY);
    }

    public long getMaxQuantity(ItemStack itemStack) {
        return CapabilityHelpers.getChemicalHandler(itemStack).map(handler -> handler.getTanks() > 0 ? handler.getTankCapacity(0) : 0L).orElse(0L);
    }

    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageChemicalInitialQuantity;
    }

    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageChemicalIncrementalQuantity;
    }

    public int throwIntoWorld(IIngredientComponentStorage<ChemicalStack<?>, Integer> storage, ChemicalStack<?> chemicalStack, Player player) {
        return 0;
    }

    protected IIngredientComponentStorage<ChemicalStack<?>, Integer> getChemicalStorage(IngredientComponent<ChemicalStack<?>, Integer> component, IChemicalHandler<?, ?> chemicalHandler) {
        if (chemicalHandler instanceof IGasHandler) {
            IGasHandler gasHandler = (IGasHandler)chemicalHandler;
            return component.getStorageWrapperHandler(Capabilities.GAS_HANDLER).wrapComponentStorage((Object)gasHandler);
        }
        if (chemicalHandler instanceof IInfusionHandler) {
            IInfusionHandler infusionHandler = (IInfusionHandler)chemicalHandler;
            return component.getStorageWrapperHandler(Capabilities.INFUSION_HANDLER).wrapComponentStorage((Object)infusionHandler);
        }
        if (chemicalHandler instanceof IPigmentHandler) {
            IPigmentHandler pigmentHandler = (IPigmentHandler)chemicalHandler;
            return component.getStorageWrapperHandler(Capabilities.PIGMENT_HANDLER).wrapComponentStorage((Object)pigmentHandler);
        }
        if (chemicalHandler instanceof ISlurryHandler) {
            ISlurryHandler slurryHandler = (ISlurryHandler)chemicalHandler;
            return component.getStorageWrapperHandler(Capabilities.SLURRY_HANDLER).wrapComponentStorage((Object)slurryHandler);
        }
        throw new UnsupportedOperationException("Unknown chemical handler " + String.valueOf(chemicalHandler));
    }

    public ChemicalStack<?> insertIntoContainer(IIngredientComponentStorage<ChemicalStack<?>, Integer> storage, AbstractContainerMenu container, int containerSlot, ChemicalStack<?> maxInstance, @Nullable Player player, boolean transferFullSelection) {
        ItemStack stack = container.m_38853_(containerSlot).m_7993_();
        return (ChemicalStack)CapabilityHelpers.getChemicalHandler(stack).map(chemicalHandler -> {
            IIngredientComponentStorage<ChemicalStack<?>, Integer> itemStorage = this.getChemicalStorage((IngredientComponent<ChemicalStack<?>, Integer>)storage.getComponent(), (IChemicalHandler<?, ?>)chemicalHandler);
            GasStack moved = GasStack.EMPTY;
            try {
                moved = (ChemicalStack)IngredientStorageHelpers.moveIngredientsIterative((IIngredientComponentStorage)storage, itemStorage, (Object)maxInstance, (Object)((Integer)this.ingredientComponent.getMatcher().getExactMatchNoQuantityCondition()), (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
            container.m_38946_();
            return moved;
        }).orElse(GasStack.EMPTY);
    }

    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<ChemicalStack<?>, Integer> storage, AbstractContainerMenu container, Inventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = container.m_142621_();
        CapabilityHelpers.getChemicalHandler(playerStack).ifPresent(chemicalHandler -> {
            IIngredientComponentStorage<ChemicalStack<?>, Integer> itemStorage = this.getChemicalStorage((IngredientComponent<ChemicalStack<?>, Integer>)storage.getComponent(), (IChemicalHandler<?, ?>)chemicalHandler);
            try {
                IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)moveQuantityPlayerSlot, (boolean)false);
            }
            catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                // empty catch block
            }
        });
    }

    public void extractMaxFromContainerSlot(IIngredientComponentStorage<ChemicalStack<?>, Integer> storage, AbstractContainerMenu container, int containerSlot, Inventory playerInventory, int limit) {
        Slot slot = container.m_38853_(containerSlot);
        if (slot.m_8010_(playerInventory.f_35978_)) {
            ItemStack toMoveStack = slot.m_7993_();
            CapabilityHelpers.getChemicalHandler(toMoveStack).ifPresent(chemicalHandler -> {
                IIngredientComponentStorage<ChemicalStack<?>, Integer> itemStorage = this.getChemicalStorage((IngredientComponent<ChemicalStack<?>, Integer>)storage.getComponent(), (IChemicalHandler<?, ?>)chemicalHandler);
                try {
                    IngredientStorageHelpers.moveIngredientsIterative(itemStorage, (IIngredientComponentStorage)storage, (long)(limit == -1 ? Long.MAX_VALUE : (long)limit), (boolean)false);
                }
                catch (InconsistentIngredientInsertionException inconsistentIngredientInsertionException) {
                    // empty catch block
                }
            });
        }
    }

    public long getActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container) {
        ItemStack toMoveStack = container.m_142621_();
        return CapabilityHelpers.getChemicalHandler(toMoveStack).map(chemicalHandler -> chemicalHandler.getTanks() > 0 ? chemicalHandler.getChemicalInTank(0).getAmount() : 0L).orElse(0L);
    }

    public void drainActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container, long quantityIn) {
        ItemStack toMoveStack = container.m_142621_();
        CapabilityHelpers.getChemicalHandler(toMoveStack).ifPresent(chemicalHandler -> {
            long drained;
            for (long quantity = quantityIn; quantity > 0L && (drained = chemicalHandler.extractChemical(quantity, Action.EXECUTE).getAmount()) > 0L; quantity -= drained) {
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public Predicate<ChemicalStack<?>> getInstanceFilterPredicate(SearchMode searchMode, String query) {
        return switch (searchMode) {
            default -> throw new IncompatibleClassChangeError();
            case SearchMode.MOD -> i -> ChemicalHelpers.getStackRegistry(i).getKey((Object)i.getType()).m_135827_().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
            case SearchMode.TOOLTIP -> i -> false;
            case SearchMode.TAG -> i -> {
                ForgeRegistry<Chemical> registry = ChemicalHelpers.getStackRegistry(i);
                return registry.tags().getReverseTag((Object)i.getType()).map(reverseTag -> reverseTag.getTagKeys().filter(tag -> tag.f_203868_().toString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*")).anyMatch(tag -> !registry.tags().getTag(tag).isEmpty())).orElse(false);
            };
            case SearchMode.DEFAULT -> i -> i != null && i.getTextComponent().getString().toLowerCase(Locale.ENGLISH).matches(".*" + query + ".*");
        };
    }

    public Collection<IIngredientInstanceSorter<ChemicalStack<?>>> getInstanceSorters() {
        return Lists.newArrayList((Object[])new IIngredientInstanceSorter[]{new ChemicalStackNameSorter(), new ChemicalStackIdSorter(), new ChemicalStackQuantitySorter()});
    }
}

