/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.modcompat.integratedtunnels.part;

import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraftforge.common.capabilities.Capability;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.network.IChemicalNetwork;
import org.cyclops.integratedtunnels.core.part.IPartTypeInterfacePositionedAddon;
import org.jetbrains.annotations.NotNull;

public class ChemicalHandlerPartState<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IChemicalHandler<CHEMICAL, STACK> {
    private final IPartTypeInterfacePositionedAddon.IState<IChemicalNetwork, IChemicalHandler<?, ?>, ?, ?> state;
    private final Capability<? extends IChemicalHandler<?, ? extends STACK>> handlerCapability;

    public ChemicalHandlerPartState(IPartTypeInterfacePositionedAddon.IState<IChemicalNetwork, IChemicalHandler<?, ?>, ?, ?> state, Capability<? extends IChemicalHandler<?, ? extends STACK>> handlerCapability) {
        this.state = state;
        this.handlerCapability = handlerCapability;
    }

    protected IChemicalHandler<CHEMICAL, STACK> getChemicalHandler() {
        return (IChemicalHandler)((IChemicalNetwork)this.state.getPositionedAddonsNetwork()).getChannelExternal(this.handlerCapability, this.state.getChannel());
    }

    public int getTanks() {
        if (!this.state.isNetworkAndPositionValid()) {
            return 0;
        }
        this.state.disablePosition();
        int ret = this.getChemicalHandler().getTanks();
        this.state.enablePosition();
        return ret;
    }

    public STACK getChemicalInTank(int tank) {
        if (!this.state.isNetworkAndPositionValid()) {
            return this.getEmptyStack();
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().getChemicalInTank(tank);
        this.state.enablePosition();
        return (STACK)ret;
    }

    public long getTankCapacity(int tank) {
        if (!this.state.isNetworkAndPositionValid()) {
            return 0L;
        }
        this.state.disablePosition();
        long ret = this.getChemicalHandler().getTankCapacity(tank);
        this.state.enablePosition();
        return ret;
    }

    public STACK extractChemical(int tank, long l, Action action) {
        if (!this.state.isNetworkAndPositionValid()) {
            return this.getEmptyStack();
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().extractChemical(tank, l, action);
        this.state.enablePosition();
        return (STACK)ret;
    }

    public STACK insertChemical(int tank, STACK stack, Action action) {
        if (!this.state.isNetworkAndPositionValid()) {
            return stack;
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().insertChemical(tank, stack, action);
        this.state.enablePosition();
        return (STACK)ret;
    }

    public boolean isValid(int tank, STACK stack) {
        if (!this.state.isNetworkAndPositionValid()) {
            return false;
        }
        this.state.disablePosition();
        boolean ret = this.getChemicalHandler().isValid(tank, stack);
        this.state.enablePosition();
        return ret;
    }

    public void setChemicalInTank(int tank, STACK stack) {
        if (this.state.isNetworkAndPositionValid()) {
            this.state.disablePosition();
            this.getChemicalHandler().setChemicalInTank(tank, stack);
            this.state.enablePosition();
        }
    }

    public STACK insertChemical(STACK stack, Action action) {
        if (!this.state.isNetworkAndPositionValid()) {
            return stack;
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().insertChemical(stack, action);
        this.state.enablePosition();
        return (STACK)ret;
    }

    public STACK extractChemical(long amount, Action action) {
        if (!this.state.isNetworkAndPositionValid()) {
            return this.getEmptyStack();
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().extractChemical(amount, action);
        this.state.enablePosition();
        return (STACK)ret;
    }

    public STACK extractChemical(STACK stack, Action action) {
        if (!this.state.isNetworkAndPositionValid()) {
            return this.getEmptyStack();
        }
        this.state.disablePosition();
        ChemicalStack ret = this.getChemicalHandler().extractChemical(stack, action);
        this.state.enablePosition();
        return (STACK)ret;
    }

    @NotNull
    public STACK getEmptyStack() {
        return (STACK)((ChemicalStack)MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK.getMatcher().getEmptyInstance());
    }
}

