/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.modcompat.integratedtunnels.part;

import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integratedmekanism.GeneralConfig;
import org.cyclops.integratedmekanism.network.IChemicalNetwork;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;
import org.jetbrains.annotations.NotNull;

public class PartStateChemical<P extends IPartTypeWriter>
extends PartStatePositionedAddon<P, IChemicalNetwork, ChemicalStack<?>> {
    public PartStateChemical(int inventorySize, boolean canReceive, boolean canExtract) {
        super(inventorySize, canReceive, canExtract);
    }

    public <T2> LazyOptional<T2> getCapability(Capability<T2> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        if (capability == Capabilities.GAS_HANDLER) {
            return LazyOptional.of(() -> new Handler(this, Capabilities.GAS_HANDLER)).cast();
        }
        if (capability == Capabilities.INFUSION_HANDLER) {
            return LazyOptional.of(() -> new Handler(this, Capabilities.INFUSION_HANDLER)).cast();
        }
        if (capability == Capabilities.PIGMENT_HANDLER) {
            return LazyOptional.of(() -> new Handler(this, Capabilities.PIGMENT_HANDLER)).cast();
        }
        if (capability == Capabilities.SLURRY_HANDLER) {
            return LazyOptional.of(() -> new Handler(this, Capabilities.SLURRY_HANDLER)).cast();
        }
        return super.getCapability(capability, network, partNetwork, target);
    }

    public static class Handler<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
    implements IChemicalHandler<CHEMICAL, STACK> {
        private final PartStateChemical<?> partState;
        private final Capability<? extends IChemicalHandler<?, ? extends STACK>> handlerCapability;

        public Handler(PartStateChemical<?> partState, Capability<? extends IChemicalHandler<?, ? extends STACK>> handlerCapability) {
            this.partState = partState;
            this.handlerCapability = handlerCapability;
        }

        protected IChemicalHandler<CHEMICAL, STACK> getChemicalHandler() {
            return (IChemicalHandler)((IChemicalNetwork)this.partState.getPositionedAddonsNetwork()).getChannelExternal(this.handlerCapability, TunnelHelpers.getPassiveInteractionChannel(this.partState));
        }

        public int getTanks() {
            return this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null ? this.getChemicalHandler().getTanks() : 0;
        }

        public STACK getChemicalInTank(int tank) {
            if (this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null) {
                ChemicalStack chemicalStack = this.getChemicalHandler().getChemicalInTank(tank);
                if (this.partState.getStorageFilter().testView((Object)chemicalStack)) {
                    return (STACK)chemicalStack;
                }
            }
            return this.getEmptyStack();
        }

        public void setChemicalInTank(int tank, STACK chemicalStack) {
            if (this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null && this.partState.getStorageFilter().testView(chemicalStack)) {
                this.getChemicalHandler().setChemicalInTank(tank, chemicalStack);
            }
        }

        public long getTankCapacity(int tank) {
            return this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null ? this.getChemicalHandler().getTankCapacity(tank) : 0L;
        }

        public boolean isValid(int tank, STACK chemicalStack) {
            return this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null && this.partState.getStorageFilter().testInsertion(chemicalStack) && this.getChemicalHandler().isValid(tank, chemicalStack);
        }

        protected STACK rateLimitFluid(STACK chemicalStack) {
            if (chemicalStack != null && chemicalStack.getAmount() > GeneralConfig.chemicalRateLimit) {
                chemicalStack = chemicalStack.copy();
                chemicalStack.setAmount(GeneralConfig.chemicalRateLimit);
                return chemicalStack;
            }
            return chemicalStack;
        }

        public STACK insertChemical(int tank, STACK chemicalStack, Action action) {
            return (STACK)(this.partState.canReceive() && this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null && this.partState.getStorageFilter().testInsertion(chemicalStack) ? this.getChemicalHandler().insertChemical(this.rateLimitFluid(chemicalStack), action) : chemicalStack);
        }

        public STACK extractChemical(int tank, long maxDrain, Action action) {
            if (this.partState.canExtract() && this.partState.getPositionedAddonsNetwork() != null && this.partState.getStorageFilter() != null) {
                ChemicalStack drainedSimulated;
                PositionedAddonsNetworkIngredientsFilter filter = this.partState.getStorageFilter();
                if (action.execute() && !filter.testExtraction((Object)(drainedSimulated = this.getChemicalHandler().extractChemical(Math.min(maxDrain, GeneralConfig.chemicalRateLimit), Action.SIMULATE)))) {
                    return this.getEmptyStack();
                }
                ChemicalStack drained = this.getChemicalHandler().extractChemical(Math.min(maxDrain, GeneralConfig.chemicalRateLimit), action);
                if (action.simulate() && !filter.testExtraction((Object)drained)) {
                    return this.getEmptyStack();
                }
                return (STACK)drained;
            }
            return this.getEmptyStack();
        }

        @NotNull
        public STACK getEmptyStack() {
            return (STACK)GasStack.EMPTY;
        }
    }
}

