/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.part.aspect;

import mekanism.api.Coord4D;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.radiation.IRadiationManager;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.part.aspect.read.AspectReadBuilders;
import org.cyclops.integratedmekanism.part.aspect.MekanismAspectReadBuilders;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;

public class MekanismAspects {

    public static final class Read {

        public static final class World {
            public static final IAspectRead<ValueTypeDouble.ValueDouble, ValueTypeDouble> DOUBLE_RADIATION = MekanismAspectReadBuilders.World.BUILDER_DOUBLE.handle(dimPos -> IRadiationManager.INSTANCE.getRadiationLevel(new Coord4D((double)dimPos.getBlockPos().m_123341_(), (double)dimPos.getBlockPos().m_123342_(), (double)dimPos.getBlockPos().m_123343_(), dimPos.getLevelKey()))).handle(AspectReadBuilders.PROP_GET_DOUBLE, "radiation").buildRead();
        }

        public static final class Machine {
            public static final IAspectRead<ValueTypeDouble.ValueDouble, ValueTypeDouble> DOUBLE_FISSIONREACTOR_DAMAGE = MekanismAspectReadBuilders.Machine.BUILDER_FISSIONREACTOR_DOUBLE.handle(reactor -> reactor.map(r -> r.reactorDamage).orElse(0.0)).handle(AspectReadBuilders.PROP_GET_DOUBLE, "damage").buildRead();
            public static final IAspectRead<ValueTypeDouble.ValueDouble, ValueTypeDouble> DOUBLE_FISSIONREACTOR_BURNRATE = MekanismAspectReadBuilders.Machine.BUILDER_FISSIONREACTOR_DOUBLE.handle(reactor -> reactor.map(r -> r.lastBurnRate).orElse(0.0)).handle(AspectReadBuilders.PROP_GET_DOUBLE, "burnrate").buildRead();
            public static final IAspectRead<ValueTypeDouble.ValueDouble, ValueTypeDouble> DOUBLE_FISSIONREACTOR_BURNRATEMAX = MekanismAspectReadBuilders.Machine.BUILDER_FISSIONREACTOR_DOUBLE.handle(reactor -> reactor.map(r -> r.getMaxBurnRate()).orElse(0.0)).handle(AspectReadBuilders.PROP_GET_DOUBLE, "burnratemax").buildRead();
            public static final IAspectRead<ValueTypeDouble.ValueDouble, ValueTypeDouble> DOUBLE_FISSIONREACTOR_BURNRATELIMIT = MekanismAspectReadBuilders.Machine.BUILDER_FISSIONREACTOR_DOUBLE.handle(reactor -> reactor.map(r -> r.rateLimit).orElse(0.0)).handle(AspectReadBuilders.PROP_GET_DOUBLE, "burnratelimit").buildRead();
            public static final IAspectRead<ValueTypeLong.ValueLong, ValueTypeLong> LONG_FISSIONREACTOR_HEATERATE = MekanismAspectReadBuilders.Machine.BUILDER_FISSIONREACTOR_LONG.handle(reactor -> reactor.map(r -> r.lastBoilRate).orElse(0L)).handle(AspectReadBuilders.PROP_GET_LONG, "heatingrate").buildRead();
            public static final IAspectRead<ValueTypeDouble.ValueDouble, ValueTypeDouble> DOUBLE_FISSIONREACTOR_HEATERATE = MekanismAspectReadBuilders.Machine.BUILDER_FISSIONREACTOR_DOUBLE.handle(reactor -> reactor.map(r -> r.lastEnvironmentLoss).orElse(0.0)).handle(AspectReadBuilders.PROP_GET_DOUBLE, "environmentloss").buildRead();
        }

        public static final class Chemical {
            public static final IAspectRead<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_FULL = MekanismAspectReadBuilders.Chemical.BUILDER_BOOLEAN.handle(tankInfo -> {
                boolean allFull = true;
                for (int i = 0; i < tankInfo.getTanks(); ++i) {
                    if ((!tankInfo.getChemicalInTank(i).isEmpty() || tankInfo.getTankCapacity(i) <= 0L) && (tankInfo.getChemicalInTank(i).isEmpty() || tankInfo.getChemicalInTank(i).getAmount() >= tankInfo.getTankCapacity(i))) continue;
                    allFull = false;
                }
                return allFull;
            }).handle(AspectReadBuilders.PROP_GET_BOOLEAN, "full").buildRead();
            public static final IAspectRead<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_EMPTY = MekanismAspectReadBuilders.Chemical.BUILDER_BOOLEAN.handle(tankInfo -> {
                for (int i = 0; i < tankInfo.getTanks(); ++i) {
                    if ((tankInfo.getChemicalInTank(i).isEmpty() || tankInfo.getTankCapacity(i) <= 0L) && (tankInfo.getChemicalInTank(i).isEmpty() || tankInfo.getChemicalInTank(i).getAmount() >= tankInfo.getTankCapacity(i))) continue;
                    return false;
                }
                return true;
            }).handle(AspectReadBuilders.PROP_GET_BOOLEAN, "empty").buildRead();
            public static final IAspectRead<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_NONEMPTY = MekanismAspectReadBuilders.Chemical.BUILDER_BOOLEAN.handle(tankInfo -> {
                boolean hasChemical = false;
                for (int i = 0; i < tankInfo.getTanks(); ++i) {
                    if (tankInfo.getChemicalInTank(i).isEmpty() || tankInfo.getChemicalInTank(i).getAmount() <= 0L) continue;
                    hasChemical = true;
                }
                return hasChemical;
            }).handle(AspectReadBuilders.PROP_GET_BOOLEAN, "nonempty").buildRead();
            public static final IAspectRead<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean> BOOLEAN_APPLICABLE = MekanismAspectReadBuilders.Chemical.BUILDER_BOOLEAN.handle(tankInfo -> tankInfo.getTanks() > 0).handle(AspectReadBuilders.PROP_GET_BOOLEAN, "applicable").buildRead();
            public static final IAspectRead<ValueTypeLong.ValueLong, ValueTypeLong> LONG_AMOUNT = MekanismAspectReadBuilders.Chemical.BUILDER_LONG_ACTIVATABLE.handle(MekanismAspectReadBuilders.Chemical.PROP_GET_CHEMICALSTACK).handle(ChemicalStack::getAmount).handle(AspectReadBuilders.PROP_GET_LONG, "amount").buildRead();
            public static final IAspectRead<ValueTypeLong.ValueLong, ValueTypeLong> LONG_AMOUNTTOTAL = MekanismAspectReadBuilders.Chemical.BUILDER_LONG.handle(tankInfo -> {
                long amount = 0L;
                for (int i = 0; i < tankInfo.getTanks(); ++i) {
                    amount += tankInfo.getChemicalInTank(i).getAmount();
                }
                return amount;
            }).handle(AspectReadBuilders.PROP_GET_LONG, "totalamount").buildRead();
            public static final IAspectRead<ValueTypeLong.ValueLong, ValueTypeLong> LONG_CAPACITY = MekanismAspectReadBuilders.Chemical.BUILDER_LONG_ACTIVATABLE.handle(tankInfo -> tankInfo != null ? ((IChemicalHandler)tankInfo.getLeft()).getTankCapacity(((Integer)tankInfo.getRight()).intValue()) : 0L).handle(AspectReadBuilders.PROP_GET_LONG, "capacity").buildRead();
            public static final IAspectRead<ValueTypeLong.ValueLong, ValueTypeLong> LONG_CAPACITYTOTAL = MekanismAspectReadBuilders.Chemical.BUILDER_LONG.handle(tankInfo -> {
                long capacity = 0L;
                for (int i = 0; i < tankInfo.getTanks(); ++i) {
                    capacity += tankInfo.getTankCapacity(i);
                }
                return capacity;
            }).handle(AspectReadBuilders.PROP_GET_LONG, "totalcapacity").buildRead();
            public static final IAspectRead<ValueTypeInteger.ValueInteger, ValueTypeInteger> INTEGER_TANKS = MekanismAspectReadBuilders.Chemical.BUILDER_INTEGER.handle(IChemicalHandler::getTanks).handle(AspectReadBuilders.PROP_GET_INTEGER, "tanks").buildRead();
            public static final IAspectRead<ValueTypeDouble.ValueDouble, ValueTypeDouble> DOUBLE_FILLRATIO = MekanismAspectReadBuilders.Chemical.BUILDER_DOUBLE_ACTIVATABLE.handle(tankInfo -> {
                if (tankInfo == null) {
                    return 0.0;
                }
                double amount = ((IChemicalHandler)tankInfo.getLeft()).getChemicalInTank(((Integer)tankInfo.getRight()).intValue()).getAmount();
                return amount / (double)((IChemicalHandler)tankInfo.getLeft()).getTankCapacity(((Integer)tankInfo.getRight()).intValue());
            }).handle(AspectReadBuilders.PROP_GET_DOUBLE, "fillratio").buildRead();
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_TANKCHEMICALS = AspectReadBuilders.BUILDER_LIST.byMod("integratedmekanism").appendKind("chemical").handle(MekanismAspectReadBuilders.Chemical.PROP_GET_LIST_CHEMICALSTACKS, "chemicalstacks").buildRead();
            public static final IAspectRead<ValueTypeList.ValueList, ValueTypeList> LIST_TANKCAPACITIES = AspectReadBuilders.BUILDER_LIST.byMod("integratedmekanism").appendKind("chemical").handle(MekanismAspectReadBuilders.Chemical.PROP_GET_LIST_CAPACITIES, "capacities").buildRead();
            public static final IAspectRead<ValueObjectTypeChemicalStack.ValueChemicalStack, ValueObjectTypeChemicalStack> CHEMICALSTACK = MekanismAspectReadBuilders.BUILDER_OBJECT_CHEMICALSTACK.handle(MekanismAspectReadBuilders.Chemical.PROP_GET_ACTIVATABLE, "chemical").withProperties(MekanismAspectReadBuilders.Chemical.PROPERTIES).handle(MekanismAspectReadBuilders.Chemical.PROP_GET_CHEMICALSTACK).handle(MekanismAspectReadBuilders.PROP_GET_CHEMICALSTACK).buildRead();
        }
    }
}

