/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.test;

import com.google.common.collect.Sets;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.providers.IGasProvider;
import mekanism.common.registries.MekanismGases;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.core.test.TestHelpers;
import org.cyclops.integratedmekanism.value.ValueObjectTypeChemicalStack;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.evaluate.ScriptHelpers;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class TestValueTranslators {
    private static Context CTX = null;
    private static IEvaluationExceptionFactory EF = ScriptHelpers.getDummyEvaluationExceptionFactory();

    @IntegrationBefore
    public void before() {
        try {
            CTX = ScriptHelpers.createPopulatedContext(null);
        }
        catch (EvaluationException e) {
            e.printStackTrace();
        }
    }

    public static Value getJsValue(String jsString) {
        return CTX.eval("js", (CharSequence)jsString);
    }

    @IntegrationTest
    public void testObjectChemical() throws EvaluationException {
        TestHelpers.assertEqual((Object)((Object)((ValueObjectTypeChemicalStack.ValueChemicalStack)ValueTranslators.REGISTRY.translateFromGraal(CTX, TestValueTranslators.getJsValue("exports = { id_chemical: { chemical: 'mekanism:gas', type: 'mekanism:steam', amount: 1000 } }"), EF))), (Object)((Object)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.STEAM, 1000L))), (String)"chemical raw value");
        Value translated = ValueTranslators.REGISTRY.translateToGraal(CTX, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.STEAM, 1000L)), EF);
        TestHelpers.assertEqual((Object)translated.hasMembers(), (Object)true, (String)"hasMembers true");
        TestHelpers.assertEqual((Object)translated.getMemberKeys(), (Object)Sets.newHashSet((Object[])new String[]{"id_chemical"}), (String)"member keys is correct");
        TestHelpers.assertEqual((Object)translated.getMember("id_chemical").hasMembers(), (Object)true, (String)"id_chemical hasMembers true");
        TestHelpers.assertEqual((Object)translated.getMember("id_chemical").getMemberKeys(), (Object)Sets.newHashSet((Object[])new String[]{"chemical", "type", "amount"}), (String)"id_chemical keys is correct");
        TestHelpers.assertEqual((Object)translated.getMember("id_chemical").getMember("chemical").asString(), (Object)"mekanism:gas", (String)"id_chemical has member chemical");
        TestHelpers.assertEqual((Object)translated.getMember("id_chemical").getMember("type").asString(), (Object)"mekanism:steam", (String)"id_chemical has member type");
        TestHelpers.assertEqual((Object)translated.getMember("id_chemical").getMember("amount").asInt(), (Object)1000, (String)"id_chemical has member amount");
    }

    @IntegrationTest
    public void testObjectChemicalMethods() throws EvaluationException {
        TestHelpers.assertEqual((Object)ValueTranslators.REGISTRY.translateToGraal(CTX, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.STEAM, 1000L)), EF).invokeMember("amount", new Object[0]).asInt(), (Object)1000, (String)"amount can be invoked for chemical stacks");
        TestHelpers.assertEqual((Object)ValueTranslators.REGISTRY.translateToGraal(CTX, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.STEAM, 123L)), EF).invokeMember("amount", new Object[0]).asInt(), (Object)123, (String)"amount can be invoked for chemical stacks");
    }

    @IntegrationTest
    public void testGlobalFunctions() throws EvaluationException {
        Value ops = CTX.getBindings("js").getMember("idContext").getMember("ops");
        TestHelpers.assertEqual((Object)ops.invokeMember("anyEquals", new Object[]{ValueTranslators.REGISTRY.translateToGraal(CTX, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.STEAM, 10L)), EF), ValueTranslators.REGISTRY.translateToGraal(CTX, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.STEAM, 20L)), EF)}).asBoolean(), (Object)false, (String)"anyEquals works for chemical stacks");
        TestHelpers.assertEqual((Object)ops.invokeMember("chemicalstackAmount", new Object[]{ValueTranslators.REGISTRY.translateToGraal(CTX, (IValue)ValueObjectTypeChemicalStack.ValueChemicalStack.of(new GasStack((IGasProvider)MekanismGases.STEAM, 1000L)), EF)}).asInt(), (Object)1000, (String)"chemicalstackAmount works for chemical stacks");
    }
}

