/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.value;

import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integratedmekanism.core.CapabilityHelpers;
import org.cyclops.integratedmekanism.core.ChemicalHelpers;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.value.MekanismValueTypes;

public class ValueObjectTypeChemicalStack
extends ValueObjectTypeBase<ValueChemicalStack>
implements IValueTypeNamed<ValueChemicalStack>,
IValueTypeUniquelyNamed<ValueChemicalStack>,
IValueTypeNullable<ValueChemicalStack> {
    public ValueObjectTypeChemicalStack() {
        super("chemicalstack", ValueChemicalStack.class);
    }

    protected String getModId() {
        return "integratedmekanism";
    }

    public ValueChemicalStack getDefault() {
        return ValueChemicalStack.of(GasStack.EMPTY);
    }

    public MutableComponent toCompactString(ValueChemicalStack value) {
        ChemicalStack<?> chemicalStack = value.getRawValue();
        return !chemicalStack.isEmpty() ? ((MutableComponent)chemicalStack.getTextComponent()).m_130946_(String.format(" (%s mB)", chemicalStack.getAmount())) : Component.m_237113_((String)"");
    }

    public Tag serialize(ValueChemicalStack value) {
        return MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK.getSerializer().serializeInstance(value.chemicalStack);
    }

    public ValueChemicalStack deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        if (value instanceof CompoundTag) {
            return ValueChemicalStack.of((ChemicalStack)MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK.getSerializer().deserializeInstance(value));
        }
        return null;
    }

    public String getName(ValueChemicalStack a) {
        return this.toCompactString(a).getString();
    }

    public boolean isNull(ValueChemicalStack a) {
        return a.getRawValue().isEmpty();
    }

    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement((IValueType)this, (ValueTypeItemStackLPElement.IItemStackToValue)new ValueTypeItemStackLPElement.IItemStackToValue<ValueChemicalStack>(){

            public boolean isNullable() {
                return true;
            }

            public Component validate(ItemStack itemStack) {
                return itemStack.m_41619_() || CapabilityHelpers.getChemicalHandler(itemStack).isPresent() ? null : Component.m_237115_((String)"valuetype.integratedmekanism.error.chemical.no_chemical");
            }

            public ValueChemicalStack getValue(ItemStack itemStack) {
                return ValueChemicalStack.of((ChemicalStack)CapabilityHelpers.getChemicalHandler(itemStack).map(handler -> handler.getTanks() > 0 ? handler.getChemicalInTank(0) : handler.getEmptyStack()).orElse(GasStack.EMPTY));
            }

            public ItemStack getValueAsItemStack(ValueChemicalStack value) {
                return ValueObjectTypeChemicalStack.valueToItemStack(value.getRawValue());
            }
        });
    }

    public static ItemStack valueToItemStack(ChemicalStack<?> chemicalStackRaw) {
        ItemStack itemStack = new ItemStack((ItemLike)MekanismBlocks.BASIC_CHEMICAL_TANK);
        if (chemicalStackRaw instanceof GasStack) {
            GasStack chemicalStack = (GasStack)chemicalStackRaw;
            itemStack.getCapability(Capabilities.GAS_HANDLER).ifPresent(handler -> handler.insertChemical((ChemicalStack)chemicalStack, Action.EXECUTE));
        } else if (chemicalStackRaw instanceof InfusionStack) {
            InfusionStack chemicalStack = (InfusionStack)chemicalStackRaw;
            itemStack.getCapability(Capabilities.INFUSION_HANDLER).ifPresent(handler -> handler.insertChemical((ChemicalStack)chemicalStack, Action.EXECUTE));
        } else if (chemicalStackRaw instanceof PigmentStack) {
            PigmentStack chemicalStack = (PigmentStack)chemicalStackRaw;
            itemStack.getCapability(Capabilities.PIGMENT_HANDLER).ifPresent(handler -> handler.insertChemical((ChemicalStack)chemicalStack, Action.EXECUTE));
        } else if (chemicalStackRaw instanceof SlurryStack) {
            SlurryStack chemicalStack = (SlurryStack)chemicalStackRaw;
            itemStack.getCapability(Capabilities.SLURRY_HANDLER).ifPresent(handler -> handler.insertChemical((ChemicalStack)chemicalStack, Action.EXECUTE));
        }
        return itemStack;
    }

    public String getUniqueName(ValueChemicalStack value) {
        ChemicalStack<?> chemicalStack = value.getRawValue();
        return !chemicalStack.isEmpty() ? String.format("%s %s", ChemicalHelpers.getStackRegistry(chemicalStack).getKey((Object)chemicalStack.getType()), chemicalStack.getAmount()) : "";
    }

    public static class ValueChemicalStack
    extends ValueBase {
        private final ChemicalStack<?> chemicalStack;

        private ValueChemicalStack(ChemicalStack<?> itemStack) {
            super((IValueType)MekanismValueTypes.OBJECT_CHEMICALSTACK);
            this.chemicalStack = Objects.requireNonNull(itemStack, "Attempted to create a ValueChemicalStack for a null ChemicalStack.");
        }

        public static ValueChemicalStack of(ChemicalStack<?> itemStack) {
            return new ValueChemicalStack(itemStack);
        }

        public ChemicalStack<?> getRawValue() {
            return this.chemicalStack;
        }

        public boolean equals(Object o) {
            return o instanceof ValueChemicalStack && this.getRawValue().isStackIdentical(((ValueChemicalStack)((Object)o)).getRawValue());
        }

        public int hashCode() {
            return this.chemicalStack.hashCode();
        }

        public String toString() {
            return "ValueChemicalStack{chemicalStack=" + String.valueOf(this.chemicalStack) + "}";
        }
    }
}

