/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.command.CommandTest;
import org.cyclops.integrateddynamics.core.event.IntegratedDynamicsSetupEvent;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.core.part.aspect.AspectRegistry;
import org.cyclops.integrateddynamics.infobook.OnTheDynamicsOfIntegrationBook;
import org.cyclops.integratedmekanism.Capabilities;
import org.cyclops.integratedmekanism.GeneralConfig;
import org.cyclops.integratedmekanism.RegistryEntries;
import org.cyclops.integratedmekanism.capability.recipehandler.MekanismCapabilityLoader;
import org.cyclops.integratedmekanism.client.render.value.ValueTypeWorldRenderersMekanism;
import org.cyclops.integratedmekanism.gametest.integration.TestChemicalStackOperators;
import org.cyclops.integratedmekanism.gametest.integration.TestEntityOperators;
import org.cyclops.integratedmekanism.gametest.integration.TestIngredientsOperators;
import org.cyclops.integratedmekanism.gametest.integration.TestItemStackOperators;
import org.cyclops.integratedmekanism.ingredient.IngredientComponentCapabilitiesMekanism;
import org.cyclops.integratedmekanism.ingredient.IngredientComponentHandlerChemical;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;
import org.cyclops.integratedmekanism.logicprogrammer.MekanismLogicProgrammerElementTypes;
import org.cyclops.integratedmekanism.modcompat.integratedrest.ModCompatIntegratedRest;
import org.cyclops.integratedmekanism.modcompat.integratedscripting.ModCompatIntegratedScripting;
import org.cyclops.integratedmekanism.modcompat.integratedterminals.ModCompatIntegratedTerminals;
import org.cyclops.integratedmekanism.modcompat.integratedtunnels.ModCompatIntegratedTunnels;
import org.cyclops.integratedmekanism.network.NetworkCapabilityConstructorsMekanism;
import org.cyclops.integratedmekanism.operator.MekanismOperators;
import org.cyclops.integratedmekanism.part.PartTypesMekanism;
import org.cyclops.integratedmekanism.part.aspect.MekanismAspects;
import org.cyclops.integratedmekanism.part.aspect.listproxy.MekanismValueTypeListProxyFactories;
import org.cyclops.integratedmekanism.proxy.ClientProxy;
import org.cyclops.integratedmekanism.proxy.CommonProxy;
import org.cyclops.integratedmekanism.value.MekanismValueTypes;

@Mod(value="integratedmekanism")
public class IntegratedMekanism
extends ModBaseVersionable<IntegratedMekanism> {
    public static IntegratedMekanism _instance;

    public IntegratedMekanism(IEventBus modEventBus) {
        super("integratedmekanism", instance -> {
            _instance = instance;
        }, modEventBus);
        modEventBus.addListener(EventPriority.LOW, this::onRegistriesLoad);
        modEventBus.addListener(EventPriority.LOW, this::afterCapabilitiesLoaded);
        modEventBus.addListener(this::onSetup);
        modEventBus.addListener(this::onRegistriesCreate);
        modEventBus.addListener(Capabilities::registerPartCapabilities);
    }

    public void onRegistriesCreate(NewRegistryEvent event) {
        IngredientComponentCapabilitiesMekanism.load();
        PartTypesMekanism.load();
        MekanismCapabilityLoader.load();
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
        super.loadModCompats(modCompatLoader);
        modCompatLoader.addModCompat((IModCompat)new ModCompatIntegratedTunnels());
        modCompatLoader.addModCompat((IModCompat)new ModCompatIntegratedTerminals());
        modCompatLoader.addModCompat((IModCompat)new ModCompatIntegratedScripting());
        modCompatLoader.addModCompat((IModCompat)new ModCompatIntegratedRest());
    }

    protected void onRegistriesLoad(RegisterEvent event) {
        event.register(IngredientComponent.REGISTRY.key(), MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK.getName(), () -> MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK);
        IngredientComponentHandlers.REGISTRY.register((IIngredientComponentHandler)new IngredientComponentHandlerChemical());
    }

    protected void afterCapabilitiesLoaded(InterModEnqueueEvent event) {
        MekanismIngredientComponents.registerStorageWrapperHandlers();
    }

    protected void onSetup(IntegratedDynamicsSetupEvent event) {
        MekanismValueTypeListProxyFactories.load();
        MekanismValueTypes.load();
        MekanismOperators.load();
        MekanismLogicProgrammerElementTypes.load();
        AspectRegistry.getInstance().register((IPartType)PartTypes.WORLD_READER, (Collection)Lists.newArrayList((Object[])new IAspect[]{MekanismAspects.Read.World.DOUBLE_RADIATION}));
        AspectRegistry.getInstance().register((IPartType)PartTypes.MACHINE_READER, (Collection)Lists.newArrayList((Object[])new IAspect[]{MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_DAMAGE, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_BURNRATE, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_BURNRATEMAX, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_BURNRATELIMIT, MekanismAspects.Read.Machine.LONG_FISSIONREACTOR_HEATERATE, MekanismAspects.Read.Machine.DOUBLE_FISSIONREACTOR_ENVIRONMENTLOSS}));
        CommandTest.CLASSES.addAll(List.of(TestChemicalStackOperators.class.getName(), TestIngredientsOperators.class.getName(), TestItemStackOperators.class.getName(), TestEntityOperators.class.getName()));
        if (MinecraftHelpers.isClientSide()) {
            ValueTypeWorldRenderersMekanism.load();
        }
        this.getModEventBus().addListener(new NetworkCapabilityConstructorsMekanism()::onNetworkLoad);
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBase)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.manual", "/data/integratedmekanism/info/mekanism_info.xml");
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBase)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.tutorials", "/data/integratedmekanism/info/mekanism_tutorials.xml");
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.PART_CHEMICAL_READER));
    }

    public void onConfigsRegister(ConfigHandler configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfig)new GeneralConfig());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    public static void clog(String message) {
        IntegratedMekanism.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

