/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.TestFunction;
import net.neoforged.neoforge.gametest.GameTestHolder;
import org.apache.commons.compress.utils.Lists;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integratedmekanism.gametest.integration.TestChemicalStackOperators;
import org.cyclops.integratedmekanism.gametest.integration.TestIngredientsOperators;
import org.cyclops.integratedmekanism.gametest.integration.TestItemStackOperators;

@GameTestHolder(value="integratedmekanism")
public class GameTester {
    public static GameTestHelper GAME_TEST_HELPER;

    @GameTestGenerator
    public Collection<TestFunction> integrationTests() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ArrayList testsList = Lists.newArrayList();
        for (String className : List.of(TestChemicalStackOperators.class.getName(), TestIngredientsOperators.class.getName(), TestItemStackOperators.class.getName())) {
            Class<?> clazz = Class.forName(className);
            Object testInstance = clazz.newInstance();
            LinkedList befores = com.google.common.collect.Lists.newLinkedList();
            LinkedList tests = com.google.common.collect.Lists.newLinkedList();
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(IntegrationBefore.class)) {
                    befores.add(method);
                }
                if (!method.isAnnotationPresent(IntegrationTest.class)) continue;
                tests.add(method);
            }
            for (Method test : tests) {
                String testName = className.replace("org.cyclops.integratedmekanism.gametest.integration.", "") + "#" + test.getName();
                testsList.add(new TestFunction("defaultBatch", testName, "integratedmekanism:test", 1, 1L, true, gameTestHelpers -> gameTestHelpers.succeedIf(() -> {
                    GAME_TEST_HELPER = gameTestHelpers;
                    try {
                        for (Method before : befores) {
                            before.invoke(testInstance, new Object[0]);
                        }
                        test.invoke(testInstance, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        Class excepted = test.getAnnotation(IntegrationTest.class).expected();
                        if (!excepted.isInstance(e.getTargetException())) {
                            if (e.getTargetException() instanceof IllegalStateException || e.getTargetException() instanceof AssertionError) {
                                e.getTargetException().printStackTrace();
                                throw new GameTestAssertException("Test " + testName + " failed!");
                            }
                            e.getTargetException().printStackTrace();
                            throw new GameTestAssertException(String.format("Expected at %s exception %s, but found:", testName, e));
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        throw new GameTestAssertException(e.getMessage());
                    }
                })));
            }
        }
        return testsList;
    }
}

