/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.gametest;

import mekanism.generators.common.registries.GeneratorsBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.integratedmekanism.gametest.GameTestsAspectsReadMachineFission;

@GameTestHolder(value="integratedmekanism")
@PrefixGameTestTemplate(value=false)
public class GameTestsCapabilitiesTemperature {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="empty10")
    public void testBlockTemperatureCapFissionReactorInvalid(GameTestHelper helper) {
        helper.setBlock(POS, (Block)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER.get());
        helper.succeedIf(() -> {
            ITemperature temperature = (ITemperature)helper.getLevel().getCapability(Capabilities.Temperature.BLOCK, helper.absolutePos(POS), (Object)Direction.NORTH);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)0.0, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)0.0, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)0.0, "Temperature default does not match");
        });
    }

    @GameTest(template="empty10")
    public void testBlockTemperatureCapFissionReactorValid(GameTestHelper helper) {
        BlockPos ioPos = GameTestsAspectsReadMachineFission.build(helper, POS);
        helper.succeedIf(() -> {
            ITemperature temperature = (ITemperature)helper.getLevel().getCapability(Capabilities.Temperature.BLOCK, helper.absolutePos(ioPos), (Object)Direction.NORTH);
            helper.assertTrue(temperature != null, "Temperature handler does not exist");
            helper.assertValueEqual((Object)temperature.getTemperature(), (Object)0.0, "Temperature does not match");
            helper.assertValueEqual((Object)temperature.getMaximumTemperature(), (Object)Double.MAX_VALUE, "Temperature max does not match");
            helper.assertValueEqual((Object)temperature.getMinimumTemperature(), (Object)0.0, "Temperature min does not match");
            helper.assertValueEqual((Object)temperature.getDefaultTemperature(), (Object)0.0, "Temperature default does not match");
        });
    }
}

