/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.capability.recipehandler;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedmekanism.capability.recipehandler.MekanismRecipeHandler;

public class FluidToFluidRecipeHandler
extends MekanismRecipeHandler<FluidToFluidRecipe> {
    protected FluidToFluidRecipeHandler(IMekanismRecipeTypeProvider<? extends FluidToFluidRecipe, ?> recipeType, Supplier<Level> levelSupplier) {
        super(recipeType, levelSupplier, Set.of(IngredientComponents.FLUIDSTACK), Set.of(IngredientComponents.FLUIDSTACK));
    }

    public boolean isValidSizeInput(IngredientComponent<?, ?> ingredientComponent, int size) {
        return ingredientComponent == IngredientComponents.FLUIDSTACK && size == 1;
    }

    @Override
    protected void recipeToInputs(FluidToFluidRecipe recipe, Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs) {
        inputs.put(IngredientComponents.FLUIDSTACK, List.of(new PrototypedIngredientAlternativesList(FluidToFluidRecipeHandler.getPrototypesFromFluidIngredient((InputIngredient<FluidStack>)recipe.getInput()))));
    }

    @Override
    protected void recipeToOutputs(FluidToFluidRecipe recipe, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        outputs.put(IngredientComponents.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{(FluidStack)recipe.getOutputDefinition().get(0)}));
    }

    @Override
    protected void recipeToOutputsSimulated(FluidToFluidRecipe recipe, IMixedIngredients input, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        outputs.put(IngredientComponents.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{recipe.getOutput((FluidStack)input.getInstances(IngredientComponents.FLUIDSTACK).get(0))}));
    }

    @Override
    protected boolean doesRecipeMatchInput(FluidToFluidRecipe recipe, IMixedIngredients input) {
        return recipe.getInput().test((Object)((FluidStack)input.getInstances(IngredientComponents.FLUIDSTACK).get(0)));
    }
}

