/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedmekanism.capability.recipehandler;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integratedmekanism.capability.recipehandler.MekanismRecipeHandler;
import org.cyclops.integratedmekanism.ingredient.MekanismIngredientComponents;

public class PressurizedReactionRecipeHandler
extends MekanismRecipeHandler<PressurizedReactionRecipe> {
    protected PressurizedReactionRecipeHandler(Supplier<Level> levelSupplier) {
        super(MekanismRecipeType.REACTION, levelSupplier, Set.of(IngredientComponents.ITEMSTACK, IngredientComponents.FLUIDSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK), Set.of(IngredientComponents.ITEMSTACK, MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK));
    }

    public boolean isValidSizeInput(IngredientComponent<?, ?> ingredientComponent, int size) {
        return ingredientComponent == IngredientComponents.ITEMSTACK && size == 1 || ingredientComponent == IngredientComponents.FLUIDSTACK && size == 1 || ingredientComponent == MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK && size == 1;
    }

    @Override
    protected void recipeToInputs(PressurizedReactionRecipe recipe, Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> inputs) {
        inputs.put(IngredientComponents.ITEMSTACK, List.of(new PrototypedIngredientAlternativesList(PressurizedReactionRecipeHandler.getPrototypesFromItemIngredient((InputIngredient<ItemStack>)recipe.getInputSolid()))));
        inputs.put(IngredientComponents.FLUIDSTACK, List.of(new PrototypedIngredientAlternativesList(PressurizedReactionRecipeHandler.getPrototypesFromFluidIngredient((InputIngredient<FluidStack>)recipe.getInputFluid()))));
        inputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, List.of(new PrototypedIngredientAlternativesList(PressurizedReactionRecipeHandler.getPrototypesFromChemicalIngredient(recipe.getInputGas()))));
    }

    @Override
    protected void recipeToOutputs(PressurizedReactionRecipe recipe, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        PressurizedReactionRecipe.PressurizedReactionRecipeOutput out = (PressurizedReactionRecipe.PressurizedReactionRecipeOutput)recipe.getOutputDefinition().get(0);
        if (!out.item().m_41619_()) {
            outputs.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{out.item()}));
        }
        if (!out.gas().isEmpty()) {
            outputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, Lists.newArrayList((Object[])new GasStack[]{out.gas()}));
        }
    }

    @Override
    protected void recipeToOutputsSimulated(PressurizedReactionRecipe recipe, IMixedIngredients input, Map<IngredientComponent<?, ?>, List<?>> outputs) {
        GasStack gasStack;
        ChemicalStack chemicalStack = (ChemicalStack)input.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).get(0);
        PressurizedReactionRecipe.PressurizedReactionRecipeOutput out = recipe.getOutput((ItemStack)input.getInstances(IngredientComponents.ITEMSTACK).get(0), (FluidStack)input.getInstances(IngredientComponents.FLUIDSTACK).get(0), chemicalStack instanceof GasStack ? (gasStack = (GasStack)chemicalStack) : GasStack.EMPTY);
        outputs.put(IngredientComponents.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{out.item()}));
        outputs.put(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK, Lists.newArrayList((Object[])new GasStack[]{out.gas()}));
    }

    @Override
    protected boolean doesRecipeMatchInput(PressurizedReactionRecipe recipe, IMixedIngredients input) {
        return recipe.getInputSolid().test((Object)((ItemStack)input.getInstances(IngredientComponents.ITEMSTACK).get(0))) && recipe.getInputFluid().test((Object)((FluidStack)input.getInstances(IngredientComponents.FLUIDSTACK).get(0))) && recipe.getInputGas().test(input.getInstances(MekanismIngredientComponents.INGREDIENT_CHEMICALSTACK).get(0));
    }
}

